/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

public class JavaScriptException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String fileName;
    private int lineNumber;
    private int columnNumber;

    public JavaScriptException(String s) {
        super(s);
        this.fileName = null;
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public JavaScriptException(Exception e) {
        super(e);
        this.fileName = null;
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public JavaScriptException(String message, String fileName, int lineNumber) {
        super(message);
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.columnNumber = -1;
    }

    public JavaScriptException(String message, String fileName, int lineNumber, int columnNumber) {
        super(message);
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    @Override
    public String getMessage() {
        StringBuilder ret = new StringBuilder(super.getMessage());
        if (this.fileName != null) {
            ret.append(" in " + this.fileName);
            if (this.lineNumber != -1) {
                ret.append(" at line number ").append(this.lineNumber);
            }
            if (this.columnNumber != -1) {
                ret.append(" at column number ").append(this.columnNumber);
            }
        }
        return ret.toString();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getFileName() {
        return this.fileName;
    }
}

