/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.AbstractDigester;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.BCUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class JavaDigester
extends AbstractDigester {
    MessageDigest digester;

    public JavaDigester(String digestAlgorithm) throws PDFSignatureException {
        this.digestMethod = digestAlgorithm;
        this.initDigester();
    }

    @Override
    protected void initDigester() throws PDFSignatureException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            this.digester = MessageDigest.getInstance(this.digestMethod, BCUtilities.provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PDFSignatureException(e.getCause());
        }
    }

    @Override
    public byte[] calculateDigest() throws PDFSignatureException {
        return this.digester.digest();
    }

    @Override
    public int getSize() throws PDFSignatureException {
        return this.digester.getDigestLength();
    }

    @Override
    public void feedDataToDigester(InputStream ibs) throws PDFIOException {
        byte[] chunk = new byte[8192];
        try {
            while (ibs.available() > 0) {
                int numBytesRead = ibs.read(chunk);
                this.digester.update(chunk, 0, numBytesRead);
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }
}

