/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.impl.barcode;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFPaperMetaData;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldBarcode;
import com.adobe.internal.pdftoolkit.services.ap.impl.barcode.BarcodeUtils;
import com.adobe.internal.pdftoolkit.services.imageconversion.ImageManager;
import com.adobe.xfa.pmp.common.BarcodeEncoder;
import com.adobe.xfa.pmp.common.BarcodeEncoderException;
import com.adobe.xfa.pmp.common.BarcodeEncoderFactory;
import com.adobe.xfa.pmp.common.BarcodeGenerationParams;
import com.adobe.xfa.pmp.common.BarcodeType;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.Deflater;

public class PMDBarcode {
    private static final ASName HELVETICA_FONT_KEY = ASName.create("Helv");
    private static final double CAPTION_HEIGHT = 6.0;
    private static final ASName BARCODE_IMAGE_NAME = ASName.create("PmdIm");

    private static PDFXObjectForm getAppearanceXObject(PDFXObjectImage image, PDFAnnotationWidget annot, String caption, double resolution) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException, PDFConfigurationException, PDFParseException {
        PDFXObjectForm appXObj = PDFXObjectForm.newInstance(annot.getPDFDocument());
        appXObj.setResources(PDFResources.newInstance(annot.getPDFDocument()));
        ContentWriter writer = ContentWriter.newInstance(annot.getPDFDocument());
        if (image == null) {
            PMDBarcode.SafeFillGray(annot, writer);
            appXObj.setBBox(PDFRectangle.newInstance(annot.getPDFDocument(), 0.0, 0.0, annot.getRect().width(), annot.getRect().height()));
            appXObj.setContents(writer.close().getContents());
            return appXObj;
        }
        double captionHeight = 0.0;
        if (caption != null && caption.trim().length() != 0) {
            captionHeight = 6.0;
        }
        double fieldWidth = 72.0 * (double)image.getWidth() / resolution;
        double fieldHeight = 72.0 * (double)image.getHeight() / resolution;
        writer.write(InstructionFactory.newGSave());
        appXObj.setBBox(PDFRectangle.newInstance(annot.getPDFDocument(), 0.0, 0.0, fieldWidth, fieldHeight));
        double mtxh = 0.0;
        double mtxv = 0.0;
        double mtxc = 0.0;
        double mtxb = 0.0;
        double mtxa = fieldWidth;
        double mtxd = fieldHeight;
        writer.write(InstructionFactory.newConcatMatrix(mtxa, mtxb, mtxc, mtxd -= captionHeight, mtxh, mtxv += captionHeight));
        writer.write(InstructionFactory.newInvokeNamedXObject(BARCODE_IMAGE_NAME));
        appXObj.getResources().procureXObjectMap().put(BARCODE_IMAGE_NAME, image);
        writer.write(InstructionFactory.newGRestore());
        if (caption != null && caption.trim().length() > 0) {
            PDFFont font;
            writer.write(InstructionFactory.newBeginText());
            writer.write(InstructionFactory.newTextPosition(0.0, 0.0));
            PDFFontSimple helveticaFont = null;
            PDFResources acroformResources = annot.getPDFDocument().getInteractiveForm().getResources();
            if (acroformResources != null && (font = acroformResources.getFont(HELVETICA_FONT_KEY)) != null) {
                helveticaFont = PDFFontSimple.getInstance(font.getCosObject(), ASName.k_Type1);
            }
            if (helveticaFont == null) {
                helveticaFont = PDFFontSimple.newInstance(annot.getPDFDocument(), ASName.k_Helvetica, ASName.k_Type1);
                if (acroformResources == null) {
                    acroformResources = PDFResources.newInstance(annot.getPDFDocument());
                    annot.getPDFDocument().getInteractiveForm().setResources(acroformResources);
                }
                acroformResources.procureFontMap().put(HELVETICA_FONT_KEY, helveticaFont);
            }
            appXObj.getResources().procureFontMap().put(HELVETICA_FONT_KEY, helveticaFont);
            ASRectangle rect = new ASRectangle(0.0, 1.0, fieldWidth, captionHeight);
            BarcodeUtils.flowEx(writer, caption, helveticaFont, rect);
            writer.write(InstructionFactory.newEndText());
        }
        appXObj.setContents(writer.close().getContents());
        return appXObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PDFXObjectForm updateImage(PDFPaperMetaData paperMetaData, PDFAnnotationWidget annot, PDFFieldBarcode barcodeField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, BarcodeEncoderException, PDFInvalidParameterException, PDFFontException, PDFConfigurationException, PDFParseException {
        BarcodeType barcodeType;
        BarcodeGenerationParams genParams = PMDBarcode.populateBarcodeParameters(paperMetaData);
        List valueList = barcodeField.getValueList();
        if (valueList == null || valueList.size() == 0) {
            return null;
        }
        String messageStr = (String)valueList.get(0);
        char[] message = null;
        PDFFieldBarcode.DataPrep dataPrep = barcodeField.getDataPrep();
        if (dataPrep == PDFFieldBarcode.DataPrep.DATA_COMPRESSED_FIRST) {
            byte[] input;
            try {
                input = messageStr.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                throw new PDFIOException(e1);
            }
            Deflater compressor = new Deflater();
            compressor.setInput(input);
            compressor.finish();
            ByteArrayOutputStream bos = null;
            try {
                bos = new ByteArrayOutputStream(input.length);
                byte[] buf = new byte[1024];
                while (!compressor.finished()) {
                    int count = compressor.deflate(buf);
                    bos.write(buf, 0, count);
                }
            }
            finally {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    throw new PDFIOException(e);
                }
            }
            byte[] compressedData = bos.toByteArray();
            message = new char[compressedData.length + 2];
            message[0] = 129;
            message[1] = '\u0001';
            for (int i = 0; i < compressedData.length; ++i) {
                message[i + 2] = (char)(compressedData[i] & 0xFF);
            }
        } else {
            byte[] messageBytes = null;
            try {
                messageBytes = messageStr.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new PDFIOException(e);
            }
            message = new char[messageBytes.length];
            for (int i = 0; i < messageBytes.length; ++i) {
                message[i] = (char)(messageBytes[i] & 0xFF);
            }
        }
        if ((barcodeType = BarcodeType.getInstance(genParams.getSymbology())) == null) {
            throw new PDFInvalidParameterException("Invalid barcode Type " + genParams.getSymbology());
        }
        BarcodeEncoder barcodeEncoder = BarcodeEncoderFactory.getEncoder(barcodeType);
        BufferedImage barcodeImage = null;
        try {
            barcodeImage = barcodeEncoder.encode(message, genParams);
        }
        catch (BarcodeEncoderException compressedData) {
            // empty catch block
        }
        PDFXObjectImage image = null;
        if (barcodeImage != null) {
            image = ImageManager.getPDFImage(barcodeImage, annot.getPDFDocument());
        }
        return PMDBarcode.getAppearanceXObject(image, annot, genParams.getCaption(), genParams.getResolution());
    }

    private static void SafeFillGray(PDFAnnotationWidget pdan, ContentWriter writer) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        ASRectangle bbRect = PMDBarcode.MoveRectToOrigin(pdan.getRect().getRectangle());
        PMDBarcode.SafeFillGray(writer, bbRect);
    }

    private static ASRectangle MoveRectToOrigin(ASRectangle rect) {
        return new ASRectangle(0.0, 0.0, rect.right() - rect.left(), rect.top() - rect.bottom());
    }

    private static void SafeFillGray(ContentWriter writer, ASRectangle bbRect) throws PDFIOException, PDFInvalidParameterException {
        writer.write(InstructionFactory.newGSave());
        writer.write(InstructionFactory.newRectangle(bbRect.left(), bbRect.bottom(), bbRect.width(), bbRect.height()));
        writer.write(InstructionFactory.newColorFill(new double[]{0.75}));
        writer.write(InstructionFactory.newFillPath());
        writer.write(InstructionFactory.newGRestore());
    }

    private static BarcodeGenerationParams populateBarcodeParameters(PDFPaperMetaData paperMetaData) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        BarcodeGenerationParams genParams = new BarcodeGenerationParams();
        if (paperMetaData.hasECC()) {
            genParams.setEccLevel(paperMetaData.getECC());
        }
        if (paperMetaData.hasXSymWidth()) {
            genParams.setXSymbolWidth(paperMetaData.getXSymWidth());
        }
        if (paperMetaData.hasXSymHeight()) {
            genParams.setXSymbolHeight(paperMetaData.getXSymHeight());
        }
        if (paperMetaData.hasWidth()) {
            genParams.setWidth(paperMetaData.getWidth());
        }
        if (paperMetaData.hasHeight()) {
            genParams.setHeight(paperMetaData.getHeight());
        }
        if (paperMetaData.hasResolution()) {
            genParams.setResolution((int)paperMetaData.getResolution());
        }
        if (paperMetaData.hasCaption()) {
            genParams.setCaption(paperMetaData.getCaption().stringValue());
        }
        if (paperMetaData.hasVersion()) {
            genParams.setVersion((int)paperMetaData.getVersion());
        }
        genParams.setSymbology(paperMetaData.getSymbology().asString());
        return genParams;
    }
}

