/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.CaptureResolutionBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.DefaultDisplayResolutionBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxType;
import java.io.IOException;

public class ResolutionBox
extends Jpeg2000Box {
    private CaptureResolutionBox captureResolutionBox;
    private DefaultDisplayResolutionBox defaultDisplayResolutionBox;

    ResolutionBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public CaptureResolutionBox getCaptureResolutionBox() throws IOException {
        this.lazilyPopulateFields();
        return this.captureResolutionBox;
    }

    public DefaultDisplayResolutionBox getDefaultDisplayResolutionBox() throws IOException {
        this.lazilyPopulateFields();
        return this.defaultDisplayResolutionBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            while (boxContents.bytesAvailable() > 0L) {
                Jpeg2000BoxInfo innerBoxInfo = new Jpeg2000BoxInfo(boxContents);
                Jpeg2000BoxType innerBoxType = innerBoxInfo.getType();
                if (innerBoxType == null) continue;
                switch (innerBoxType) {
                    case captureResolutionBox: {
                        this.captureResolutionBox = new CaptureResolutionBox(innerBoxInfo);
                        break;
                    }
                    case defaultDisplayResolutionBox: {
                        this.defaultDisplayResolutionBox = new DefaultDisplayResolutionBox(innerBoxInfo);
                    }
                }
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        try {
            if (this.captureResolutionBox != null) {
                this.captureResolutionBox.close();
            }
        }
        finally {
            try {
                if (this.defaultDisplayResolutionBox != null) {
                    this.defaultDisplayResolutionBox.close();
                }
            }
            finally {
                this.boxInfo.clearContents();
            }
        }
    }
}

