/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurement3DC;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurementAD3;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurementLD3;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurementPD3;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurementRD3;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurementUnknown;

public abstract class PDF3DMeasurement
extends PDFCosDictionary {
    protected PDF3DMeasurement(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDF3DMeasurement getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        CosName cosSubtype = (CosName)((CosDictionary)cosObject).get(ASName.k_Subtype);
        if (cosSubtype == null) {
            return PDF3DMeasurementUnknown.getInstance(cosObject);
        }
        ASName nameSubtype = cosSubtype.nameValue();
        PDF3DMeasurement pdfObject = null;
        if (nameSubtype == ASName.k_LD3) {
            pdfObject = PDF3DMeasurementLD3.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_PD3) {
            pdfObject = PDF3DMeasurementPD3.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_AD3) {
            pdfObject = PDF3DMeasurementAD3.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_RD3) {
            pdfObject = PDF3DMeasurementRD3.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_3DC) {
            pdfObject = PDF3DMeasurement3DC.getInstance(cosObject);
        }
        if (pdfObject == null) {
            pdfObject = PDF3DMeasurementUnknown.getInstance(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, ASName.k_3DMeasure);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Subtype);
    }

    public void setSubtype(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Subtype is a required key therefore cannot be removed.");
        }
        if (!(value.equals(ASName.k_LD3) || value.equals(ASName.k_PD3) || value.equals(ASName.k_AD3) || value.equals(ASName.k_RD3) || value.equals(ASName.k_3DC))) {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Subtype.");
        }
        this.setDictionaryNameValue(ASName.k_Subtype, value);
    }

    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Subtype);
    }

    public PDFText getTRL() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(ASName.k_TRL));
    }

    public void setTRL(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryTextValue(ASName.k_TRL, value);
    }

    public boolean hasTRL() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_TRL);
    }
}

