/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.prepress;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.util.ListIterator;

public class PDFPrepressUtils {
    static boolean validateColorSpaceArray(CosArray value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (value.size() != 4 && value.size() != 5) {
            return false;
        }
        CosObject colorSpaceFamilyName = value.get(0);
        if (value.size() == 5 && !ASName.k_DeviceN.equals(colorSpaceFamilyName)) {
            return false;
        }
        return ASName.k_DeviceN.equals(colorSpaceFamilyName) || ASName.k_Separation.equals(colorSpaceFamilyName);
    }

    static boolean validatePagesArray(CosArray value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ListIterator<CosObject> cosArrIterator = value.listIterator();
        while (cosArrIterator.hasNext()) {
            CosObject currentCosObj = (CosObject)cosArrIterator.next();
            if (currentCosObj.getType() == 6) {
                CosDictionary currentPageDict = (CosDictionary)currentCosObj;
                CosObject typeValue = currentPageDict.get(ASName.k_Type);
                if (ASName.k_Page.equals(typeValue)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

