/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosNumeric;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFInk;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFInkList;
import java.util.ArrayList;

public class PDFAnnotationInk
extends PDFAnnotationMarkup {
    private PDFAnnotationInk(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    private PDFAnnotationInk(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_Ink);
    }

    public static PDFAnnotationInk newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationInk(pdfDocument);
    }

    public static PDFAnnotationInk newInstance(PDFDocument pdfDocument, PDFInkList inks) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationInk pdfObject = PDFAnnotationInk.newInstance(pdfDocument);
        pdfObject.setInkList(inks);
        return pdfObject;
    }

    public static PDFAnnotationInk getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationInk pdfObject = (PDFAnnotationInk)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationInk.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationInk(cosObject);
        }
        return pdfObject;
    }

    public PDFInkList getInkList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFInkList.getInstance(this.getDictionaryCosObjectValue(ASName.k_InkList));
    }

    public boolean hasInkList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_InkList);
    }

    public PDFInkList procureInkList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasInkList()) {
            return this.getInkList();
        }
        PDFInkList newInkList = PDFInkList.newInstance(this.getPDFDocument());
        this.setInkList(newInkList);
        return newInkList;
    }

    public void setInkList(PDFInkList inks) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (inks == null) {
            throw new PDFInvalidDocumentException("Invalid Parameter");
        }
        this.setDictionaryArrayValue(ASName.k_InkList, inks.getCosArray());
    }

    private void transformInkList(ASMatrix matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.hasInkList()) {
            PDFDocument pdfDocument = this.getPDFDocument();
            PDFInkList inkList = this.getInkList();
            PDFInkList newInkList = PDFInkList.newInstance(pdfDocument);
            for (int arrayCounter = 0; arrayCounter < inkList.size(); ++arrayCounter) {
                PDFInk ink = (PDFInk)inkList.get(arrayCounter);
                ArrayList<Double> newInkArrayList = new ArrayList<Double>();
                for (int i = 0; i < ink.size(); i += 2) {
                    double x = ((PDFCosNumeric)ink.get(i)).doubleValue();
                    double y = ((PDFCosNumeric)ink.get(i + 1)).doubleValue();
                    ASCoordinate point = new ASCoordinate(x, y);
                    ASCoordinate newPoint = point.transform(matrix);
                    Double newX = new Double(newPoint.x());
                    Double newY = new Double(newPoint.y());
                    newInkArrayList.add(i, newX);
                    newInkArrayList.add(i + 1, newY);
                }
                PDFInk newInk = PDFInk.getInstance(PDFCosObject.makeCosArray(pdfDocument, newInkArrayList));
                newInkList.add(arrayCounter, newInk);
            }
            this.setInkList(newInkList);
        }
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.transformInkList(matrix);
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }
}

