/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.xobject;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectColorMask;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;

public class PDFXObjectImageMask
extends PDFCosObject {
    private PDFXObjectImageMask(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFXObjectImageMask getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFXObjectImageMask pdfObject = (PDFXObjectImageMask)PDFCosObject.getCachedInstance(cosObject, PDFXObjectImageMask.class);
        if (pdfObject == null) {
            pdfObject = new PDFXObjectImageMask(cosObject);
        }
        return pdfObject;
    }

    public static PDFXObjectImageMask newInstance(PDFDocument doc, PDFXObjectImage imageMask) throws PDFInvalidDocumentException {
        return new PDFXObjectImageMask(imageMask.getCosObject());
    }

    public static PDFXObjectImageMask newInstance(PDFDocument doc, PDFXObjectColorMask colorMask) throws PDFInvalidDocumentException {
        return new PDFXObjectImageMask(colorMask.getCosObject());
    }

    public PDFXObjectImage getImageMask() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosObject().getType() != 7) {
            return null;
        }
        return PDFXObjectImage.getInstance(this.getCosObject());
    }

    public PDFXObjectColorMask getColorMask() throws PDFInvalidDocumentException {
        if (this.getCosObject().getType() != 5) {
            return null;
        }
        return PDFXObjectColorMask.getInstance(this.getCosObject());
    }
}

