/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font.impl;

import com.adobe.fontengine.FontEngineException;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.CMapObject;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;

public class CMapCodesSpace
implements Serializable {
    static final long serialVersionUID = 1L;
    long minCodePos = 0L;
    long maxCodePos = 0L;
    int[] codes;
    boolean hasInited = false;
    int longValuesIndicator = -2;
    HashMap<Long, int[]> longValues = null;

    public CMapCodesSpace(long min, long max) {
        this.minCodePos = min;
        this.maxCodePos = max;
    }

    public long getMinCodePos() {
        return this.minCodePos;
    }

    public long getMaxCodePos() {
        return this.maxCodePos;
    }

    public void addCode(long code, int[] values) {
        if (code <= Integer.MAX_VALUE) {
            if (!this.hasInited) {
                this.init();
                this.hasInited = true;
            }
            if (values.length > 1) {
                this.addLongCode(code, values);
                int codePos = (int)(code - this.minCodePos);
                this.codes[codePos] = this.longValuesIndicator;
            } else {
                this.addIntCode(code, values[0]);
            }
        } else {
            this.addLongCode(code, values);
        }
    }

    private void addLongCode(long code, int[] values) {
        if (this.longValues == null) {
            this.longValues = new HashMap();
        }
        this.longValues.put(code, values);
    }

    private void addIntCode(long code, int value) {
        this.codes[(int)(code - this.minCodePos)] = value;
    }

    public boolean isCodeInCodeSpace(long code) {
        return code >= this.minCodePos && code <= this.maxCodePos;
    }

    public int[] getCodeValue(long code) {
        if (this.isCodeInCodeSpace(code)) {
            if (code > Integer.MAX_VALUE) {
                return this.longValues.get(code);
            }
            int codePos = (int)(code - this.minCodePos);
            int valuePos = this.codes[codePos];
            if (valuePos == -1) {
                return new int[]{-1};
            }
            if (valuePos == this.longValuesIndicator) {
                return this.longValues.get(code);
            }
            return new int[]{this.codes[codePos]};
        }
        return null;
    }

    public void enumerateValues(CMapObject.CMapValueConsumer consumer) throws FontEngineException {
        for (long i = this.minCodePos; i <= this.maxCodePos; ++i) {
            if (i > Integer.MAX_VALUE) {
                int[] values = this.longValues.get(i);
                consumer.value(i, values);
                continue;
            }
            int codePos = (int)(i - this.minCodePos);
            int valuePos = this.codes[codePos];
            if (valuePos == -1) continue;
            if (valuePos == this.longValuesIndicator) {
                consumer.value(i, this.longValues.get(i));
                continue;
            }
            consumer.value(i, this.codes[codePos]);
        }
    }

    int[] getCodes() {
        return this.codes;
    }

    HashMap<Long, int[]> getLongValues() {
        return this.longValues;
    }

    private void init() {
        this.codes = new int[(int)(this.maxCodePos - this.minCodePos + 1L)];
        Arrays.fill(this.codes, -1);
    }
}

