/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.filters;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilter;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterParamData;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterParams;
import java.util.Map;

public class PDFFilterCrypt
extends PDFFilter {
    private PDFFilterCrypt(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFilterCrypt newInstance(PDFDocument pdfDoc, PDFFilterParams params) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(pdfDoc);
        cosArray.addName(ASName.k_Crypt);
        cosArray.add(params != null ? params.getCosObject() : pdfDoc.getCosDocument().createCosNull());
        return new PDFFilterCrypt(cosArray);
    }

    public static PDFFilterCrypt newInstance(PDFDocument pdfDoc, Map paramsMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFilterCrypt.newInstance(pdfDoc, paramsMap != null ? PDFFilterParams.newInstance(pdfDoc, paramsMap) : null);
    }

    public static PDFFilterCrypt newInstance(PDFDocument pdfDoc, String cryptName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFilterParams params = PDFFilterParams.newInstance(pdfDoc);
        params.put("Name", cryptName);
        return PDFFilterCrypt.newInstance(pdfDoc, params);
    }

    public String getCryptName() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFFilterParams params = this.getParams();
        PDFFilterParamData name = params.get("Name");
        return name.getNameValue();
    }
}

