/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.utils.UTF16Support;

public abstract class PDFNameTree<V extends PDFCosObject>
extends PDFTree<ASString, V> {
    protected PDFNameTree(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject, ASName.k_Names);
    }

    protected CosString makeInternalKeyType(ASString externalKey) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCosObject.newCosString(this.getPDFDocument(), externalKey.getBytes());
    }

    @Override
    protected ASString makeExternalKeyType(CosScalar internalKey) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return internalKey.stringValue();
    }

    public byte[] findKey(String key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        byte[] notFound = new byte[]{};
        ASString asName = new ASString(UTF16Support.toUTF16(key));
        PDFCosObject fileSpec = (PDFCosObject)this.getEntry(asName);
        if (fileSpec != null) {
            return asName.getBytes();
        }
        ASString utf8Key = new ASString(key);
        if (this.getEntry(utf8Key) != null) {
            return utf8Key.getBytes();
        }
        return notFound;
    }
}

