/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSubjectDNList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import java.util.List;

public class PDFCertificateSeedValue
extends PDFCosDictionary {
    public static final int kSubject = 1;
    public static final int kIssuer = 2;
    public static final int kOID = 4;
    public static final int kSubjectDN = 8;
    public static final int kKeyUsage = 32;
    public static final int kURL = 64;
    public static final ASName k_SVCert = ASName.create("SVCert");
    public static final ASName k_Subject = ASName.create("Subject");
    public static final ASName k_Issuer = ASName.create("Issuer");
    public static final ASName k_OID = ASName.create("OID");
    public static final ASName k_URL = ASName.create("URL");
    public static final ASName k_Ff = ASName.create("Ff");
    public static final ASName k_SubjectDN = ASName.create("SubjectDN");
    public static final ASName k_KeyUsage = ASName.create("KeyUsage");
    public static final ASName k_URLType = ASName.create("URLType");
    public static final ASName k_Browser = ASName.create("Browser");
    public static final ASName k_ASSP = ASName.create("ASSP");

    private PDFCertificateSeedValue(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFCertificateSeedValue getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCertificateSeedValue pdfObject = (PDFCertificateSeedValue)PDFCosObject.getCachedInstance(cosObject, PDFCertificateSeedValue.class);
        if (pdfObject == null) {
            pdfObject = new PDFCertificateSeedValue(cosObject);
        }
        return pdfObject;
    }

    public static PDFCertificateSeedValue newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFCertificateSeedValue pdfObject = new PDFCertificateSeedValue(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, k_SVCert);
        return pdfObject;
    }

    public byte[][] getSubjects() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_Subject);
        if (cosArray == null) {
            return null;
        }
        byte[][] subjects = new byte[cosArray.size()][];
        for (int i = 0; i < subjects.length; ++i) {
            subjects[i] = cosArray.getString(i).getBytes();
        }
        return subjects;
    }

    public void setSubjects(byte[][] subjects) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (subjects == null) {
            this.removeValue(k_Subject);
        } else {
            CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < subjects.length; ++i) {
                if (subjects[i] == null || subjects[i].length <= 0) continue;
                cosArray.addString(new ASString(subjects[i]));
            }
            if (cosArray.size() > 0) {
                this.setDictionaryArrayValue(k_Subject, cosArray);
            } else {
                this.removeValue(k_Subject);
            }
        }
    }

    public PDFSubjectDNList getSubjectDN() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSubjectDNList.getInstance(this.getDictionaryCosObjectValue(k_SubjectDN));
    }

    public void setSubjectDN(List dnList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFSubjectDNList subjectDNList = PDFSubjectDNList.newInstance(this.getPDFDocument(), dnList);
        if (subjectDNList.size() > 0) {
            this.setDictionaryArrayValue(k_SubjectDN, subjectDNList.getCosArray());
        } else {
            this.removeValue(k_SubjectDN);
        }
    }

    public String[] getKeyUsage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(k_KeyUsage);
        if (cosArray == null) {
            return null;
        }
        String[] keyUsages = new String[cosArray.size()];
        for (int i = 0; i < keyUsages.length; ++i) {
            keyUsages[i] = cosArray.getString(i).asString();
        }
        return keyUsages;
    }

    public void setKeyUsage(String[] keyUsages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (keyUsages == null) {
            this.removeValue(k_KeyUsage);
        } else {
            CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < keyUsages.length; ++i) {
                if (keyUsages[i] == null || keyUsages[i].length() <= 0) continue;
                if (keyUsages[i].length() > 9) {
                    throw new PDFInvalidParameterException("The key usage bit string has more than 9 bits.");
                }
                cosArray.addText(keyUsages[i]);
            }
            if (cosArray.size() > 0) {
                this.setDictionaryArrayValue(k_KeyUsage, cosArray);
            } else {
                this.removeValue(k_KeyUsage);
            }
        }
    }

    public byte[][] getIssuers() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(k_Issuer);
        if (cosArray == null) {
            return null;
        }
        byte[][] issuers = new byte[cosArray.size()][];
        for (int i = 0; i < issuers.length; ++i) {
            issuers[i] = cosArray.getString(i).getBytes();
        }
        return issuers;
    }

    public void setIssuers(byte[][] issuers) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (issuers == null) {
            this.removeValue(k_Issuer);
        } else {
            CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < issuers.length; ++i) {
                if (issuers[i] == null || issuers[i].length <= 0) continue;
                cosArray.addString(new ASString(issuers[i]));
            }
            if (cosArray.size() > 0) {
                this.setDictionaryArrayValue(k_Issuer, cosArray);
            } else {
                this.removeValue(k_Issuer);
            }
        }
    }

    public String[] getOIDs() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(k_OID);
        if (cosArray == null) {
            return null;
        }
        String[] oids = new String[cosArray.size()];
        for (int i = 0; i < oids.length; ++i) {
            oids[i] = cosArray.getString(i).asString();
        }
        return oids;
    }

    public void setOIDs(String[] oids) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (oids == null) {
            this.removeValue(k_OID);
        } else {
            CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < oids.length; ++i) {
                if (oids[i] == null || oids[i].length() <= 0) continue;
                cosArray.addText(oids[i]);
            }
            if (cosArray.size() > 0) {
                this.setDictionaryArrayValue(k_OID, cosArray);
            } else {
                this.removeValue(k_OID);
            }
        }
    }

    public String getURL() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString asStr = this.getDictionaryStringValue(k_URL);
        return asStr != null ? asStr.asString() : null;
    }

    public void setURL(String url) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_URL, url);
    }

    public void setURL(String url, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_URL, url, unicode);
    }

    public ASName getURLType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(k_URLType)) {
            return this.getDictionaryNameValue(k_URLType);
        }
        return k_Browser;
    }

    public void setURLType(ASName urlType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(k_URLType, urlType);
    }

    public int getFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(k_Ff)) {
            return this.getDictionaryIntValue(k_Ff);
        }
        return 0;
    }

    public void setFlags(Integer flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (flags == null) {
            this.removeValue(k_Ff);
        } else {
            this.setDictionaryIntValue(k_Ff, flags.intValue());
        }
    }

    public String getSignaturePolicyOID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString asStr = this.getDictionaryStringValue(ASName.k_SignaturePolicyOID);
        return asStr != null ? asStr.asString() : null;
    }

    public void setSignaturePolicyOID(String signaturePolicyOID) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_SignaturePolicyOID, signaturePolicyOID);
    }

    public void setSignaturePolicyOID(String signaturePolicyOID, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_SignaturePolicyOID, signaturePolicyOID, unicode);
    }

    public String getSignaturePolicyHashValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString asStr = this.getDictionaryStringValue(ASName.k_SignaturePolicyHashValue);
        return asStr != null ? asStr.asString() : null;
    }

    public void setSignaturePolicyHashValue(String signaturePolicyHashValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_SignaturePolicyHashValue, signaturePolicyHashValue);
    }

    public void setSignaturePolicyHashValue(String signaturePolicyHashValue, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_SignaturePolicyHashValue, signaturePolicyHashValue, unicode);
    }

    public ASName getSignaturePolicyHashAlgorithm() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_SignaturePolicyHashAlgorithm);
    }

    public void setSignaturePolicyHashAlgorithm(ASName signaturePolicyHashAlgorithm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_SignaturePolicyHashAlgorithm, signaturePolicyHashAlgorithm);
    }

    public String[] getSignaturePolicyCommitmentType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_SignaturePolicyCommitmentType);
        if (cosArray == null) {
            return null;
        }
        String[] keyUsages = new String[cosArray.size()];
        for (int i = 0; i < keyUsages.length; ++i) {
            keyUsages[i] = cosArray.getString(i).asString();
        }
        return keyUsages;
    }

    public void setSignaturePolicyCommitmentType(String[] signaturePolicyCommitmentTypes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (signaturePolicyCommitmentTypes == null) {
            this.removeValue(ASName.k_SignaturePolicyCommitmentType);
        } else {
            CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < signaturePolicyCommitmentTypes.length; ++i) {
                if (signaturePolicyCommitmentTypes[i] == null || signaturePolicyCommitmentTypes[i].length() <= 0) continue;
                cosArray.addText(signaturePolicyCommitmentTypes[i]);
            }
            if (cosArray.size() > 0) {
                this.setDictionaryArrayValue(ASName.k_SignaturePolicyCommitmentType, cosArray);
            } else {
                this.removeValue(ASName.k_SignaturePolicyCommitmentType);
            }
        }
    }
}

