/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;

public class Path {
    private GeneralPath generalPath = new GeneralPath();
    private boolean show = true;

    public Path() {
    }

    public Path(ASCoordinate currentPoint) {
        this();
        this.generalPath.moveTo((float)currentPoint.x(), (float)currentPoint.y());
    }

    public Path(Path path) {
        this();
        this.generalPath = (GeneralPath)path.generalPath.clone();
    }

    public Path(PDFRectangle rect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this();
        ASCoordinate lowerLeft = new ASCoordinate(rect.llx(), rect.lly());
        ASCoordinate lowerRight = new ASCoordinate(rect.urx(), rect.lly());
        ASCoordinate upperRight = new ASCoordinate(rect.urx(), rect.ury());
        ASCoordinate upperLeft = new ASCoordinate(rect.llx(), rect.ury());
        this.generalPath.moveTo((float)lowerLeft.x(), (float)lowerLeft.y());
        this.generalPath.lineTo((float)lowerRight.x(), (float)lowerRight.y());
        this.generalPath.lineTo((float)upperRight.x(), (float)upperRight.y());
        this.generalPath.lineTo((float)upperLeft.x(), (float)upperLeft.y());
        this.generalPath.closePath();
    }

    public Path(ASRectangle rect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this();
        ASCoordinate lowerLeft = new ASCoordinate(rect.left(), rect.bottom());
        ASCoordinate lowerRight = new ASCoordinate(rect.right(), rect.bottom());
        ASCoordinate upperRight = new ASCoordinate(rect.right(), rect.top());
        ASCoordinate upperLeft = new ASCoordinate(rect.left(), rect.top());
        this.generalPath.moveTo((float)lowerLeft.x(), (float)lowerLeft.y());
        this.generalPath.lineTo((float)lowerRight.x(), (float)lowerRight.y());
        this.generalPath.lineTo((float)upperRight.x(), (float)upperRight.y());
        this.generalPath.lineTo((float)upperLeft.x(), (float)upperLeft.y());
        this.generalPath.closePath();
    }

    public void moveTo(ASCoordinate position) {
        this.generalPath.moveTo((float)position.x(), (float)position.y());
    }

    public void lineTo(ASCoordinate endPoint) {
        this.generalPath.lineTo((float)endPoint.x(), (float)endPoint.y());
    }

    public void curveTo(ASCoordinate p1, ASCoordinate p2, ASCoordinate p3) {
        float x1 = (float)p1.x();
        float y1 = (float)p1.y();
        float x2 = (float)p2.x();
        float y2 = (float)p2.y();
        float x3 = (float)p3.x();
        float y3 = (float)p3.y();
        this.generalPath.curveTo(x1, y1, x2, y2, x3, y3);
    }

    public void curveToV(ASCoordinate p2, ASCoordinate p3) {
        double x1 = this.generalPath.getCurrentPoint().getX();
        double y1 = this.generalPath.getCurrentPoint().getY();
        this.curveTo(new ASCoordinate(x1, y1), p2, p3);
    }

    public void curveToY(ASCoordinate p1, ASCoordinate p3) {
        this.curveTo(p1, p3, p3);
    }

    public void close() {
        this.generalPath.closePath();
    }

    public boolean getShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    public void setWindingRule(int rule) {
        this.generalPath.setWindingRule(rule);
    }

    public int getWindingRule() {
        return this.generalPath.getWindingRule();
    }

    public Shape getShape() {
        return (Shape)this.generalPath.clone();
    }

    public Area getArea() {
        return new Area(this.generalPath);
    }

    public GeneralPath getPath() {
        return this.generalPath;
    }
}

