/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content;

import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASHexString;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ReadonlyOperandStack;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class Instruction {
    private OperandStack operands;
    private ASName operator;
    public static final HashSet<ASName> operators_v10 = new HashSet(58);
    public static final HashSet<ASName> operators_v11 = new HashSet(7);
    public static final HashSet<ASName> operators_v12 = new HashSet(7);
    public static final HashSet<ASName> operators_v13 = new HashSet(1);
    private static final HashSet<ASName> textShowingOperators = new HashSet(14);

    public Instruction(OperandStack operands, ASName operator) {
        this.operands = operands;
        this.operator = operator;
    }

    Instruction(ASName operator) {
        this.operator = operator;
        this.operands = new OperandStack();
    }

    void push(int value) {
        this.operands.push(new ASNumber(value));
    }

    void push(double value) {
        this.operands.push(new ASNumber(value));
    }

    void push(ASName value) {
        this.operands.push(value);
    }

    void push(ASNumber value) {
        this.operands.push(value);
    }

    void push(ASString value) {
        this.operands.push(value);
    }

    void push(ASHexString value) {
        this.operands.push(value);
    }

    void push(ASDictionary value) {
        this.operands.push(value);
    }

    void push(ASArray value) {
        this.operands.push(value);
    }

    public String toString() {
        return this.operands.toString() + this.operator.asString(true);
    }

    public void write(OutputByteStream outputByteStream) throws PDFIOException {
        try {
            Iterator<Object> iter = this.operands.iterator();
            if (this.operator != ASName.k_ID) {
                while (iter.hasNext()) {
                    ASObject operand = (ASObject)iter.next();
                    if (textShowingOperators.contains(this.operator) && operand instanceof ASString) {
                        this.writeToStream((ASString)operand, outputByteStream);
                    } else {
                        operand.write(outputByteStream);
                    }
                    outputByteStream.write(32);
                }
                outputByteStream.write(this.operator.getBytes());
            } else {
                InputByteStream ibs = null;
                while (iter.hasNext()) {
                    Object operand = iter.next();
                    if (operand instanceof InputByteStream) {
                        ibs = (InputByteStream)operand;
                        continue;
                    }
                    if (textShowingOperators.contains(this.operator) && operand instanceof ASString) {
                        this.writeToStream((ASString)operand, outputByteStream);
                    } else {
                        ((ASObject)operand).write(outputByteStream);
                    }
                    outputByteStream.write(32);
                }
                outputByteStream.write(this.operator.getBytes());
                outputByteStream.write(32);
                IO.copy(ibs, outputByteStream);
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private void writeToStream(ASString string, OutputByteStream outputByteStream) throws PDFIOException {
        string.write(outputByteStream);
    }

    public OperandStack getOperands() {
        return this.operands;
    }

    public OperandStack getReadonlyOperands() {
        return new ReadonlyOperandStack((ArrayList)this.operands.mStack);
    }

    public ASName getOperator() {
        return this.operator;
    }

    public PDFVersion getVersion() {
        if (operators_v10.contains(this.operator)) {
            return PDFVersion.v1_0;
        }
        if (operators_v11.contains(this.operator)) {
            return PDFVersion.v1_1;
        }
        if (operators_v12.contains(this.operator)) {
            return PDFVersion.v1_2;
        }
        if (operators_v13.contains(this.operator)) {
            return PDFVersion.v1_3;
        }
        return null;
    }

    public void close() throws PDFIOException {
        Iterator<Object> iter = this.operands.iterator();
        boolean toThrow = false;
        IOException lastIOExceptionCaught = null;
        while (iter.hasNext()) {
            Object nextOperand = iter.next();
            if (!(nextOperand instanceof InputByteStream)) continue;
            try {
                ((InputByteStream)nextOperand).close();
            }
            catch (IOException e) {
                toThrow = true;
                lastIOExceptionCaught = e;
            }
        }
        if (toThrow && lastIOExceptionCaught != null) {
            throw new PDFIOException(lastIOExceptionCaught);
        }
    }

    static {
        textShowingOperators.add(ASName.k_TJ);
        textShowingOperators.add(ASName.k_Tj);
        textShowingOperators.add(ASName.k_SingleQuote);
        textShowingOperators.add(ASName.k_DoubleQuote);
        operators_v10.add(ASName.k_W);
        operators_v10.add(ASName.k_G);
        operators_v10.add(ASName.k_F);
        operators_v10.add(ASName.k_f);
        operators_v10.add(ASName.k_n);
        operators_v10.add(ASName.k_ID);
        operators_v10.add(ASName.k_K);
        operators_v10.add(ASName.k_B);
        operators_v10.add(ASName.k_M);
        operators_v10.add(ASName.k_S);
        operators_v10.add(ASName.k_J);
        operators_v10.add(ASName.k_Q);
        operators_v10.add(ASName.k_b);
        operators_v10.add(ASName.k_c);
        operators_v10.add(ASName.k_d);
        operators_v10.add(ASName.k_g);
        operators_v10.add(ASName.k_h);
        operators_v10.add(ASName.k_i);
        operators_v10.add(ASName.k_j);
        operators_v10.add(ASName.k_k);
        operators_v10.add(ASName.k_l);
        operators_v10.add(ASName.k_m);
        operators_v10.add(ASName.k_q);
        operators_v10.add(ASName.k_s);
        operators_v10.add(ASName.k_v);
        operators_v10.add(ASName.k_w);
        operators_v10.add(ASName.k_y);
        operators_v10.add(ASName.k_TD);
        operators_v10.add(ASName.k_cm);
        operators_v10.add(ASName.k_gs);
        operators_v10.add(ASName.k_re);
        operators_v10.add(ASName.k_fStar);
        operators_v10.add(ASName.k_BStar);
        operators_v10.add(ASName.k_bStar);
        operators_v10.add(ASName.k_WStar);
        operators_v10.add(ASName.k_RG);
        operators_v10.add(ASName.k_rg);
        operators_v10.add(ASName.k_Do);
        operators_v10.add(ASName.k_Tc);
        operators_v10.add(ASName.k_Tw);
        operators_v10.add(ASName.k_Tz);
        operators_v10.add(ASName.k_TL);
        operators_v10.add(ASName.k_Tf);
        operators_v10.add(ASName.k_Tr);
        operators_v10.add(ASName.k_Ts);
        operators_v10.add(ASName.k_BT);
        operators_v10.add(ASName.k_ET);
        operators_v10.add(ASName.k_Td);
        operators_v10.add(ASName.k_Tm);
        operators_v10.add(ASName.k_TStar);
        operators_v10.add(ASName.k_Tj);
        operators_v10.add(ASName.k_SingleQuote);
        operators_v10.add(ASName.k_DoubleQuote);
        operators_v10.add(ASName.k_TJ);
        operators_v10.add(ASName.k_d0);
        operators_v10.add(ASName.k_d1);
        operators_v10.add(ASName.k_BI);
        operators_v10.add(ASName.k_EI);
        operators_v11.add(ASName.k_CS);
        operators_v11.add(ASName.k_SC);
        operators_v11.add(ASName.k_ri);
        operators_v11.add(ASName.k_BX);
        operators_v11.add(ASName.k_EX);
        operators_v11.add(ASName.k_cs);
        operators_v11.add(ASName.k_sc);
        operators_v12.add(ASName.k_DP);
        operators_v12.add(ASName.k_SCN);
        operators_v12.add(ASName.k_scn);
        operators_v12.add(ASName.k_MP);
        operators_v12.add(ASName.k_BMC);
        operators_v12.add(ASName.k_BDC);
        operators_v12.add(ASName.k_EMC);
        operators_v13.add(ASName.k_sh);
    }
}

