/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.filter.CCITTFaxInputStream;
import com.adobe.internal.pdftoolkit.core.filter.DCTInputStream;
import com.adobe.internal.pdftoolkit.core.filter.DecodeInputStream;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.FilterStream;
import com.adobe.internal.pdftoolkit.core.filter.LZWInputStream;
import com.adobe.internal.pdftoolkit.core.filter.RunLengthInputStream;
import com.adobe.internal.pdftoolkit.core.filter.TIFFCountingStreamWrapper;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.Token;
import com.adobe.internal.pdftoolkit.pdf.content.TokenType;
import com.adobe.internal.pdftoolkit.pdf.content.Tokenizer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;

class ContentParser {
    private OperandStack operandStack;
    private InputByteStream contentStream;
    private CosDictionary colorSpaceMap;
    private CosDocument cosDoc;
    private Tokenizer tokenizer;

    ContentParser(PDFContents content, CosDictionary csMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this(content, csMap, null);
    }

    ContentParser(PDFContents content, CosDictionary csMap, HashSet<ASName> operators) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.contentStream = content.getContents();
        this.operandStack = new OperandStack();
        this.colorSpaceMap = csMap;
        this.cosDoc = content.getPDFDocument().getCosDocument();
        this.tokenizer = new Tokenizer(this.contentStream, operators);
    }

    private ContentParser(InputByteStream contentStream, CosDictionary csMap, CosDocument cosDoc) {
        this.operandStack = new OperandStack();
        this.contentStream = contentStream;
        this.colorSpaceMap = csMap;
        this.cosDoc = cosDoc;
        this.tokenizer = new Tokenizer(contentStream, null);
    }

    public boolean available() throws IOException {
        return this.contentStream != null && this.contentStream.bytesAvailable() > 0L;
    }

    ContentParser slice() throws PDFIOException {
        InputByteStream slicedStream;
        try {
            long sliceStart = this.contentStream.getPosition();
            slicedStream = this.contentStream.slice(sliceStart, this.contentStream.length() - sliceStart);
        }
        catch (IOException e) {
            throw new PDFIOException("Could not slice ContentParser", e);
        }
        return new ContentParser(slicedStream, this.colorSpaceMap, this.cosDoc);
    }

    void close() throws IOException {
        this.contentStream.close();
    }

    Instruction nextInstruction() throws PDFParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        while (true) {
            Token result;
            if ((result = this.tokenizer.nextToken()) == null) {
                return null;
            }
            if (result.getType() == TokenType.Operator) {
                if (result.getValue() == ASName.k_ID) {
                    InputByteStream imageData;
                    ASDictionary imageDict = this.operandStack.stackToImageDictionary();
                    try {
                        try {
                            imageData = this.readInlineImage(imageDict);
                        }
                        catch (PDFInvalidParameterException e) {
                            throw new PDFInvalidContentException(e);
                        }
                        catch (PDFIOException e) {
                            throw new PDFInvalidContentException(e);
                        }
                    }
                    catch (PDFUnableToCompleteOperationException e) {
                        throw new PDFInvalidContentException(e);
                    }
                    this.operandStack.pushInputByteStream(imageData);
                }
                Instruction instruction = new Instruction(this.operandStack, (ASName)result.getValue());
                this.operandStack = new OperandStack();
                return instruction;
            }
            if (result.getType() != TokenType.Operand) break;
            this.operandStack.push(result.getValue());
        }
        throw new PDFInvalidContentException("unrecognized token");
    }

    private DecodeInputStream createDecodeInputStream(InputStream is, ASName filter, FilterParams filterParams) {
        if (filter == ASName.k_LZW || filter == ASName.k_LZWDecode) {
            return new LZWInputStream(is, filterParams);
        }
        if (filter == ASName.k_RL || filter == ASName.k_RunLengthDecode) {
            return new RunLengthInputStream(is, filterParams);
        }
        if (filter == ASName.k_CCF || filter == ASName.k_CCITTFaxDecode) {
            return new CCITTFaxInputStream(is, filterParams);
        }
        if (filter == ASName.k_DCT || filter == ASName.k_DCTDecode) {
            return new DCTInputStream(is, filterParams);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputByteStream readInlineImage(ASDictionary imageDict) throws PDFIOException, PDFParseException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException, PDFInvalidDocumentException {
        try {
            byte b;
            int bpc = 0;
            int cpp = 0;
            long width = 0L;
            long height = 0L;
            long imageSize = 0L;
            boolean isImageMask = false;
            InputByteStream imageByteStream = null;
            if (imageDict.containsKey(ASName.k_IM)) {
                isImageMask = imageDict.getBoolean(ASName.k_IM).isTrue();
            } else if (imageDict.containsKey(ASName.k_ImageMask)) {
                isImageMask = imageDict.getBoolean(ASName.k_ImageMask).isTrue();
            }
            if (isImageMask) {
                bpc = 1;
                cpp = 1;
            } else {
                ASObject cs;
                if (imageDict.containsKey(ASName.k_BPC)) {
                    bpc = imageDict.getNumber(ASName.k_BPC).intValue();
                } else {
                    if (!imageDict.containsKey(ASName.k_BitsPerComponent)) throw new PDFInvalidContentException("Image dictionary did not contain required BPC entry");
                    bpc = imageDict.getNumber(ASName.k_BitsPerComponent).intValue();
                }
                if (imageDict.containsKey(ASName.k_CS)) {
                    cs = imageDict.get(ASName.k_CS);
                } else {
                    if (!imageDict.containsKey(ASName.k_ColorSpace)) throw new PDFInvalidContentException("Image dictionary did not contain required CS entry");
                    cs = imageDict.get(ASName.k_ColorSpace);
                }
                if (cs instanceof ASName) {
                    if (cs == ASName.k_G || cs == ASName.k_DeviceGray) {
                        cpp = 1;
                    } else if (cs == ASName.k_RGB || cs == ASName.k_DeviceRGB) {
                        cpp = 3;
                    } else if (cs == ASName.k_CMYK || cs == ASName.k_DeviceCMYK) {
                        cpp = 4;
                    } else {
                        if (this.colorSpaceMap == null) throw new PDFInvalidContentException("Image dictionary contained unknown CS type");
                        if (this.colorSpaceMap.get((ASName)cs) == null) throw new PDFInvalidContentException("Image dictionary contained unknown CS type");
                        CosObject resourceCS = this.colorSpaceMap.get((ASName)cs);
                        if (resourceCS.getType() == 5) {
                            CosArray cosCSArray = (CosArray)resourceCS;
                            cpp = this.countCSComponentsForInlineImages(cosCSArray);
                        } else {
                            if (resourceCS.getType() != 3) throw new PDFInvalidContentException("Image dictionary contained unknown CS type");
                            ASName csName = ((CosName)resourceCS).nameValue();
                            cpp = this.getCSComponentsForInlineImages(csName);
                        }
                    }
                } else {
                    if (!(cs instanceof ASArray)) throw new PDFInvalidContentException("Image dictionary contained unknown CS type");
                    cpp = this.countCSComponentsForInlineImages((ASArray)cs);
                }
            }
            if (imageDict.containsKey(ASName.k_W)) {
                width = imageDict.getNumber(ASName.k_W).longValue();
            } else {
                if (!imageDict.containsKey(ASName.k_Width)) throw new PDFInvalidContentException("Image dictionary missing required width");
                width = imageDict.getNumber(ASName.k_Width).longValue();
            }
            if (imageDict.containsKey(ASName.k_H)) {
                height = imageDict.getNumber(ASName.k_H).longValue();
            } else {
                if (!imageDict.containsKey(ASName.k_Height)) throw new PDFInvalidContentException("Image dictionary missing required height");
                height = imageDict.getNumber(ASName.k_Height).longValue();
            }
            if (bpc != 1 && bpc != 2 && bpc != 4 && bpc != 8) {
                throw new PDFInvalidContentException("Invalid image dictionary");
            }
            if (cpp != 1 && cpp != 3 && cpp != 4) {
                throw new PDFInvalidContentException("Invalid image dictionary");
            }
            if (width * height == 0L) {
                throw new PDFInvalidContentException("Invalid image dictionary");
            }
            ASArray filters = null;
            ASObject filterDictEntry = null;
            if (imageDict.containsKey(ASName.k_F)) {
                filterDictEntry = imageDict.get(ASName.k_F);
                if (filterDictEntry instanceof ASArray) {
                    filters = (ASArray)filterDictEntry;
                } else {
                    if (!(filterDictEntry instanceof ASName)) throw new PDFUnsupportedFeatureException("Image dictionary contains unsupported filter - " + filterDictEntry);
                    filters = new ASArray();
                    filters.add(filterDictEntry);
                }
            } else if (imageDict.containsKey(ASName.k_Filter)) {
                filterDictEntry = imageDict.get(ASName.k_Filter);
                if (filterDictEntry instanceof ASArray) {
                    filters = (ASArray)filterDictEntry;
                } else {
                    if (!(filterDictEntry instanceof ASName)) throw new PDFUnsupportedFeatureException("Image dictionary contains unsupported filter - " + filterDictEntry);
                    filters = new ASArray();
                    filters.add(filterDictEntry);
                }
            }
            boolean expectSpaceAfterID = true;
            if (filters != null && (filters.contains(ASName.k_ASCIIHexDecode) || filters.contains(ASName.k_ASCII85Decode))) {
                expectSpaceAfterID = false;
            }
            if (expectSpaceAfterID && !ByteOps.isWhitespace(b = (byte)this.contentStream.read())) {
                this.contentStream.unget();
            }
            if (filters != null && filters.size() != 0) {
                ASObject paramsObj;
                ASArray paramsArray;
                ASObject params = imageDict.get(ASName.k_DecodeParms);
                if (params == null) {
                    params = imageDict.get(ASName.k_DP);
                }
                ASDictionary paramsDict = null;
                if (params instanceof ASDictionary) {
                    paramsDict = (ASDictionary)params;
                } else if (params instanceof ASArray && (paramsArray = (ASArray)params).size() > 0 && (paramsObj = paramsArray.get(0)) instanceof ASDictionary) {
                    paramsDict = (ASDictionary)paramsObj;
                }
                long startPos = this.contentStream.getPosition();
                boolean eod = false;
                ASName filter = filters.getName(0);
                if (filter == ASName.k_AHx || filter == ASName.k_ASCIIHexDecode) {
                    while (this.contentStream.read() != 62) {
                        ++imageSize;
                    }
                    return this.contentStream.slice(startPos, imageSize + 1L);
                }
                if (filter == ASName.k_A85 || filter == ASName.k_ASCII85Decode) {
                    byte b1 = (byte)this.contentStream.read();
                    byte b2 = (byte)this.contentStream.read();
                    do {
                        if (b1 == 126 && b2 == 62) {
                            eod = true;
                            continue;
                        }
                        ++imageSize;
                        b1 = b2;
                        if (this.contentStream.eof()) return this.contentStream.slice(startPos, imageSize + 2L);
                        b2 = (byte)this.contentStream.read();
                    } while (!eod);
                    return this.contentStream.slice(startPos, imageSize + 2L);
                }
                if (filter == ASName.k_Fl || filter == ASName.k_FlateDecode) {
                    TIFFCountingStreamWrapper wrapper = null;
                    InputByteStream contentStreamSliced = null;
                    try {
                        long endPos = this.contentStream.length();
                        contentStreamSliced = this.contentStream.slice(startPos, endPos - startPos);
                        wrapper = new TIFFCountingStreamWrapper(contentStreamSliced.toInputStream(), paramsDict);
                        imageByteStream = wrapper.getData();
                        imageSize = wrapper.getTotalIn();
                        this.contentStream.seek(startPos + imageSize);
                        imageByteStream = this.contentStream.slice(startPos, imageSize + 1L);
                        return imageByteStream;
                    }
                    finally {
                        try {
                            if (wrapper != null) {
                                wrapper.close();
                            }
                        }
                        finally {
                            if (contentStreamSliced != null) {
                                contentStreamSliced.close();
                            }
                        }
                    }
                }
                if (filter != ASName.k_LZW && filter != ASName.k_LZWDecode && filter != ASName.k_RL && filter != ASName.k_RunLengthDecode && filter != ASName.k_CCF && filter != ASName.k_CCITTFaxDecode && filter != ASName.k_DCT) {
                    if (filter != ASName.k_DCTDecode) throw new PDFUnsupportedFeatureException("Image dictionary contains unsupported filter - " + filter);
                }
                InputStream is = null;
                DecodeInputStream dis = null;
                try {
                    FilterParams filterParams = null;
                    if (paramsDict != null) {
                        filterParams = FilterStream.buildFilterParams(paramsDict);
                    }
                    if (filterParams == null) {
                        filterParams = new FilterParams();
                    }
                    long length = this.contentStream.length() - startPos;
                    imageByteStream = this.contentStream.slice(startPos, length);
                    try {
                        is = imageByteStream.toInputStream();
                    }
                    catch (IOException e) {
                        throw new PDFIOException(e);
                    }
                    finally {
                        if (imageByteStream != null) {
                            imageByteStream.close();
                        }
                    }
                    dis = this.createDecodeInputStream(is, filter, filterParams);
                    byte[] buffer = new byte[4096];
                    int read = 0;
                    while (read > -1) {
                        read = dis.read(buffer);
                    }
                    imageSize = dis.getInPos();
                    this.contentStream.seek(startPos + imageSize);
                    imageByteStream = this.contentStream.slice(startPos, imageSize + 1L);
                    return imageByteStream;
                }
                catch (IOException e) {
                    throw new PDFIOException(e);
                }
                finally {
                    if (dis != null) {
                        dis.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
            }
            long rowBytes = ((long)(bpc * cpp) * width + 7L) / 8L;
            imageSize = height * rowBytes;
            if (imageSize > this.contentStream.bytesAvailable()) throw new PDFInvalidContentException("Unable to parse image at" + this.contentStream.getPosition());
            long startPos = this.contentStream.getPosition();
            this.contentStream.seek(this.contentStream.getPosition() + imageSize);
            byte b1 = (byte)this.contentStream.read();
            long extraJunkLength = 0L;
            if (ByteOps.isWhitespace(b1)) return this.contentStream.slice(startPos, imageSize + extraJunkLength);
            boolean gotEI = false;
            byte b2 = (byte)this.contentStream.read();
            do {
                if (b1 == 69 && b2 == 73) {
                    gotEI = true;
                    this.contentStream.unget();
                    this.contentStream.unget();
                    continue;
                }
                b1 = b2;
                ++extraJunkLength;
                b2 = (byte)this.contentStream.read();
            } while (!gotEI);
            return this.contentStream.slice(startPos, imageSize + extraJunkLength);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private int getCSComponentsForInlineImages(ASName cs) throws PDFInvalidContentException {
        if (cs == ASName.k_G || cs == ASName.k_DeviceGray) {
            return 1;
        }
        if (cs == ASName.k_RGB || cs == ASName.k_DeviceRGB) {
            return 3;
        }
        if (cs == ASName.k_CMYK || cs == ASName.k_DeviceCMYK) {
            return 4;
        }
        throw new PDFInvalidContentException("CS array contained unknown CS type");
    }

    private int countCSComponentsForInlineImages(ASArray array) throws PDFInvalidContentException, PDFUnableToCompleteOperationException {
        ASName name = array.getName(0);
        if (name == ASName.k_DeviceGray || name == ASName.k_G || name == ASName.k_CalGray || name == ASName.k_Separation || name == ASName.k_Indexed || name == ASName.k_I) {
            return 1;
        }
        if (name == ASName.k_DeviceRGB || name == ASName.k_RGB || name == ASName.k_CalRGB || name == ASName.k_Lab) {
            return 3;
        }
        if (name == ASName.k_DeviceCMYK || name == ASName.k_CMYK) {
            return 4;
        }
        if (name == ASName.k_ICCBased) {
            ASDictionary iccDict = array.getDictionary(1);
            return iccDict.getNumber(ASName.k_N).intValue();
        }
        if (name == ASName.k_DeviceN) {
            ASArray names = array.getArray(1);
            return names.size();
        }
        throw new PDFInvalidContentException("CS array contained unknown CS type");
    }

    private int countCSComponentsForInlineImages(CosArray cosCSArray) throws PDFInvalidContentException, PDFParseException, PDFSecurityException, PDFIOException {
        try {
            ASName name = cosCSArray.getName(0);
            if (name == ASName.k_DeviceGray || name == ASName.k_G || name == ASName.k_CalGray || name == ASName.k_Separation || name == ASName.k_Indexed || name == ASName.k_I) {
                return 1;
            }
            if (name == ASName.k_DeviceRGB || name == ASName.k_RGB || name == ASName.k_CalRGB || name == ASName.k_Lab) {
                return 3;
            }
            if (name == ASName.k_DeviceCMYK || name == ASName.k_CMYK) {
                return 4;
            }
            if (name == ASName.k_ICCBased) {
                CosDictionary iccDict = cosCSArray.getCosDictionary(1);
                return iccDict.getInt(ASName.k_N);
            }
            if (name == ASName.k_DeviceN) {
                CosArray names = cosCSArray.getCosArray(1);
                return names.size();
            }
            throw new PDFInvalidContentException("CS array contained unknown CS type");
        }
        catch (PDFCosParseException e) {
            throw new PDFParseException(e);
        }
    }
}

