/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.fontset.impl;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.CoolTypeScript;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CIDKeyedFont;
import com.adobe.fontengine.fontmanagement.CacheSupportInfo;
import com.adobe.fontengine.fontmanagement.Platform;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDescription;
import java.util.HashSet;
import java.util.Set;

class FontNameResolver {
    private static final String gFontNameSuffixRemTab = "-Big5";

    FontNameResolver() {
    }

    static Set<String> doNameMangling(Font font, Platform platForm, ULocale locale) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        String psName;
        String fontType;
        HashSet<String> names = new HashSet<String>();
        CacheSupportInfo info = ((FontImpl)font).getCacheSupportInfo();
        String string = fontType = info == null ? null : info.getFontType();
        if (font.getPDFFontDescription().pdfFontIsTrueType()) {
            String familyName;
            String psName2;
            PlatformFontDescription[] platformFontDesc = font.getPlatformFontDescription(platForm);
            String fullName = null;
            for (int i = 0; i < platformFontDesc.length; ++i) {
                if (!platformFontDesc[i].getLocale().equals(locale)) continue;
                fullName = platformFontDesc[i].getPlatformName();
                break;
            }
            if (fullName != null) {
                FontNameResolver.addFontToList(fullName, null, names);
            }
            if ((psName2 = font.getPDFFontDescription().getPostscriptName()) != null) {
                FontNameResolver.addFontToList(psName2, null, names);
                psName2 = FontNameResolver.fontNameRemoveSuffix(psName2);
                if (psName2 != null) {
                    FontNameResolver.addFontToList(psName2, null, names);
                }
            }
            CSS20FontDescription css = font.getPreferredCSS20FontDescription();
            Style style = null;
            if (css != null) {
                if (css.getStyle() == CSS20Attribute.CSSStyleValue.ITALIC) {
                    style = css.getWeight() == CSS20Attribute.CSSWeightValue.BOLD.getValue() ? Style.BoldItalic : Style.Italic;
                } else if (css.getWeight() == CSS20Attribute.CSSWeightValue.BOLD.getValue()) {
                    style = Style.Bold;
                }
            }
            CoolTypeScript writingScript = font.getCoolTypeScript();
            FXGFontDescription[] fxg = font.getFXGFontDescription(platForm);
            for (int i = 0; fxg != null && i < fxg.length; ++i) {
                String winLogName;
                if (!fxg[i].getLocale().equals(locale)) continue;
                String string2 = winLogName = fxg[i] != null ? fxg[i].getFamilyName() : null;
                if (winLogName == null) break;
                if (writingScript == CoolTypeScript.JAPANESE || writingScript == CoolTypeScript.TRADITIONAL_CHINESE || writingScript == CoolTypeScript.SIMPLIFIED_CHINESE || writingScript == CoolTypeScript.KOREAN) {
                    FontNameResolver.addFontToList(winLogName, null, names);
                }
                FontNameResolver.addFontToList(winLogName, style, names);
                break;
            }
            String string3 = familyName = css == null ? null : css.getFamilyName();
            if (familyName != null && writingScript != CoolTypeScript.JAPANESE && writingScript != CoolTypeScript.TRADITIONAL_CHINESE && writingScript != CoolTypeScript.SIMPLIFIED_CHINESE && writingScript != CoolTypeScript.KOREAN) {
                FontNameResolver.addFontToList(familyName, style, names);
            }
        } else if (("Type1Font".equalsIgnoreCase(fontType) || ((FontImpl)font).getFontData() instanceof CIDKeyedFont) && (psName = font.getPDFFontDescription().getPostscriptName()) != null) {
            FontNameResolver.addFontToList(psName, null, names);
        }
        return names;
    }

    private static void addFontToList(String fontName, Style stylename, Set<String> altNames) {
        String compressedName = FontNameResolver.stripSpacesAndAtSign(fontName);
        if (stylename == null) {
            altNames.add(compressedName);
        } else if (stylename == Style.Bold || stylename == Style.Italic || stylename == Style.BoldItalic) {
            StringBuilder newName = new StringBuilder().append(compressedName).append(',').append((Object)stylename);
            altNames.add(newName.toString());
        }
    }

    private static String stripSpacesAndAtSign(String src) {
        if (src.startsWith("@")) {
            src = src.substring(1);
        }
        String[] splits = src.split(" ");
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < splits.length; ++i) {
            strBuilder.append(splits[i]);
        }
        return strBuilder.toString();
    }

    private static String fontNameRemoveSuffix(String name) {
        if (name.endsWith(gFontNameSuffixRemTab)) {
            return name.substring(0, name.length() - gFontNameSuffixRemTab.length());
        }
        return null;
    }

    private static enum Style {
        Bold,
        Italic,
        BoldItalic;

    }
}

