/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.TIFFInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

class TIFFEngine {
    private boolean encode;
    private TIFFInputStream rdr;
    private OutputStream wtr;
    private boolean init;
    private long totalOut;
    private boolean eofRead;
    private int predictor;
    private int samplesPerRow;
    private int componentsPerSample;
    private int componentsPerRow;
    private int bitsPerComponent;
    private int bytesPerSample;
    private int rowPredictor;
    private int nRows;
    private byte[][] row;
    private int[] predictedComponent;
    private int curSample;
    private int curComponent;
    private int num_pixels_processed = 0;
    private short currComp = 0;

    private TIFFEngine(boolean encode) {
        this.encode = encode;
        this.init = false;
        this.predictor = 1;
        this.samplesPerRow = 1;
        this.componentsPerSample = 1;
        this.bitsPerComponent = 8;
    }

    public TIFFEngine(InputStream in, FilterParams p) {
        this(false);
        this.rdr = (TIFFInputStream)in;
        this.engineInit(p);
    }

    public TIFFEngine(InputStream in) {
        this(in, null);
    }

    public TIFFEngine(OutputStream w, FilterParams p) {
        this(true);
        this.wtr = w;
        this.engineInit(p);
    }

    public TIFFEngine(OutputStream w) {
        this(w, null);
    }

    private void engineInit(FilterParams p) {
        if (p != null) {
            if (p.containsKey("Predictor")) {
                this.predictor = (Integer)p.get("Predictor");
            }
            if (p.containsKey("Columns")) {
                this.samplesPerRow = (Integer)p.get("Columns");
            }
            if (p.containsKey("Components")) {
                this.componentsPerSample = (Integer)p.get("Components");
            }
            if (p.containsKey("BitsPerComponent")) {
                this.bitsPerComponent = (Integer)p.get("BitsPerComponent");
            }
        }
    }

    private void initTIFFPredictor() {
        int bytesPerRow;
        if (this.samplesPerRow < 1 || this.componentsPerSample < 1 || this.bitsPerComponent < 1) {
            this.predictor = 1;
        }
        this.nRows = 0;
        switch (this.predictor) {
            case 2: {
                if (this.bitsPerComponent == 1 || this.bitsPerComponent == 2 || this.bitsPerComponent == 4 || this.bitsPerComponent == 8 || this.bitsPerComponent == 16) break;
                throw new PDFUnsupportedFeatureException("Predictor value 2 (Horizontal Differencing) is not supported for" + this.bitsPerComponent + " bis per component");
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.nRows = 2;
                break;
            }
            default: {
                this.predictor = 1;
            }
        }
        int bitsPerSample = this.componentsPerSample * this.bitsPerComponent;
        this.bytesPerSample = (bitsPerSample + 7) / 8;
        this.componentsPerRow = bytesPerRow = (this.samplesPerRow * bitsPerSample + 7) / 8;
        this.rowPredictor = -1;
        this.predictedComponent = new int[this.componentsPerSample];
        for (int j = 0; j < this.componentsPerSample; ++j) {
            this.predictedComponent[j] = 0;
        }
        this.row = new byte[this.nRows][];
        for (int i = 0; i < this.nRows; ++i) {
            this.row[i] = new byte[bytesPerRow + this.bytesPerSample];
            for (int j = 0; j < bytesPerRow + this.bytesPerSample; ++j) {
                this.row[i][j] = 0;
            }
        }
        this.curSample = 0;
        this.curComponent = 0;
        this.eofRead = false;
        this.init = true;
    }

    public int applyTIFFPredictor(int b) throws IOException {
        int result = 0;
        int pred = 0;
        if (!this.init) {
            this.initTIFFPredictor();
        }
        if (b < 0 && this.bitsPerComponent != 16) {
            this.eofRead = true;
        }
        if (this.eofRead) {
            return -1;
        }
        block0 : switch (this.predictor) {
            case 1: {
                result = b & 0xFF;
                break;
            }
            case 2: {
                if (this.bitsPerComponent == 8) {
                    if (this.encode) {
                        int nextPrediction = b & 0xFF;
                        result = nextPrediction - this.predictedComponent[this.curComponent] & 0xFF;
                        this.predictedComponent[this.curComponent] = nextPrediction;
                    } else {
                        this.predictedComponent[this.curComponent] = result = b + this.predictedComponent[this.curComponent] & 0xFF;
                    }
                    if (++this.curComponent != this.componentsPerSample) break;
                    this.curComponent = 0;
                    if (++this.curSample != this.samplesPerRow) break;
                    this.curSample = 0;
                    for (int j = 0; j < this.componentsPerSample; ++j) {
                        this.predictedComponent[j] = 0;
                    }
                    break;
                }
                if (this.bitsPerComponent == 16) {
                    if (this.num_pixels_processed == this.samplesPerRow) {
                        this.num_pixels_processed = 0;
                        this.currComp = 0;
                        Arrays.fill(this.predictedComponent, 0);
                    }
                    if (this.encode) {
                        result = (short)(b - this.predictedComponent[this.currComp]);
                        this.predictedComponent[this.currComp] = b;
                    } else {
                        this.predictedComponent[this.currComp] = result = (int)((short)(this.predictedComponent[this.currComp] + b));
                    }
                    this.currComp = (short)(this.currComp + 1);
                    if (this.currComp != this.componentsPerSample) break;
                    this.currComp = 0;
                    ++this.num_pixels_processed;
                    break;
                }
                int baseMask = (1 << this.bitsPerComponent) - 1;
                int shift = 8 - this.bitsPerComponent;
                int mask = baseMask << shift;
                result = 0;
                while (mask != 0) {
                    int nextPrediction;
                    if (this.encode) {
                        nextPrediction = (b & mask) >>> shift;
                        result += (nextPrediction - this.predictedComponent[this.curComponent] & baseMask) << shift;
                        this.predictedComponent[this.curComponent] = nextPrediction;
                    } else {
                        nextPrediction = (b & mask) >>> shift;
                        result = (nextPrediction + this.predictedComponent[this.curComponent] & baseMask) << shift;
                        this.predictedComponent[this.curComponent] = nextPrediction;
                    }
                    if (++this.curComponent == this.componentsPerSample) {
                        this.curComponent = 0;
                        if (++this.curSample == this.samplesPerRow) {
                            this.curSample = 0;
                            for (int j = 0; j < this.componentsPerSample; ++j) {
                                this.predictedComponent[j] = 0;
                            }
                            break block0;
                        }
                    }
                    mask >>>= this.bitsPerComponent;
                    shift -= this.bitsPerComponent;
                }
                break;
            }
            default: {
                if (this.rowPredictor == -1) {
                    if (this.encode) {
                        this.rowPredictor = this.predictor < 15 ? this.predictor - 10 : 1;
                        this.wtr.write(this.rowPredictor);
                    } else {
                        if (b > 4) {
                            this.eofRead = true;
                            return -1;
                        }
                        this.rowPredictor = b;
                        b = this.rdr.read1();
                        if (b < 0) {
                            this.eofRead = true;
                            return -1;
                        }
                    }
                }
                switch (this.rowPredictor) {
                    default: {
                        pred = 0;
                        break;
                    }
                    case 1: {
                        pred = this.left() & 0xFF;
                        break;
                    }
                    case 2: {
                        pred = this.above() & 0xFF;
                        break;
                    }
                    case 3: {
                        pred = (this.left() & 0xFF) + (this.above() & 0xFF) >> 1;
                        break;
                    }
                    case 4: {
                        int a = this.left() & 0xFF;
                        int d = this.above() & 0xFF;
                        int c = this.aboveLeft() & 0xFF;
                        int p = a + d - c;
                        int pa = Math.abs(p - a);
                        int pb = Math.abs(p - d);
                        int pc = Math.abs(p - c);
                        int n = pa <= pb && pa <= pc ? a : (pred = pb <= pc ? d : c);
                    }
                }
                if (this.encode) {
                    result = b - pred & 0xFF;
                    this.row[0][this.curComponent] = (byte)b;
                } else {
                    result = b + pred & 0xFF;
                    this.row[0][this.curComponent] = (byte)result;
                }
                ++this.curComponent;
                if (this.curComponent != this.componentsPerRow) break;
                byte[] t = this.row[this.nRows - 1];
                for (int i = this.nRows - 1; i > 0; --i) {
                    this.row[i] = this.row[i - 1];
                }
                this.row[0] = t;
                this.curComponent = 0;
                this.rowPredictor = -1;
            }
        }
        return result;
    }

    private byte left() {
        if (this.curComponent >= this.bytesPerSample) {
            return this.row[0][this.curComponent - this.bytesPerSample];
        }
        return 0;
    }

    private byte above() {
        return this.row[1][this.curComponent];
    }

    private byte aboveLeft() {
        if (this.curComponent >= this.bytesPerSample) {
            return this.row[1][this.curComponent - this.bytesPerSample];
        }
        return 0;
    }

    protected void put(int b) throws IOException {
        int result = this.applyTIFFPredictor(b);
        if (this.bitsPerComponent != 16) {
            this.wtr.write(result);
            ++this.totalOut;
        } else {
            this.wtr.write((byte)((result & 0xFF00) >> 8));
            this.wtr.write((byte)(result & 0xFF));
        }
    }

    public long getTotalOut() {
        return this.totalOut;
    }

    int getBitsPerComponent() {
        return this.bitsPerComponent;
    }
}

