/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RunLengthOutputStream
extends FilterOutputStream {
    private static final int ED = 128;
    private boolean repeat;
    private int count;
    private byte repeatChar;
    private byte[] single;
    private long totalOut;

    public RunLengthOutputStream(OutputStream out) {
        super(out);
        this.initOutput();
    }

    private void initOutput() {
        this.count = -1;
        this.single = new byte[128];
        this.totalOut = 0L;
    }

    private void newSequence(int b) {
        this.repeat = false;
        this.count = 0;
        this.repeatChar = (byte)b;
        this.single[0] = (byte)b;
    }

    private void dumpRun(int count) throws IOException {
        if (count >= 0) {
            this.out.write(count);
            for (int i = 0; i <= count; ++i) {
                this.out.write(this.single[i] & 0xFF);
            }
            this.totalOut += (long)(count + 2);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.count < 0) {
            this.newSequence(b);
        } else if (this.repeat) {
            if ((byte)b != this.repeatChar || this.count == 127) {
                this.out.write(256 - this.count);
                this.out.write(this.repeatChar & 0xFF);
                this.totalOut += 2L;
                this.newSequence(b);
            } else {
                ++this.count;
            }
        } else if (this.count > 0 && (byte)b == this.single[this.count] && (byte)b == this.single[this.count - 1]) {
            this.dumpRun(this.count - 2);
            this.newSequence(b);
            this.repeat = true;
            this.count = 2;
        } else if (this.count == 127 && (byte)b == this.single[this.count]) {
            this.dumpRun(this.count - 1);
            this.newSequence(b);
            this.repeat = true;
            this.count = 1;
        } else if (this.count == 127) {
            this.dumpRun(this.count);
            this.newSequence(b);
        } else {
            this.single[++this.count] = (byte)b;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int maxWrite = b.length - off;
        if (maxWrite > len) {
            maxWrite = len;
        }
        while (maxWrite-- > 0) {
            this.write(b[off++] & 0xFF);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        if (this.repeat) {
            this.out.write(256 - this.count);
            this.out.write(this.repeatChar);
            this.totalOut += 2L;
        } else {
            this.dumpRun(this.count);
        }
        this.out.write(128);
        ++this.totalOut;
        super.close();
    }

    public long getTotalOut() {
        return this.totalOut;
    }
}

