/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.DecodeInputStream;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.FlateFilterException;
import com.adobe.internal.pdftoolkit.core.filter.HuffTree;
import java.io.InputStream;

public class FlateInputStream
extends DecodeInputStream {
    private boolean isInit;
    private static final byte[] border = new byte[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    private static final short[] cplens = new short[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0};
    private static final byte[] cplext = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, -128, -128};
    private static final short[] cpdist = new short[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
    private static final byte[] cpdext = new byte[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
    private static final int TYPE = 0;
    private static final int LENS = 1;
    private static final int STORED = 2;
    private static final int TABLE = 3;
    private static final int CODES = 6;
    private static final int COPY = 7;
    private static final int DONE = 8;
    private static final int BAD = 9;
    private static final int FINAL = 10;
    private int blockMode;
    private HuffTree blockLengthTree;
    private HuffTree fixedLengthTree;
    private HuffTree blockDistTree;
    private HuffTree fixedDistTree;
    private boolean lastBlock;
    private boolean localEOF;
    private int wbits;
    private int wmask;
    private byte[] window;
    private int windex;
    private int rawBits;
    private int rawBitsLeft;
    private static final int Adler_BASE = 65521;
    private int adler_s1;
    private int adler_s2;

    public FlateInputStream(InputStream in, int inSize, int outSize, FilterParams diparams) {
        super(in, inSize, outSize, 0, diparams);
        this.initInput();
    }

    public FlateInputStream(InputStream in, FilterParams p) {
        super(in, 0, p);
        this.initInput();
    }

    public FlateInputStream(InputStream in) {
        this(in, null);
    }

    private void initInput() {
        this.isInit = false;
    }

    @Override
    public void fill() {
        if (!this.isInit) {
            this.inflateInit();
            this.isInit = true;
        }
        this.inflate_blocks();
    }

    private int GetBits(int t) {
        while (t > this.rawBitsLeft && !this.pendingEOF && this.pendingException == null) {
            if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
                this.pendingException = new FlateFilterException("Flate: missing EOF");
                break;
            }
            int inChar = this.inBuf[this.inPos++] & 0xFF;
            this.rawBits += inChar << this.rawBitsLeft;
            this.rawBitsLeft += 8;
        }
        if (t > this.rawBitsLeft) {
            t = this.rawBitsLeft;
        }
        return this.rawBits & (1 << t) - 1;
    }

    private void DumpBits(int t) {
        if (t > this.rawBitsLeft) {
            this.GetBits(t);
            if (t > this.rawBitsLeft) {
                t = this.rawBitsLeft;
            }
        }
        this.rawBits >>>= t;
        this.rawBitsLeft -= t;
    }

    private void DumpBitsToByte() {
        this.DumpBits(this.rawBitsLeft & 7);
    }

    private boolean AtEOF() {
        return this.localEOF && this.rawBitsLeft == 0;
    }

    private void Adler32(int b) {
        this.adler_s1 += b & 0xFF;
        if (this.adler_s1 >= 65521) {
            this.adler_s1 -= 65521;
        }
        this.adler_s2 += this.adler_s1;
        if (this.adler_s2 >= 65521) {
            this.adler_s2 -= 65521;
        }
    }

    private void checkAdler() {
        this.DumpBitsToByte();
        int a1 = this.adler_s1;
        int a2 = this.adler_s2;
        int s2 = this.GetBits(8) << 8;
        this.DumpBits(8);
        this.DumpBits(8);
        int s1 = this.GetBits(8) << 8;
        this.DumpBits(8);
        this.DumpBits(8);
        if ((s1 += this.GetBits(8)) != a1 || (s2 += this.GetBits(8)) != a2) {
            this.blockMode = 9;
        }
        this.localEOF = true;
    }

    void inflate_blocks() {
        block26: while (this.outCount < this.outBuf.length && !this.pendingEOF && this.pendingException == null) {
            int copyLen = 0;
            int copyOffset = 0;
            block0 : switch (this.blockMode) {
                case 0: {
                    int t = this.GetBits(3);
                    this.DumpBits(3);
                    if ((t & 1) != 0) {
                        this.lastBlock = (t & 1) != 0 || this.AtEOF();
                    }
                    switch (t >> 1) {
                        case 0: {
                            this.DumpBitsToByte();
                            this.blockMode = 1;
                            break block0;
                        }
                        case 1: {
                            int i;
                            int[] b;
                            if (this.fixedLengthTree == null) {
                                b = new int[288];
                                for (i = 0; i <= 143; ++i) {
                                    b[i] = 8;
                                }
                                for (i = 144; i <= 255; ++i) {
                                    b[i] = 9;
                                }
                                for (i = 256; i <= 279; ++i) {
                                    b[i] = 7;
                                }
                                for (i = 280; i <= 287; ++i) {
                                    b[i] = 8;
                                }
                                this.fixedLengthTree = new HuffTree(b, 288, 257, cplens, cplext, 9);
                            }
                            if (this.fixedDistTree == null) {
                                b = new int[31];
                                for (i = 0; i < 31; ++i) {
                                    b[i] = 5;
                                }
                                this.fixedDistTree = new HuffTree(b, 30, 0, cpdist, cpdext, 6);
                            }
                            this.blockLengthTree = this.fixedLengthTree;
                            this.blockDistTree = this.fixedDistTree;
                            this.blockMode = 6;
                            break block0;
                        }
                        case 2: {
                            this.blockMode = 3;
                            break block0;
                        }
                        case 3: {
                            this.blockMode = 9;
                            continue block26;
                        }
                    }
                    break;
                }
                case 1: {
                    copyLen = this.GetBits(16);
                    this.DumpBits(16);
                    if (this.GetBits(16) != (copyLen ^ 0xFFFF)) {
                        this.blockMode = 9;
                        continue block26;
                    }
                    this.DumpBits(16);
                    this.blockMode = copyLen > 0 ? 2 : (this.lastBlock ? 8 : 0);
                    break;
                }
                case 2: {
                    int result = this.GetBits(8);
                    this.DumpBits(8);
                    --copyLen;
                    if (this.AtEOF()) {
                        this.lastBlock = true;
                        copyLen = 0;
                    }
                    this.outBuf[this.outCount++] = this.window[this.windex] = (byte)result;
                    this.Adler32(result);
                    this.windex = this.windex + 1 & this.wmask;
                    this.blockMode = copyLen > 0 ? 2 : (this.lastBlock ? 8 : 0);
                    break;
                }
                case 3: {
                    int i;
                    int hLit = 257 + this.GetBits(5);
                    this.DumpBits(5);
                    int hDist = 1 + this.GetBits(5);
                    this.DumpBits(5);
                    int hClen = 4 + this.GetBits(4);
                    this.DumpBits(4);
                    if (hLit > 288 || hDist > 30) {
                        this.blockMode = 9;
                        continue block26;
                    }
                    int btSize = hLit + hDist;
                    if (btSize < 19) {
                        btSize = 19;
                    }
                    int[] b = new int[btSize];
                    int[] bt = new int[19];
                    for (i = 0; i < 19; ++i) {
                        bt[i] = 0;
                    }
                    for (i = 0; i < hClen; ++i) {
                        bt[FlateInputStream.border[i]] = this.GetBits(3);
                        this.DumpBits(3);
                    }
                    HuffTree bTree = new HuffTree(bt, 19, 19, null, null, 7);
                    int ti = 0;
                    while (ti < btSize) {
                        int j;
                        int e = 0 + bTree.maxLook;
                        int t = 0;
                        while ((e & 0xE0) == 0 && e != 0) {
                            j = this.GetBits(e & 0xF);
                            this.DumpBits(bTree.Bits[t + j]);
                            e = bTree.Exop[t + j];
                            t = bTree.Base[t + j];
                        }
                        if (e != 0) {
                            this.blockMode = 9;
                            continue block26;
                        }
                        if (t < 16) {
                            b[ti++] = t;
                            continue;
                        }
                        switch (t) {
                            case 16: {
                                i = 2;
                                j = 3;
                                break;
                            }
                            case 17: {
                                i = 3;
                                j = 3;
                                break;
                            }
                            case 18: {
                                i = 7;
                                j = 11;
                                break;
                            }
                            default: {
                                this.blockMode = 9;
                                j = 0;
                                i = 0;
                                continue block26;
                            }
                        }
                        this.DumpBits(i);
                        if ((j += ti + this.GetBits(i)) > btSize || t == 16 && ti == 0) {
                            this.blockMode = 9;
                            continue block26;
                        }
                        if (t == 16) {
                            while (ti < j) {
                                b[ti] = b[ti - 1];
                                ++ti;
                            }
                            continue;
                        }
                        while (ti < j) {
                            b[ti++] = 0;
                        }
                    }
                    this.blockLengthTree = new HuffTree(b, hLit, 257, cplens, cplext, 9);
                    for (i = 0; i < hDist; ++i) {
                        b[i] = b[hLit + i];
                    }
                    this.blockDistTree = new HuffTree(b, hDist, 0, cpdist, cpdext, 6);
                    if (this.blockLengthTree.Bits == null || this.blockDistTree.Bits == null) {
                        this.blockMode = 9;
                        continue block26;
                    }
                    this.blockMode = 6;
                }
                case 6: {
                    int e = 0 + this.blockLengthTree.maxLook;
                    int t = 0;
                    while ((e & 0xE0) == 0 && e != 0) {
                        int j = this.GetBits(e & 0xF);
                        this.DumpBits(this.blockLengthTree.Bits[t + j]);
                        e = this.blockLengthTree.Exop[t + j];
                        t = this.blockLengthTree.Base[t + j];
                    }
                    switch (e & 0xE0) {
                        case 0: {
                            this.outBuf[this.outCount++] = this.window[this.windex] = (byte)t;
                            this.Adler32(t);
                            this.windex = this.windex + 1 & this.wmask;
                            break block0;
                        }
                        case 64: {
                            copyLen = t + this.GetBits(e & 0xF);
                            this.DumpBits(e & 0xF);
                            e = 0 + this.blockDistTree.maxLook;
                            t = 0;
                            while ((e & 0xE0) == 0 && e != 0) {
                                int j = this.GetBits(e & 0xF);
                                this.DumpBits(this.blockDistTree.Bits[t + j]);
                                e = this.blockDistTree.Exop[t + j];
                                t = this.blockDistTree.Base[t + j];
                            }
                            if ((e & 0xE0) != 64) {
                                this.blockMode = 9;
                                continue block26;
                            }
                            copyOffset = t + this.GetBits(e & 0xF);
                            this.DumpBits(e & 0xF);
                            this.blockMode = 7;
                            break block0;
                        }
                        case 96: {
                            this.blockLengthTree = null;
                            this.blockDistTree = null;
                            this.blockMode = this.lastBlock ? 8 : 0;
                            break block0;
                        }
                    }
                    this.blockLengthTree = null;
                    this.blockDistTree = null;
                    this.blockMode = 9;
                    continue block26;
                }
                case 7: {
                    int result = this.window[this.windex - copyOffset & this.wmask] & 0xFF;
                    this.outBuf[this.outCount++] = this.window[this.windex] = (byte)result;
                    this.Adler32(result);
                    this.windex = this.windex + 1 & this.wmask;
                    if (--copyLen > 0) continue block26;
                    this.blockMode = 6;
                    break;
                }
                default: {
                    this.blockMode = 10;
                    if (this.pendingException != null) break block26;
                    this.pendingException = new FlateFilterException("Flate: bad input stream");
                    break block26;
                }
                case 8: {
                    this.blockMode = 10;
                    this.checkAdler();
                    break;
                }
                case 10: {
                    this.blockLengthTree = null;
                    this.blockDistTree = null;
                    this.fixedLengthTree = null;
                    this.fixedDistTree = null;
                    this.pendingEOF = true;
                    break block26;
                }
            }
        }
    }

    private void inflateInit() {
        this.localEOF = false;
        this.rawBitsLeft = 0;
        this.rawBits = 0;
        this.blockLengthTree = null;
        this.fixedLengthTree = null;
        this.blockDistTree = null;
        this.fixedDistTree = null;
        int cmf = this.GetBits(8);
        this.DumpBits(8);
        int flg = this.GetBits(8);
        this.DumpBits(8);
        if (this.localEOF || ((cmf << 8) + flg) % 31 != 0 || (cmf & 0xF) != 8 || (flg & 0x20) != 0) {
            this.blockMode = 9;
            this.lastBlock = true;
        } else {
            this.adler_s1 = 1;
            this.adler_s2 = 0;
            this.wbits = (cmf >> 4) + 8;
            this.wmask = (1 << this.wbits) - 1;
            this.window = new byte[this.wmask + 1];
            this.windex = 0;
            this.blockMode = 0;
            this.lastBlock = false;
        }
    }
}

