/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption.impl;

import com.adobe.internal.pdftoolkit.core.credentials.impl.RSACredentials;
import com.adobe.internal.pdftoolkit.core.encryption.impl.KDFDataDecryptor;
import com.adobe.internal.pdftoolkit.core.encryption.impl.PKCS7Utils;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJException;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.InfoObjectFactory;
import com.rsa.certj.cms.KeyAgreeRecipientInfo;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_KeyAgree;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.util.Map;
import java.util.Random;

public class CMSEnvelopedDataEncryptor {
    private JSAFE_PublicKey originator_PublicKey = null;
    private JSAFE_PrivateKey originator_PrivateKey = null;

    byte[] encryptEnvelopedData(RSACredentials[] rsaCredentials, X509Certificate[] rsaCertificates, byte[] envelopedData, String[] algorithms, Map encryptParams) throws GeneralSecurityException, JSAFE_Exception, CertJException, IOException, ASN_Exception {
        ByteArrayOutputStream encodedEnvelopedDataStream = new ByteArrayOutputStream();
        try {
            int certInd = 0;
            while (certInd < rsaCredentials.length) {
                X509Certificate recipientECDHCrt = rsaCertificates[certInd++];
                encodedEnvelopedDataStream.write(this.createEncryptedEnvelopedData(envelopedData, recipientECDHCrt, algorithms, encryptParams));
            }
        }
        catch (Exception exception) {
            throw new CertificateEncodingException(" Issue while encoding the enveloped data. " + exception);
        }
        finally {
            this.originator_PrivateKey.clearSensitiveData();
            this.originator_PublicKey.clearSensitiveData();
        }
        return encodedEnvelopedDataStream.toByteArray();
    }

    private byte[] createEncryptedEnvelopedData(byte[] envelopedData, X509Certificate recipientECDHCrt, String[] algorithms, Map encryptParams) throws ASN_Exception, NameException, JSAFE_Exception, CertificateException, NoSuchAlgorithmException, IOException {
        Map cfmDict = (Map)((Map)encryptParams.get(ASName.k_CF.asString())).get("DefaultCryptFilter");
        int length = (Integer)cfmDict.get("Length");
        String encryptionAlgorithm = (String)cfmDict.get("CFM");
        byte[] secret = this.getECDHSharedSecret(recipientECDHCrt, length);
        KeyAgreeRecipientInfo keyAgreeRecipientInfo = InfoObjectFactory.newKeyAgreeRecipientInfo((JSAFE_PublicKey)this.originator_PublicKey, (JSAFE_PrivateKey)this.originator_PrivateKey, (X509Certificate)recipientECDHCrt);
        byte[] recipientSerialNumber = keyAgreeRecipientInfo.getRecipientSerialNumber();
        byte[] derEncodingRDN = this.getDEREncodedRecipientIdentifier(keyAgreeRecipientInfo);
        byte[] fUKM = this.fillWithRandom(8);
        OctetStringContainer ukmOctetStringContainer = new OctetStringContainer(0, true, 0, fUKM, 0, fUKM.length);
        OIDContainer ecPublicKeyOID = PKCS7Utils.getECPublicKeyOID();
        OIDContainer ecPublicKeyPrimeOID = PKCS7Utils.getECPublicKeyPrimeOID(algorithms[0]);
        byte[] ecPublicKeyValue = this.originator_PublicKey.getKeyData("ECPublicKeyValue")[0];
        BitStringContainer publicKeyContainer = new BitStringContainer(0, true, 0, ecPublicKeyValue, 0, ecPublicKeyValue.length);
        byte[] ecdhOID = PKCS7Utils.getECDHOID(length);
        OIDContainer ecdh_SHA_KDF_OID = new OIDContainer(0x1000000, true, 0, ecdhOID, 0, ecdhOID.length);
        byte[] keyEncryptionOID = PKCS7Utils.getKeyEncryptionAlgorithmOid(encryptionAlgorithm);
        OIDContainer keyEncryptionAlgorithmOid = new OIDContainer(0x1000000, true, 5, keyEncryptionOID, 0, keyEncryptionOID.length);
        KDFDataDecryptor dataDecryptor = new KDFDataDecryptor(null, keyEncryptionOID, ukmOctetStringContainer, ecdhOID);
        byte[] kdfKey = dataDecryptor.applyKDFWrap(secret);
        JSAFE_SecretKey secretKey = this.generateRandomSecretkey(Math.abs(length));
        byte[] encryptedKey = dataDecryptor.encryptKey(kdfKey, secretKey);
        OctetStringContainer encryptedKeyContainer = new OctetStringContainer(0, true, 0, encryptedKey, 0, encryptedKey.length);
        byte[] dataEncryptionAlgorithmOID = PKCS7Utils.getDataEncryptionAlgorithmOid(encryptionAlgorithm);
        OIDContainer pkcs7DataOID = PKCS7Utils.getPKCS7DataOID();
        OIDContainer envelopeDataEncryptionAlgorithmOID = new OIDContainer(0, true, 0, dataEncryptionAlgorithmOID, 0, dataEncryptionAlgorithmOID.length);
        byte[] ecDataInitialVector = this.fillWithRandom(16);
        OctetStringContainer ecDataIVContainer = new OctetStringContainer(0, true, 0, ecDataInitialVector, 0, ecDataInitialVector.length);
        byte[] encryptedData = this.encryptedData(secretKey, ecDataInitialVector, envelopedData, dataEncryptionAlgorithmOID);
        OctetStringContainer encryptedDataContainer = new OctetStringContainer(0x810000, true, 0, encryptedData, 0, encryptedData.length);
        OIDContainer envelopedDataOid = PKCS7Utils.getEnvelopedDataOID();
        secretKey.clearSensitiveData();
        ASN1Container[] envelopedDataContainers = new ASN1Container[]{new SequenceContainer(0), envelopedDataOid, new ChoiceContainer(0xA0FF00), new SequenceContainer(0), new IntegerContainer(0, true, 0, 0), new SetContainer(0), new ChoiceContainer(10551041), new SequenceContainer(0), new IntegerContainer(0, true, 0, 3), new ChoiceContainer(0xA0FF00), new ChoiceContainer(10551041), new SequenceContainer(0), new SequenceContainer(0), ecPublicKeyOID, ecPublicKeyPrimeOID, new EndContainer(), publicKeyContainer, new EndContainer(), new EndContainer(), new EndContainer(), new ChoiceContainer(10551041), ukmOctetStringContainer, new EndContainer(), new SequenceContainer(0), ecdh_SHA_KDF_OID, new SequenceContainer(0), keyEncryptionAlgorithmOid, new EndContainer(), new EndContainer(), new SequenceContainer(0), new SequenceContainer(0), new SequenceContainer(0), new EncodedContainer(0, true, 48, derEncodingRDN, 3, derEncodingRDN.length - 3), new IntegerContainer(0, true, 0, recipientSerialNumber, 0, recipientSerialNumber.length, true), new EndContainer(), encryptedKeyContainer, new EndContainer(), new EndContainer(), new EndContainer(), new EndContainer(), new EndContainer(), new SequenceContainer(0), pkcs7DataOID, new SequenceContainer(0), envelopeDataEncryptionAlgorithmOID, ecDataIVContainer, new EndContainer(), encryptedDataContainer, new EndContainer(), new EndContainer(), new EndContainer(), new EndContainer()};
        return ASN1.derEncode((ASN1Container[])envelopedDataContainers);
    }

    byte[] encryptedData(JSAFE_SecretKey inKey, byte[] ecDataInitialVector, byte[] envelopedData, byte[] dataEncryptionAlgorithm) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException, JSAFE_InputException, JSAFE_PaddingException, IOException {
        JSAFE_SymmetricCipher symmetricCipher = PKCS7Utils.getSymmetricCipher(dataEncryptionAlgorithm);
        symmetricCipher.setIV(ecDataInitialVector, 0, ecDataInitialVector.length);
        symmetricCipher.encryptInit(inKey);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(symmetricCipher.encryptUpdate(envelopedData, 0, envelopedData.length));
        outputStream.write(symmetricCipher.encryptFinal());
        return outputStream.toByteArray();
    }

    private JSAFE_SecretKey generateRandomSecretkey(int keySize) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_InvalidUseException, NoSuchAlgorithmException {
        JSAFE_SecretKey secretKey = JSAFE_SecretKey.getInstance((String)"AES", (String)"Java");
        int[] keyParameters = new int[]{keySize};
        secretKey.generateInit(keyParameters, PKCS7Utils.getSecureRandom(keySize));
        secretKey.generate();
        return secretKey;
    }

    private byte[] getECDHSharedSecret(X509Certificate recipientECDHCrt, int keySize) throws JSAFE_InvalidKeyException, JSAFE_InvalidUseException, JSAFE_UnimplementedException, JSAFE_InvalidParameterException, NoSuchAlgorithmException, CertificateException {
        JSAFE_PublicKey recipientPublicKey = recipientECDHCrt.getSubjectPublicKey("Java");
        JSAFE_KeyAgree sender = JSAFE_KeyAgree.getInstance((String)"ECDH", (String)"Java");
        sender.keyAgreeInit(recipientPublicKey, PKCS7Utils.getSecureRandom(keySize));
        this.originator_PublicKey = sender.generateMyPublicValue();
        this.originator_PrivateKey = sender.getPrivateValueAsKey();
        return sender.generateSharedSecret();
    }

    private byte[] fillWithRandom(int size) {
        byte[] random = new byte[size];
        new Random().nextBytes(random);
        return random;
    }

    private byte[] getDEREncodedRecipientIdentifier(KeyAgreeRecipientInfo keyAgreeRecipientInfo) throws CMSException, NameException {
        X500Name recipientIssuer = keyAgreeRecipientInfo.getRecipientIssuer();
        int length = recipientIssuer.getDERLen(0);
        byte[] derEncodingRDN = new byte[length + 3];
        recipientIssuer.getDEREncoding(derEncodingRDN, 0, 0xA00000);
        return derEncodingRDN;
    }

    public void closeQuietly(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

