/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import java.util.Map;

public class CosSaveParams
implements Cloneable {
    public static final int CURRENT_XREF = 0;
    public static final int XREFTABLE = 1;
    public static final int XREFSTREAM = 2;
    public static final int XREFHYBRID = 3;
    public static final int SAVE_STYLE_DEFAULT = 0;
    public static final int SAVE_STYLE_INCREMENTAL = 1;
    public static final int SAVE_STYLE_FULL = 2;
    public static final int SAVE_STYLE_LINEAR = 3;
    private String mHeader = null;
    private String mHeaderToken = null;
    private String mVersion = null;
    private Map mExtensions = null;
    private int mXrefStyle = 0;
    private int mSaveStyle = 0;
    private ByteWriter mTempByteWriter = null;
    private boolean mCloseAfterSave = false;
    private boolean mSaveToCopy = false;
    private boolean mForceCompress = false;

    public CosSaveParams(int saveStyle) {
        this.mSaveStyle = saveStyle;
    }

    public void setHeader(String header) {
        this.mHeader = header;
    }

    public String getHeader() {
        return this.mHeader;
    }

    public void setHeaderToken(String headerToken) throws PDFInvalidParameterException {
        this.mHeaderToken = headerToken;
        if (this.mHeaderToken != null) {
            if (this.mHeaderToken.length() > 10) {
                throw new PDFInvalidParameterException("Header token too long");
            }
            for (int i = 0; i < this.mHeaderToken.length(); ++i) {
                char c = this.mHeaderToken.charAt(i);
                if (c != '\r' && c != '\n' && (c & 0xFF00) == 0) continue;
                throw new PDFInvalidParameterException("Illegal header token");
            }
        }
    }

    public String getHeaderToken() {
        return this.mHeaderToken;
    }

    public void setVersion(String version) {
        this.mVersion = version;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public Map getExtensions() {
        return this.mExtensions;
    }

    public void setExtensions(Map extensions) {
        this.mExtensions = extensions;
    }

    public void setXrefStyle(int xrefstyle) {
        this.mXrefStyle = xrefstyle;
    }

    public int getXrefStyle() {
        return this.mXrefStyle;
    }

    public void setSaveStyle(int saveStyle) {
        this.mSaveStyle = saveStyle;
    }

    public int getSaveStyle() {
        return this.mSaveStyle;
    }

    public void setCloseAfterSave(boolean closeAfterSave) {
        this.mCloseAfterSave = closeAfterSave;
    }

    public boolean getCloseAfterSave() {
        return this.mCloseAfterSave;
    }

    public void setForceCompress(boolean forceCompress) {
        this.mForceCompress = forceCompress;
    }

    public boolean getForceCompress() {
        return this.mForceCompress;
    }

    public void setTempByteWriter(ByteWriter tempByteWriter) {
        this.mTempByteWriter = tempByteWriter;
    }

    public ByteWriter getTempByteWriter() {
        return this.mTempByteWriter;
    }

    public void setSaveToCopy(boolean saveToCopy) {
        this.mSaveToCopy = saveToCopy;
    }

    public boolean getSaveToCopy() {
        return this.mSaveToCopy;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

