/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.postscript;

import com.adobe.fontengine.font.CoolTypeScript;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.postscript.GlyphNamesAccessor;
import java.util.regex.Pattern;

public final class ScriptHeuristics {
    static final Pattern cePattern = Pattern.compile(".*[^A-Z]CE[^A-Za-z].*");
    static final Pattern cyrPattern = Pattern.compile(".*[^A-Z]Cyr[^A-Za-z].*");

    private static CoolTypeScript getCoolTypeScriptFromPostscriptName(String psName) {
        if (psName == null) {
            return null;
        }
        if (cePattern.matcher(psName).find()) {
            return CoolTypeScript.EAST_EUROPEAN_ROMAN;
        }
        if (cyrPattern.matcher(psName).find()) {
            return CoolTypeScript.CYRILLIC;
        }
        if (psName.startsWith("ALBAYAN")) {
            return CoolTypeScript.ARABIC;
        }
        return null;
    }

    private static CoolTypeScript getCoolTypeScriptFromEncodedGlyphComplement(int numGlyphs, GlyphNamesAccessor glyphNames) throws InvalidFontException, UnsupportedFontException {
        if (glyphNames == null) {
            return null;
        }
        boolean hasShin = false;
        boolean hasPatah = false;
        boolean hasSheen = false;
        boolean hasFatha = false;
        for (int gid = 0; gid < numGlyphs; ++gid) {
            String glyphName = glyphNames.getAGlyphName(gid);
            if ("Tcaron".equals(glyphName)) {
                return CoolTypeScript.EAST_EUROPEAN_ROMAN;
            }
            if ("afii10049".equals(glyphName)) {
                return CoolTypeScript.CYRILLIC;
            }
            if (glyphName.startsWith("patah")) {
                if (hasShin) {
                    return CoolTypeScript.HEBREW;
                }
                hasPatah = true;
            }
            if (glyphName.startsWith("shin")) {
                if (hasPatah) {
                    return CoolTypeScript.HEBREW;
                }
                hasShin = true;
            }
            if (glyphName.startsWith("fatha")) {
                if (hasSheen) {
                    return CoolTypeScript.ARABIC;
                }
                hasFatha = true;
            }
            if (!glyphName.startsWith("sheen")) continue;
            if (hasFatha) {
                return CoolTypeScript.ARABIC;
            }
            hasSheen = true;
        }
        return null;
    }

    public static CoolTypeScript getCoolTypeScript(String psName, int numGlyphs, GlyphNamesAccessor glyphNames) throws InvalidFontException, UnsupportedFontException {
        CoolTypeScript ctScript = ScriptHeuristics.getCoolTypeScriptFromPostscriptName(psName);
        if (ctScript != null) {
            return ctScript;
        }
        ctScript = ScriptHeuristics.getCoolTypeScriptFromEncodedGlyphComplement(numGlyphs, glyphNames);
        if (ctScript != null) {
            return ctScript;
        }
        return CoolTypeScript.ROMAN;
    }
}

