/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.db;

import java.util.HashMap;
import java.util.Map;

public class SQLToJavaTypes {
    private static Map<Integer, String> sqlTypeVsJavaType = new HashMap<Integer, String>();

    public static String getPreferredJavaType(int sqlType, int size, int decimalDigits) {
        if ((sqlType == 3 || sqlType == 2) && decimalDigits == 0) {
            if (size == 1) {
                return "boolean";
            }
            if (size < 3) {
                return "byte";
            }
            if (size < 5) {
                return "short";
            }
            if (size < 10) {
                return "int";
            }
            if (size < 19) {
                return "long";
            }
            return "java.math.BigDecimal";
        }
        String result = sqlTypeVsJavaType.get(sqlType);
        if (result == null) {
            result = "java.lang.Object";
        }
        return result;
    }

    static {
        sqlTypeVsJavaType.put(-6, "byte");
        sqlTypeVsJavaType.put(5, "short");
        sqlTypeVsJavaType.put(4, "int");
        sqlTypeVsJavaType.put(-5, "long");
        sqlTypeVsJavaType.put(7, "float");
        sqlTypeVsJavaType.put(6, "double");
        sqlTypeVsJavaType.put(8, "double");
        sqlTypeVsJavaType.put(3, "double");
        sqlTypeVsJavaType.put(2, "double");
        sqlTypeVsJavaType.put(-7, "boolean");
        sqlTypeVsJavaType.put(1, "java.lang.String");
        sqlTypeVsJavaType.put(12, "java.lang.String");
        sqlTypeVsJavaType.put(-1, "java.lang.String");
        sqlTypeVsJavaType.put(-2, "byte[]");
        sqlTypeVsJavaType.put(-3, "byte[]");
        sqlTypeVsJavaType.put(-4, "java.io.InputStream");
        sqlTypeVsJavaType.put(91, "java.sql.Date");
        sqlTypeVsJavaType.put(92, "java.sql.Time");
        sqlTypeVsJavaType.put(93, "java.sql.Timestamp");
        sqlTypeVsJavaType.put(2005, "java.sql.Clob");
        sqlTypeVsJavaType.put(2011, "java.sql.NClob");
        sqlTypeVsJavaType.put(2009, "java.sql.SQLXML");
        sqlTypeVsJavaType.put(-8, "java.sql.ROWID");
        sqlTypeVsJavaType.put(-15, "java.lang.String");
        sqlTypeVsJavaType.put(-9, "java.lang.String");
        sqlTypeVsJavaType.put(-16, "java.lang.String");
        sqlTypeVsJavaType.put(2004, "java.sql.Blob");
        sqlTypeVsJavaType.put(2003, "java.sql.Array");
        sqlTypeVsJavaType.put(2000, "java.lang.Object");
    }
}

