/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc.module;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFNumber;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.SOAPFunc;
import coldfusion.server.ConfigMap;
import coldfusion.server.SecurityService;
import coldfusion.server.Service;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.server.XmlRpcService;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.FastHashtable;
import coldfusion.util.Key;
import coldfusion.util.PasswordUtils;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import coldfusion.wddx.Base64Encoder;
import coldfusion.xml.XmlNodeList;
import coldfusion.xml.XmlProcessor;
import coldfusion.xml.rpc.Axis2ServiceProxy;
import coldfusion.xml.rpc.BadWsdlXMLException;
import coldfusion.xml.rpc.CFJcifsNtlmScheme;
import coldfusion.xml.rpc.CFUserCredential;
import coldfusion.xml.rpc.DocumentQueryBean;
import coldfusion.xml.rpc.ResponseHeaders;
import coldfusion.xml.rpc.ServiceInfo;
import coldfusion.xml.rpc.ServiceInfoGeneratorStrategy;
import coldfusion.xml.rpc.ServiceProxy;
import coldfusion.xml.rpc.ServiceProxyContext;
import coldfusion.xml.rpc.ServiceStubGenerationException;
import coldfusion.xml.rpc.module.Axis1ServiceInfoGeneratorStrategy;
import coldfusion.xml.rpc.module.Axis2ServiceInfoGeneratorStrategy;
import coldfusion.xml.rpc.module.CFAxis2Servlet;
import coldfusion.xml.rpc.module.CFAxisServlet;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.stream.XMLStreamException;
import jcifs.Config;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.client.Call;
import org.apache.axis.client.Stub;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.utils.bytecode.ParamReader;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlRpcServiceImpl
extends ServiceBase
implements XmlRpcService,
Observer {
    private static final Key VERSION_KEY = Key.getInstance((String)"version");
    private String seed;
    private static boolean systemProxyIsSet = Utils.checkSystemHTTPProxyIsSet();
    private static Permission[] wsdlFactorySandboxPerms;
    private Permission[] stubDirSandboxPerms;
    private File file;
    private String stubdir;
    String _bClassPath;
    private FastHashtable webservices = new FastHashtable();
    private ConfigMap mappings = null;
    private ConfigMap usernames = null;
    private ConfigMap passwords = null;
    private ConfigMap wsVersion = null;
    private ConfigMap proxyusernames = null;
    private ConfigMap proxypasswords = null;
    private ConfigMap proxyservers = null;
    private ConfigMap proxyports = null;
    private ConfigMap timeouts = null;
    private ConfigMap ntlmdomains = null;
    private ConfigMap workstations = null;
    private ConfigMap authtypes = null;
    private static Class auth_mod;

    public XmlRpcServiceImpl(File f, String stubdir, boolean enableWatch) {
        this.file = f;
        this.stubdir = stubdir;
        this.setEnableWatch(enableWatch);
        if (enableWatch) {
            this.setWatchFile(this.file);
        }
        if (System.getSecurityManager() != null) {
            this.stubDirSandboxPerms = new Permission[]{new FilePermission(stubdir + File.separator + "-", "read,delete")};
        }
    }

    public XmlRpcServiceImpl(File f, String stubdir) {
        this(f, stubdir, true);
    }

    public Map getMappings() {
        return this.mappings;
    }

    public Map getUsernames() {
        return this.usernames;
    }

    public Map getProxyusernames() {
        return this.proxyusernames;
    }

    public Map getProxypasswords() {
        return this.proxypasswords;
    }

    public Map getProxyservers() {
        return this.proxyservers;
    }

    public Map getProxyports() {
        return this.proxyports;
    }

    public Map getPasswords() {
        return this.passwords;
    }

    public Map getTimeouts() {
        return this.timeouts;
    }

    public void setClassPath(String path) {
        this._bClassPath = path;
    }

    public String getClassPath() {
        return this._bClassPath;
    }

    public Map getAuthtypes() {
        return this.authtypes;
    }

    public Map getDomains() {
        return this.ntlmdomains;
    }

    public Map getWorkstations() {
        return this.workstations;
    }

    public synchronized void unregisterWebService(String name) {
        this.mappings.remove((Object)name);
        this.usernames.remove((Object)name);
        this.passwords.remove((Object)name);
        this.webservices.remove((Object)name);
        this.proxypasswords.remove((Object)name);
        this.proxyports.remove((Object)name);
        this.proxyservers.remove((Object)name);
        this.proxyusernames.remove((Object)name);
        this.timeouts.remove((Object)name);
        this.ntlmdomains.remove((Object)name);
        this.workstations.remove((Object)name);
        this.authtypes.remove((Object)name);
        try {
            this.store(name, null, "DELETION");
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException((Throwable)ex);
        }
    }

    public synchronized void refreshWebService(String name) {
        Object workstationObject;
        Object domainObject;
        Object authObject;
        this.webservices.remove((Object)name);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("username", this.usernames.get((Object)name));
        Object enc = this.passwords.get((Object)name);
        if (enc != null) {
            String encPassword = (String)enc;
            config.put("password", this.decryptPassword(encPassword));
        }
        if ((authObject = this.authtypes.get((Object)name)) != null) {
            config.put("authtype", (String)authObject);
        }
        if ((domainObject = this.ntlmdomains.get((Object)name)) != null) {
            config.put("ntlmdomain", (String)domainObject);
        }
        if ((workstationObject = this.workstations.get((Object)name)) != null) {
            config.put("workstation", (String)workstationObject);
        }
        this.getWebServiceProxy(name, config);
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException((Throwable)ex);
        }
    }

    public synchronized void registerWebService(String name, String wsdl, String username, String password) {
        HashMap<String, String> config = new HashMap<String, String>();
        if (username != null && username.length() > 0) {
            config.put("username", username);
            config.put("password", password);
        }
        this.registerWebService(name, wsdl, config);
    }

    public synchronized void registerWebService(final String name, final String wsdl, Map config) {
        String dir_name;
        if (name.startsWith("http://") || name.startsWith("https://")) {
            String serviceName = null;
            if (name.indexOf(".cfc") > -1) {
                serviceName = name.substring(name.lastIndexOf("/") + 1, name.indexOf(".cfc"));
            }
            StringBuilder outDirPath = new StringBuilder("WS_");
            if (null != serviceName) {
                outDirPath.append(serviceName);
                outDirPath.append("_");
            }
            outDirPath.append(name.hashCode());
            dir_name = outDirPath.toString();
        } else {
            dir_name = name;
        }
        String outputdir = this.stubdir + File.separator + dir_name;
        final String username = (String)config.get("username");
        final String password = (String)config.get("password");
        final String proxyServer = (String)config.get("proxyserver");
        Object o = config.get("proxyport");
        final String proxyPort = o != null ? Cast._String(o) : null;
        final String proxyUser = (String)config.get("proxyuser");
        final String proxyPassword = (String)config.get("proxypassword");
        final String authtype = (String)config.get("authtype");
        final String workstation = (String)config.get("workstation");
        final String domain = (String)config.get("ntlmdomain");
        int to = 0;
        o = config.get("timeout");
        if (o != null && !"".equals(o)) {
            to = Cast._int(o);
        }
        final int timeout = to;
        String w2jargs = (String)config.get("wsdl2javaargs");
        ServiceInfo serviceInfo = null;
        try {
            Document wsdlDocument = (Document)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Document wsdlDocument = XmlRpcServiceImpl.this.retrieveWSDL(wsdl, username, password, timeout, proxyServer, proxyPort, proxyUser, proxyPassword, authtype, workstation, domain);
                    return wsdlDocument;
                }
            });
            ServiceInfoGeneratorStrategy generator = this.getServiceInfoGenerator(wsdl, wsdlDocument, this.getPropertyAsBoolean("savejava", config), config);
            outputdir = outputdir + "_" + generator.getVersion();
            this.deleteStubOutputDirectory(outputdir);
            serviceInfo = generator.generateServiceInfo(name, outputdir, username, password, wsdl, wsdlDocument, w2jargs, config);
        }
        catch (PrivilegedActionException ex) {
            CFLogs.WEBSERVICE_LOG.info((Throwable)ex);
            throw new ServiceStubGenerationException(name, wsdl, ex.getException());
        }
        catch (ApplicationException apex) {
            CFLogs.WEBSERVICE_LOG.info((Throwable)apex);
            throw apex;
        }
        catch (Exception ex) {
            CFLogs.WEBSERVICE_LOG.info((Throwable)ex);
            throw new ServiceStubGenerationException(name, wsdl, ex);
        }
        this.webservices.put((Object)serviceInfo.getName(), (Object)serviceInfo);
        Object dontReg = config.get("registerservice");
        if (null != dontReg) {
            this.mappings.put((Object)name, (Object)wsdl);
            this.usernames.put((Object)name, (Object)(username != null ? username : ""));
            this.passwords.put((Object)name, (Object)(password != null ? this.encryptPassword(password) : ""));
            this.proxypasswords.put((Object)name, (Object)(proxyPassword != null ? proxyPassword : ""));
            this.proxyports.put((Object)name, (Object)(proxyPort != null ? proxyPort : ""));
            this.proxyservers.put((Object)name, (Object)(proxyServer != null ? proxyServer : ""));
            this.proxyusernames.put((Object)name, (Object)(proxyUser != null ? proxyUser : ""));
            this.timeouts.put((Object)name, (Object)timeout);
            this.authtypes.put((Object)name, (Object)(authtype != null ? authtype : ""));
            this.ntlmdomains.put((Object)name, (Object)(domain != null ? domain : ""));
            this.workstations.put((Object)name, (Object)(workstation != null ? workstation : ""));
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    XmlRpcServiceImpl.this.store(name, "ADDITION", null);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pex) {
            CFLogs.WEBSERVICE_LOG.info((Throwable)pex);
            throw new ServiceRuntimeException((Throwable)pex.getException());
        }
        catch (Exception ex) {
            CFLogs.WEBSERVICE_LOG.info((Throwable)ex);
            throw new ServiceRuntimeException((Throwable)ex);
        }
    }

    private ServiceInfoGeneratorStrategy getServiceInfoGenerator(String wsdl, Document wsdlDocument, boolean saveJava, Map config) throws WSDLException {
        ServiceProxyContext context = ServiceProxyContext.getInstance();
        String version = context.getVersion();
        if (null != version) {
            context.clear();
            if (version.equals("1")) {
                CFLogs.WEBSERVICE_LOG.info((Object)RB.getString((Object)this, (String)"XmlRpcServiceImpl.usingAxis1", (Object[])new Object[]{wsdl}));
                return new Axis1ServiceInfoGeneratorStrategy(this, saveJava);
            }
            CFLogs.WEBSERVICE_LOG.info((Object)RB.getString((Object)this, (String)"XmlRpcServiceImpl.usingAxis2", (Object[])new Object[]{wsdl}));
            return new Axis2ServiceInfoGeneratorStrategy(this, saveJava);
        }
        Object versionObj = config.get("wsversion");
        if (null == versionObj) {
            Map versionMap;
            Map wssettings;
            Map appSettings;
            ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope((String)FusionContext.getCurrent().getApplicationName());
            if (appScope != null && (appSettings = appScope.getApplicationSettingsMap()) != null && null != (wssettings = (Map)appSettings.get("wssettings")) && null != (versionMap = (Map)wssettings.get("version")) && (versionObj = versionMap.get("consume")) != null) {
                version = Cast._String((int)Cast._int(versionObj, (boolean)false));
            }
        } else {
            version = Cast._String((int)Cast._int(versionObj, (boolean)false));
        }
        if (null != version) {
            this.validateWsVersion(version, wsdl);
            if (version.equals("1")) {
                CFLogs.WEBSERVICE_LOG.info((Object)RB.getString((Object)this, (String)"XmlRpcServiceImpl.usingAxis1", (Object[])new Object[]{wsdl}));
                return new Axis1ServiceInfoGeneratorStrategy(this, saveJava);
            }
            CFLogs.WEBSERVICE_LOG.info((Object)RB.getString((Object)this, (String)"XmlRpcServiceImpl.usingAxis2", (Object[])new Object[]{wsdl}));
            return new Axis2ServiceInfoGeneratorStrategy(this, saveJava);
        }
        if (wsdl.endsWith("wsdl2")) {
            return new Axis2ServiceInfoGeneratorStrategy(this, saveJava);
        }
        boolean isAxis1CommentPresent = false;
        Node definitionNode = wsdlDocument.getChildNodes().item(0);
        if (null != definitionNode) {
            NodeList childNodes = definitionNode.getChildNodes();
            int length = childNodes.getLength();
            for (int i = 0; i < length; ++i) {
                Comment comment;
                String data;
                Node node = childNodes.item(i);
                if (node.getNodeType() != 8 || null == (data = (comment = (Comment)node).getData()) || !data.contains("WSDL created by ColdFusion")) continue;
                isAxis1CommentPresent = true;
                break;
            }
        }
        if (isAxis1CommentPresent) {
            CFLogs.WEBSERVICE_LOG.info((Object)RB.getString((Object)this, (String)"XmlRpcServiceImpl.usingAxis1", (Object[])new Object[]{wsdl}));
            return new Axis1ServiceInfoGeneratorStrategy(this, saveJava);
        }
        String portName = (String)config.get("port");
        Definition definition = this.readWSDL(wsdl, wsdlDocument);
        Map bindings = definition.getBindings();
        Binding binding = null;
        if (portName != null) {
            String bindingName = this.getBindingNameForPort(definition, portName);
            if (null == bindingName) {
                throw new InvalidPortException(portName);
            }
            binding = this.getPortBinding(bindings, bindingName);
        } else {
            binding = this.getAvailablePortBinding(bindings);
        }
        if (this.isAxis2BindingType(binding)) {
            CFLogs.WEBSERVICE_LOG.info((Object)RB.getString((Object)this, (String)"XmlRpcServiceImpl.usingAxis2", (Object[])new Object[]{wsdl}));
            return new Axis2ServiceInfoGeneratorStrategy(this, saveJava);
        }
        CFLogs.WEBSERVICE_LOG.info((Object)RB.getString((Object)this, (String)"XmlRpcServiceImpl.usingAxis1", (Object[])new Object[]{wsdl}));
        return new Axis1ServiceInfoGeneratorStrategy(this, saveJava);
    }

    private Definition readWSDL(final String wsdl, final Document wsdlDocument) throws WSDLException {
        if (System.getSecurityManager() == null) {
            return this._readWSDL(wsdl, wsdlDocument);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Definition>(){

                @Override
                public Definition run() throws Exception {
                    return XmlRpcServiceImpl.this._readWSDL(wsdl, wsdlDocument);
                }
            }, null, wsdlFactorySandboxPerms);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof WSDLException) {
                throw (WSDLException)((Object)e.getException());
            }
            throw new RuntimeException(e.getException());
        }
    }

    private Definition _readWSDL(String wsdl, Document wsdlDocument) throws WSDLException {
        WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        String documentBaseURI = null;
        int lastSlashIndex = wsdl.lastIndexOf("/");
        if (lastSlashIndex != -1) {
            documentBaseURI = wsdl.substring(0, lastSlashIndex + 1);
        }
        return wsdlReader.readWSDL(documentBaseURI, wsdlDocument);
    }

    private void validateWsVersion(String version, String wsdl) {
        if (!"1".equals(version) && !"2".equals(version)) {
            throw new InvalidWebServiceVersionForConsumptionException(version, wsdl);
        }
    }

    private String getBindingNameForPort(Definition definition, String portName) {
        Map services = definition.getServices();
        for (QName serviceName : services.keySet()) {
            javax.wsdl.Service service = (javax.wsdl.Service)services.get(serviceName);
            Port port = service.getPort(portName);
            if (null == port) continue;
            return port.getBinding().getQName().getLocalPart();
        }
        return null;
    }

    private boolean isAxis2BindingType(Binding binding) {
        List bindingExtEls = binding.getExtensibilityElements();
        for (Object extEls : bindingExtEls) {
            if (SOAPBinding.class.isInstance(extEls)) {
                SOAPBinding soapBinding = (SOAPBinding)extEls;
                String style = soapBinding.getStyle();
                if (null == style) {
                    List operations = binding.getBindingOperations();
                    for (Object object : operations) {
                        Object object2;
                        SOAPOperation soapOperation;
                        BindingOperation operation = (BindingOperation)object;
                        List extensibilityElements = operation.getExtensibilityElements();
                        Iterator iterator = extensibilityElements.iterator();
                        while (iterator.hasNext() && null == (style = (soapOperation = (SOAPOperation)(object2 = iterator.next())).getStyle())) {
                        }
                        if (null == style) continue;
                        break;
                    }
                }
                return false == "rpc".equals(style);
            }
            if (SOAP12Binding.class.isInstance(extEls)) {
                SOAP12Binding soapBinding = (SOAP12Binding)extEls;
                String style = soapBinding.getStyle();
                if (null == style) {
                    List operations = binding.getBindingOperations();
                    for (Object object : operations) {
                        Object object2;
                        SOAP12Operation soap12Operation;
                        BindingOperation operation = (BindingOperation)object;
                        List extensibilityElements = operation.getExtensibilityElements();
                        Iterator iterator = extensibilityElements.iterator();
                        while (iterator.hasNext() && null == (style = (soap12Operation = (SOAP12Operation)(object2 = iterator.next())).getStyle())) {
                        }
                        if (null == style) continue;
                        break;
                    }
                }
                return false == "rpc".equals(style);
            }
            if (!HTTPBinding.class.isInstance(extEls)) continue;
            return true;
        }
        return false;
    }

    private Binding getAvailablePortBinding(Map bindings) {
        QName key;
        Binding binding = null;
        Iterator iterator = bindings.keySet().iterator();
        while (iterator.hasNext() && null == (binding = (Binding)bindings.get(key = (QName)iterator.next()))) {
        }
        if (null == binding) {
            throw new NoPortException();
        }
        return binding;
    }

    private Binding getPortBinding(Map bindings, String bindingName) {
        for (QName key : bindings.keySet()) {
            if (!key.getLocalPart().equals(bindingName)) continue;
            return (Binding)bindings.get(key);
        }
        throw new InvalidPortException(bindingName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceProxy getWebServiceProxy(String name, Map config) {
        int timeout;
        String workstation;
        String domain;
        String authtype;
        String proxypassword;
        String proxyusername;
        String proxyport;
        String proxyserver;
        ServiceInfo serviceInfo;
        String password;
        String username;
        String wsdl;
        String port = (String)config.get("port");
        XmlRpcServiceImpl xmlRpcServiceImpl = this;
        synchronized (xmlRpcServiceImpl) {
            wsdl = (String)this.mappings.get((Object)name);
            username = (String)this.usernames.get((Object)name);
            password = this.decryptPassword((String)this.passwords.get((Object)name));
            serviceInfo = (ServiceInfo)this.webservices.get((Object)name);
            proxyserver = (String)this.proxyservers.get((Object)name);
            proxyport = (String)this.proxyports.get((Object)name);
            proxyusername = (String)this.proxyusernames.get((Object)name);
            proxypassword = (String)this.proxypasswords.get((Object)name);
            authtype = (String)this.authtypes.get((Object)name);
            domain = (String)this.ntlmdomains.get((Object)name);
            workstation = (String)this.workstations.get((Object)name);
        }
        String localUserName = (String)config.get("username");
        if (localUserName != null && localUserName.length() > 0) {
            username = localUserName;
            password = (String)config.get("password");
        } else {
            config.put("username", username);
            config.put("password", password);
        }
        String localProxyServer = (String)config.get("proxyserver");
        if (localProxyServer != null && localProxyServer.length() > 0) {
            proxyserver = localProxyServer;
            proxyusername = (String)config.get("proxyuser");
            proxypassword = (String)config.get("proxypassword");
            proxyport = (String)config.get("proxyport");
        } else {
            config.put("proxyuser", proxyusername);
            config.put("proxypassword", proxypassword);
            config.put("proxyserver", proxyserver);
            config.put("proxyport", proxyport);
        }
        String localDomain = (String)config.get("ntlmdomain");
        if (localDomain != null && localDomain.length() > 0) {
            domain = localDomain;
            workstation = (String)config.get("workstation");
        } else {
            config.put("ntlmdomain", domain);
            config.put("workstation", workstation);
        }
        String localauthType = (String)config.get("authtype");
        if (localauthType != null && localauthType.length() > 0) {
            authtype = localauthType;
        } else {
            config.put("authtype", authtype);
        }
        boolean refresh = this.getPropertyAsBoolean("refreshwsdl", config);
        if (refresh) {
            serviceInfo = null;
            config.remove("refreshwsdl");
        }
        if (serviceInfo == null) {
            if (wsdl == null) {
                wsdl = name;
            }
            this.registerWebService(name, wsdl, config);
        }
        ServiceInfo si = (ServiceInfo)this.webservices.get((Object)name);
        CFUserCredential cfUserCredential = new CFUserCredential(username, password, authtype, domain, workstation);
        ServiceProxy serviceProxy = si.getServiceProxy(port, cfUserCredential);
        if (proxyserver != null) {
            serviceProxy.setProxyServer(proxyserver);
            serviceProxy.setProxyPort(proxyport);
            if (proxyusername != null) {
                serviceProxy.setProxyUser(proxyusername);
                serviceProxy.setProxyPassword(proxypassword);
            }
        }
        int to = 0;
        Object o = config.get("timeout");
        if (o != null && !"".equals(o)) {
            to = Cast._int(o);
        }
        if ((timeout = to) != 0) {
            serviceProxy.setTimeout(timeout);
        }
        return serviceProxy;
    }

    public void start() throws ServiceException {
        super.start();
        PasswordUtils.getInstance().addObserver((Observer)this);
        Config.setProperty((String)"jcifs.encoding", (String)"ASCII");
        AuthPolicy.registerAuthScheme((String)"NTLM", CFJcifsNtlmScheme.class);
    }

    public void load() throws ServiceException {
        try {
            Vector v = (Vector)this.deserialize(this.file);
            int pos = 0;
            this.mappings = (ConfigMap)v.elementAt(pos++);
            this.mappings.init((Service)this, "mappings");
            this.usernames = (ConfigMap)v.elementAt(pos++);
            this.usernames.init((Service)this, "usernames");
            this.passwords = (ConfigMap)v.elementAt(pos++);
            this.passwords.init((Service)this, "passwords");
            this.proxyservers = (ConfigMap)v.elementAt(pos++);
            this.proxyservers.init((Service)this, "proxyservers");
            this.proxyports = (ConfigMap)v.elementAt(pos++);
            this.proxyports.init((Service)this, "proxyports");
            this.proxyusernames = (ConfigMap)v.elementAt(pos++);
            this.proxyusernames.init((Service)this, "proxyusernames");
            this.proxypasswords = (ConfigMap)v.elementAt(pos++);
            this.proxypasswords.init((Service)this, "proxypasswords");
            this.timeouts = (ConfigMap)v.elementAt(pos++);
            this.timeouts.init((Service)this, "timeouts");
            if (v.size() >= 9) {
                this.wsVersion = (ConfigMap)v.elementAt(pos++);
                this.wsVersion.init((Service)this, "wsVersion");
            }
            if (v.size() >= 10) {
                this.authtypes = (ConfigMap)v.elementAt(pos++);
                this.authtypes.init((Service)this, "authtypes");
                this.ntlmdomains = (ConfigMap)v.elementAt(pos++);
                this.ntlmdomains.init((Service)this, "ntlmdomains");
                this.workstations = (ConfigMap)v.elementAt(pos++);
                this.workstations.init((Service)this, "workstations");
            } else {
                this.authtypes = new ConfigMap();
                this.authtypes.init((Service)this, "authtypes");
                this.ntlmdomains = new ConfigMap();
                this.ntlmdomains.init((Service)this, "ntlmdomains");
                this.workstations = new ConfigMap();
                this.workstations.init((Service)this, "workstations");
            }
            new File(this.stubdir).mkdirs();
        }
        catch (Exception ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    public void store() throws ServiceException {
        this.store(null, null, null);
    }

    public void store(Object key, Object value, Object oldValue) throws ServiceException {
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        v.addElement(this.mappings);
        v.addElement(this.usernames);
        v.addElement(this.passwords);
        v.addElement(this.proxyservers);
        v.addElement(this.proxyports);
        v.addElement(this.proxyusernames);
        v.addElement(this.proxypasswords);
        v.addElement(this.timeouts);
        this.initializeEngineVersionIfNull();
        v.addElement(this.wsVersion);
        v.add(this.authtypes);
        v.add(this.ntlmdomains);
        v.add(this.workstations);
        this.serialize(v, this.file, true, key, value, oldValue);
    }

    private boolean getPropertyAsBoolean(String prop, Map config) {
        boolean value = false;
        Object v = config.get(prop);
        if (v != null) {
            try {
                value = Cast._boolean(v);
            }
            catch (Cast.BooleanConversionException booleanConversionException) {
                // empty catch block
            }
        }
        return value;
    }

    private Document retrieveWSDL(String wsdl, String username, String password, int timeout, String proxyServer, String proxyPort, String proxyUser, String proxyPassword, String authType, String workstation, String domain) throws CantFindWSDLException, BadWsdlXMLException {
        try {
            boolean isProxySpecified;
            URL u = new URL(wsdl);
            RequestConfig.Builder requestBuilder = RequestConfig.custom();
            requestBuilder.setCookieSpec("ignoreCookies");
            HttpGet httpget = new HttpGet(u.toString());
            boolean ntlmAuth = this.isNTLMAuth(authType);
            if (!ntlmAuth) {
                httpget.addHeader("Connection", "close");
            } else {
                requestBuilder.setTargetPreferredAuthSchemes(Arrays.asList("NTLM"));
            }
            httpget.addHeader("Accept-Encoding", "gzip, deflate;q=0");
            httpget.addHeader("TE", "deflate;q=0");
            requestBuilder.setSocketTimeout(timeout * 1000);
            String auth = null;
            if (u.getUserInfo() != null) {
                auth = u.getUserInfo();
            } else if (username != null && username.length() > 0) {
                String string = auth = password == null ? username : username + ":" + password;
            }
            if (auth != null && !ntlmAuth) {
                httpget.addHeader("Authorization", "Basic " + Base64Encoder.encode((byte[])auth.getBytes("ISO-8859-1")));
            }
            boolean bl = isProxySpecified = StringUtils.isNotBlank((CharSequence)proxyServer) && StringUtils.isNotBlank((CharSequence)proxyPort);
            if (isProxySpecified) {
                int pport = Integer.parseInt(proxyPort);
                requestBuilder.setProxy(new HttpHost(proxyServer, pport));
            }
            if (isProxySpecified || systemProxyIsSet) {
                if (StringUtils.isBlank((CharSequence)proxyUser)) {
                    proxyUser = System.getProperty("http.proxyUser");
                    proxyPassword = System.getProperty("http.proxyPassword");
                }
                if (StringUtils.isNotBlank((CharSequence)proxyUser) && StringUtils.isNotBlank((CharSequence)proxyPassword)) {
                    httpget.addHeader("Proxy-Authorization", "Basic " + Base64Encoder.encode((byte[])(proxyUser + ":" + proxyPassword).getBytes("ISO-8859-1")));
                }
            }
            HttpClientContext context = null;
            if (ntlmAuth) {
                NTCredentials creds = new NTCredentials(username, password, workstation, domain);
                context = HttpClientContext.create();
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(AuthScope.ANY, (Credentials)creds);
                context.setCredentialsProvider((CredentialsProvider)credsProvider);
            }
            if (!(proxyServer == null || proxyServer.isEmpty() || proxyUser == null || proxyUser.isEmpty() || proxyPassword == null || proxyPassword.isEmpty())) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
                context = HttpClientContext.create();
                context.setCredentialsProvider((CredentialsProvider)credsProvider);
            }
            HttpResponse response = null;
            Document doc = null;
            try {
                Header ceheader;
                HttpClientBuilder clientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestBuilder.build()).useSystemProperties();
                CloseableHttpClient httpClient = clientBuilder.build();
                response = httpClient.execute((HttpUriRequest)httpget, (HttpContext)context);
                int code = response.getStatusLine().getStatusCode();
                if (code < 200 || code > 299) {
                    throw new CantFindWSDLException(wsdl, code + " " + response.getStatusLine().getReasonPhrase());
                }
                HttpEntity entity = response.getEntity();
                if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                    HeaderElement[] codecs = ceheader.getElements();
                    for (int i = 0; i < codecs.length; ++i) {
                        if (codecs[i].getName().equalsIgnoreCase("gzip")) {
                            response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                        }
                        if (!codecs[i].getName().equalsIgnoreCase("deflate")) continue;
                        response.setEntity((HttpEntity)new DeflateDecompressingEntity(response.getEntity()));
                    }
                }
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setIgnoringComments(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                doc = builder.parse(new InputSource(response.getEntity().getContent()));
            }
            catch (SAXException ex) {
                throw new BadWsdlXMLException((Exception)ex);
            }
            finally {
                if (response != null) {
                    try {
                        response.getEntity().getContent().close();
                    }
                    catch (Exception exception) {}
                }
            }
            CFLogs.WEBSERVICE_LOG.info((Object)("Downloaded the wsdl " + wsdl));
            return doc;
        }
        catch (ApplicationException appex) {
            throw appex;
        }
        catch (Exception e) {
            throw new CantFindWSDLException(wsdl, e.toString());
        }
    }

    private boolean isNTLMAuth(String authType) {
        return authType != null && authType.equalsIgnoreCase("NTLM");
    }

    private void deleteStubOutputDirectory(final String outputdir) {
        if (System.getSecurityManager() == null) {
            this._deleteStubOutputDirectory(outputdir);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    XmlRpcServiceImpl.this._deleteStubOutputDirectory(outputdir);
                    return null;
                }
            }, null, this.stubDirSandboxPerms);
        }
    }

    private void _deleteStubOutputDirectory(String outputdir) {
        File outDir = new File(outputdir);
        if (outDir.exists()) {
            try {
                FileUtils.deleteDirectory((String)outputdir, (boolean)true);
            }
            catch (Exception e) {
                CFLogs.WEBSERVICE_LOG.warn((Object)RB.getString((Object)this, (String)"XmlRpcServiceImpl.cannotDeleteStubDir", (Object[])new Object[]{outputdir}), (Throwable)e);
            }
        }
    }

    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("mappings.keys", "");
            this.rb.put("mappings.types", "java.lang.String");
            this.rb.put("mappings.formats", "coldfusion.server.StringFormatter");
            this.rb.put("usernames.keys", "");
            this.rb.put("usernames.types", "java.lang.String");
            this.rb.put("usernames.formats", "coldfusion.server.StringFormatter");
            this.rb.put("passwords.keys", "");
            this.rb.put("passwords.types", "java.lang.String");
            this.rb.put("passwords.formats", "coldfusion.server.StringFormatter");
        }
        return this.rb;
    }

    public String getWSEngineVersion() {
        this.initializeEngineVersionIfNull();
        return (String)this.wsVersion.get(VERSION_KEY);
    }

    public void setWSEngineVersion(String version) {
        String oldVersion = this.getWSEngineVersion();
        if (null == this.wsVersion) {
            this.wsVersion = new ConfigMap();
        }
        this.wsVersion.put(VERSION_KEY, (Object)version);
        try {
            this.store(VERSION_KEY, version, oldVersion);
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException((Throwable)ex);
        }
    }

    private void initializeEngineVersionIfNull() {
        if (null == this.wsVersion) {
            this.wsVersion = new ConfigMap();
            this.wsVersion.put(VERSION_KEY, (Object)"2");
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
            this.reEncryptPassword(oldSeed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reEncryptPassword(String oldSeed) {
        if (oldSeed.equalsIgnoreCase(this.seed)) {
            return;
        }
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        if (this.passwords != null) {
            ConfigMap configMap = this.passwords;
            synchronized (configMap) {
                String oldPassword = "";
                String newPassword = "";
                for (String key : this.passwords.keySet()) {
                    oldPassword = (String)this.passwords.get((Object)key);
                    if (oldPassword == null || oldPassword.length() <= 0) continue;
                    try {
                        newPassword = PasswordUtils.reEncryptWithNewSeed((String)oldPassword, (String)oldSeed, (String)this.seed);
                    }
                    catch (Exception e) {
                        CFLogs.SERVER_LOG.error((Throwable)e);
                    }
                    this.passwords.put((Object)key, (Object)newPassword);
                }
                this.storeAction();
            }
        }
    }

    private void storeAction() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    XmlRpcServiceImpl.this.store();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pex) {
            throw new ServiceRuntimeException((Throwable)pex.getException());
        }
        catch (Exception ex) {
            throw new ServiceRuntimeException((Throwable)ex);
        }
    }

    public synchronized void registerWebService(String name, String wsdl, Map<String, String> config, boolean isEncrypted) {
        if (isEncrypted) {
            config.put("password", this.decryptPassword(config.get("password")));
        }
        this.registerWebService(name, wsdl, config);
    }

    public synchronized void registerWebServiceForMigration(Map webService, String oldSeed, String oldAlgoValue, int majorVersion, int minorVersion) {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        if (majorVersion >= 9 && oldSeed != null && !oldSeed.equalsIgnoreCase(this.seed)) {
            webService.put("password", PasswordUtils.decryptPassword((String)webService.get("password").toString(), (String)oldSeed, (String)oldAlgoValue));
        }
        this.registerWebService(webService.get("name").toString(), webService.get("url").toString(), webService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reEncryptPasswordForArchive(Map passwords, String oldSeed, String oldAlgoValue, int majorVersion, int minorVersion) {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        if (passwords != null) {
            Map map = passwords;
            synchronized (map) {
                String oldPassword = "";
                String newPassword = "";
                for (String key : passwords.keySet()) {
                    oldPassword = (String)passwords.get(key);
                    if (oldPassword == null || oldPassword.length() <= 0) continue;
                    if (!PasswordUtils.isAESS((int)majorVersion, (int)minorVersion)) {
                        newPassword = this.encryptPassword(oldPassword);
                    } else {
                        try {
                            newPassword = PasswordUtils.reEncryptWithNewSeed((String)oldPassword, (String)oldSeed, (String)this.seed, (String)oldAlgoValue, (int)majorVersion, (int)minorVersion);
                        }
                        catch (Exception e) {
                            CFLogs.SERVER_LOG.error((Throwable)e);
                        }
                    }
                    passwords.put(key, newPassword);
                }
                this.storeAction();
            }
        }
    }

    private String encryptPassword(String p) {
        return PasswordUtils.encryptPassword((String)p, (String)this.seed);
    }

    private String decryptPassword(String password) {
        return PasswordUtils.decryptPassword((String)password, (String)this.seed);
    }

    public boolean isRefreshWS(String wsdl, String username, String password) {
        boolean refreshWS = false;
        if (wsdl != null) {
            String xmlrpcUser = (String)this.usernames.get((Object)wsdl);
            String xmlrpcPwd = this.decryptPassword((String)this.passwords.get((Object)wsdl));
            if (username != null && xmlrpcUser != null && !xmlrpcUser.equals(username) || password != null && xmlrpcPwd != null && !xmlrpcPwd.equals(password)) {
                refreshWS = true;
            }
        }
        return refreshWS;
    }

    public void initDocumentQueryBean(Object typeDesc) {
        typeDesc = new TypeDesc(DocumentQueryBean.class, true);
        ((TypeDesc)typeDesc).setXmlType(new QName("http://rpc.xml.coldfusion", "DocumentQueryBean"));
        ElementDesc elemField = new ElementDesc();
        elemField.setFieldName("columnList");
        elemField.setXmlName(new QName("http://rpc.xml.coldfusion", "columnList"));
        elemField.setXmlType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new QName("http://rpc.xml.coldfusion", "item"));
        ((TypeDesc)typeDesc).addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("data");
        elemField.setXmlName(new QName("http://rpc.xml.coldfusion", "data"));
        elemField.setXmlType(new QName("http://rpc.xml.coldfusion", "ArrayOf_xsd_anyType"));
        elemField.setNillable(true);
        elemField.setItemQName(new QName("http://rpc.xml.coldfusion", "item"));
        ((TypeDesc)typeDesc).addFieldDesc((FieldDesc)elemField);
    }

    public void setUserNameAndPassword(Object service, String username, String password) {
        ((Stub)service).setUsername(username);
        ((Stub)service).setPassword(password);
    }

    public void setProxyAuthentication(Object service, String proxyServer, String proxyPort, String proxyUser, String proxyPassword) {
        ((Stub)service)._setProperty("coldfusion.proxyHost", (Object)proxyServer);
        ((Stub)service)._setProperty("coldfusion.proxyPort", (Object)proxyPort);
        if (proxyUser != null && proxyUser.length() > 0) {
            ((Stub)service)._setProperty("coldfusion.proxyUser", (Object)proxyUser);
            ((Stub)service)._setProperty("coldfusion.proxyPassword", (Object)proxyPassword);
        }
    }

    public void clearProxyAuthentication(Object service) {
        ((Stub)service).removeProperty("coldfusion.proxyHost");
        ((Stub)service).removeProperty("coldfusion.proxyPort");
        ((Stub)service).removeProperty("coldfusion.proxyUser");
        ((Stub)service).removeProperty("coldfusion.proxyPassword");
    }

    public void setTimeOut(Object service, long timeout) {
        ((Stub)service).setTimeout((int)timeout);
    }

    public void addSOAPRequestHeader(Object stubo, String headerNamespace, String headerName, Object headerValue, boolean mustUnderstand) throws Exception {
        Stub webservice = (Stub)stubo;
        if (headerValue instanceof XmlNodeList) {
            Node n = ((XmlNodeList)headerValue).getFirstNode();
            if (n instanceof Document) {
                n = ((Document)n).getDocumentElement();
            }
            if (!(n instanceof Element)) {
                throw new SOAPFunc.XmlNotAnElementException();
            }
            SOAPHeaderElement headerElement = new SOAPHeaderElement((Element)n);
            headerElement.setMustUnderstand(mustUnderstand);
            webservice.setHeader(headerElement);
        } else if (!mustUnderstand) {
            webservice.setHeader(headerNamespace, headerName, headerValue);
        } else {
            SOAPHeaderElement headerElement = new SOAPHeaderElement(headerNamespace, headerName, headerValue);
            headerElement.setMustUnderstand(mustUnderstand);
            webservice.setHeader(headerElement);
        }
    }

    public XmlNodeList _getSOAPRequestUsingProxy(Object stubo) {
        try {
            Stub stub = (Stub)stubo;
            Call lastCall = stub._getCall();
            if (lastCall == null) {
                throw new SOAPFunc.UnableToGetXMLException("Web service object has not been initialized");
            }
            org.apache.axis.MessageContext ctx = lastCall.getMessageContext();
            SOAPEnvelope env = ctx.getRequestMessage().getSOAPEnvelope();
            Document doc = env.getAsDocument();
            XmlNodeList ret = new XmlNodeList(doc, true);
            return ret;
        }
        catch (AxisFault axisFault) {
            throw new SOAPFunc.NoEnvelopeException(axisFault.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new SOAPFunc.UnableToGetXMLException(e.toString());
        }
    }

    public XmlNodeList _getSOAPResponse(Object stubo) throws ExpressionException {
        try {
            Stub stub = (Stub)stubo;
            Call lastCall = stub._getCall();
            if (lastCall == null) {
                throw new SOAPFunc.UnableToGetXMLException("Web service object has not been initialized");
            }
            SOAPEnvelope env = lastCall.getResponseMessage().getSOAPEnvelope();
            Document doc = env.getAsDocument();
            XmlNodeList ret = new XmlNodeList(doc, true);
            return ret;
        }
        catch (AxisFault axisFault) {
            throw new SOAPFunc.NoEnvelopeException(axisFault.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new SOAPFunc.UnableToGetXMLException(e.toString());
        }
    }

    public Object getSOAPResponseHeader(Object stubo, String headerNamespace, String headerName, boolean asXML) {
        Object value;
        Stub webservice = (Stub)stubo;
        SOAPHeaderElement soapHeaderElement = webservice.getResponseHeader(headerNamespace, headerName);
        if (soapHeaderElement == null) {
            return "";
        }
        if (asXML) {
            String HeaderXMLString = soapHeaderElement.toString();
            value = XmlProcessor.parse((String)HeaderXMLString, (boolean)true);
        } else {
            value = soapHeaderElement.getObjectValue();
            if (value == null) {
                try {
                    value = soapHeaderElement.getObjectValue(String.class);
                }
                catch (Exception e) {
                    throw new SOAPFunc.UnableToGetHeaderException(headerNamespace, headerName, e.getLocalizedMessage());
                }
            }
        }
        return value;
    }

    public Object getSOAPRequestHeader(String headerNamespace, String headerName, boolean asXML) {
        Object value;
        SOAPHeaderElement soapHeaderElement;
        org.apache.axis.MessageContext ctx = org.apache.axis.MessageContext.getCurrentContext();
        if (ctx == null) {
            throw new SOAPFunc.NotInSOAPModeException("getSOAPRequestHeader");
        }
        try {
            SOAPEnvelope env = ctx.getRequestMessage().getSOAPEnvelope();
            soapHeaderElement = env.getHeaderByName(headerNamespace, headerName);
        }
        catch (AxisFault axisFault) {
            throw new SOAPFunc.NoEnvelopeException(axisFault.getLocalizedMessage());
        }
        if (soapHeaderElement == null) {
            return "";
        }
        if (asXML) {
            String HeaderXMLString = soapHeaderElement.toString();
            value = XmlProcessor.parse((String)HeaderXMLString, (boolean)true);
        } else {
            value = soapHeaderElement.getObjectValue();
            if (value == null) {
                try {
                    value = soapHeaderElement.getObjectValue(String.class);
                }
                catch (Exception e) {
                    throw new SOAPFunc.UnableToGetHeaderException(headerNamespace, headerName, e.toString());
                }
            }
        }
        return value;
    }

    public boolean addSOAPResponseHeader(String headerNamespace, String headerName, Object headerValue, boolean mustUnderstand) {
        SOAPEnvelope env;
        org.apache.axis.MessageContext ctx = org.apache.axis.MessageContext.getCurrentContext();
        if (ctx == null) {
            throw new SOAPFunc.NotInSOAPModeException("addSOAPResponseHeader");
        }
        try {
            env = ctx.getResponseMessage().getSOAPEnvelope();
        }
        catch (AxisFault axisFault) {
            throw new SOAPFunc.NoEnvelopeException(axisFault.getLocalizedMessage());
        }
        try {
            if (headerValue instanceof XmlNodeList) {
                Node n = ((XmlNodeList)headerValue).getFirstNode();
                if (n instanceof Document) {
                    n = ((Document)n).getDocumentElement();
                }
                if (!(n instanceof Element)) {
                    throw new SOAPFunc.XmlNotAnElementException();
                }
                SOAPHeaderElement headerElement = new SOAPHeaderElement((Element)n);
                headerElement.setMustUnderstand(mustUnderstand);
                env.addHeader(headerElement);
            } else {
                SOAPHeaderElement headerElement = new SOAPHeaderElement(headerNamespace, headerName, headerValue);
                headerElement.setMustUnderstand(mustUnderstand);
                env.addHeader(headerElement);
            }
            return true;
        }
        catch (Exception e) {
            throw new SOAPFunc.UnknownErrorException(e.toString());
        }
    }

    public boolean _isSOAPRequest() {
        org.apache.axis.MessageContext ctx = org.apache.axis.MessageContext.getCurrentContext();
        return ctx != null && !ctx.isClient();
    }

    public XmlNodeList _getSOAPRequest() {
        try {
            org.apache.axis.MessageContext ctx = org.apache.axis.MessageContext.getCurrentContext();
            if (ctx == null) {
                throw new SOAPFunc.NotInSOAPModeException("getSOAPRequest");
            }
            SOAPEnvelope env = ctx.getRequestMessage().getSOAPEnvelope();
            Document doc = env.getAsDocument();
            XmlNodeList ret = new XmlNodeList(doc, true);
            return ret;
        }
        catch (AxisFault axisFault) {
            throw new SOAPFunc.NoEnvelopeException(axisFault.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new SOAPFunc.UnableToGetXMLException(e.toString());
        }
    }

    public void logInfoMessage(Object stubo) {
        if (CFLogs.WEBSERVICE_LOG.isLoggingEnabled()) {
            try {
                Stub stub = (Stub)stubo;
                Object endPointAddress = stub._getProperty("javax.xml.rpc.service.endpoint.address");
                CFLogs.WEBSERVICE_LOG.info((Object)RB.getString((Object)this, (String)"Axis1ServiceProxy.usingAxis1", (Object)endPointAddress));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean isInstanceOfXmlRpcService(Object obj) {
        return obj != null && obj instanceof XmlRpcServiceImpl;
    }

    public void setUserNameAndPassword2(Object service, String username, String password) {
        HttpTransportProperties.Authenticator auth = new HttpTransportProperties.Authenticator();
        auth.setUsername(username);
        auth.setPassword(password);
        Options options = ((org.apache.axis2.client.Stub)service)._getServiceClient().getOptions();
        options.setProperty("__CHUNKED__", (Object)false);
        options.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)auth);
    }

    public void setTimeOut2(Object service, long timeout) {
        Options options = ((org.apache.axis2.client.Stub)service)._getServiceClient().getOptions();
        options.setTimeOutInMilliSeconds(timeout);
    }

    public void clearProxyAuthentication2(Object service) {
        Options options = ((org.apache.axis2.client.Stub)service)._getServiceClient().getOptions();
        options.getProperties().remove("PROXY");
    }

    public void setProxyAuthentication2(Object service, String proxyServer, String proxyPort, String proxyUser, String proxyPassword) {
        HttpTransportProperties.ProxyProperties properties = new HttpTransportProperties.ProxyProperties();
        properties.setProxyName(proxyServer);
        properties.setProxyPort(Integer.parseInt(proxyPort));
        if (proxyUser != null && proxyUser.length() > 0) {
            properties.setUserName(proxyUser);
            properties.setPassWord(proxyPassword);
        }
        Options options = ((org.apache.axis2.client.Stub)service)._getServiceClient().getOptions();
        options.setProperty("PROXY", (Object)properties);
    }

    public void addSOAPRequestHeader2(Object stubo, String headerNamespace, String headerName, Object headerValue, boolean mustUnderstand) throws Exception {
        org.apache.axis2.client.Stub webservice = (org.apache.axis2.client.Stub)stubo;
        if (headerValue instanceof XmlNodeList) {
            Node n = ((XmlNodeList)headerValue).getFirstNode();
            if (n instanceof Document) {
                n = ((Document)n).getDocumentElement();
            }
            if (!(n instanceof Element)) {
                throw new SOAPFunc.XmlNotAnElementException();
            }
            OMElement om = XMLUtils.toOM((Element)((Element)n));
            webservice._getServiceClient().addHeader(om);
        } else if (!mustUnderstand) {
            webservice._getServiceClient().addStringHeader(new QName(headerNamespace, headerName), (String)headerValue);
        } else {
            webservice._getServiceClient().addStringHeader(new QName(headerNamespace, headerName), (String)headerValue);
            String soapVersionURI = webservice._getServiceClient().getOptions().getSoapVersionURI();
            SOAPFactory soapFactory = "http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI) ? OMAbstractFactory.getSOAP12Factory() : OMAbstractFactory.getSOAP11Factory();
            OMNamespace omNamespace = soapFactory.createOMNamespace(headerNamespace, null);
            SOAPHeaderBlock soapHeaderBlock = soapFactory.createSOAPHeaderBlock(headerName, omNamespace);
            soapHeaderBlock.setMustUnderstand(true);
            soapHeaderBlock.setText(String.valueOf(headerValue));
            webservice._getServiceClient().addHeader(soapHeaderBlock);
        }
    }

    public XmlNodeList _getSOAPRequestUsingProxy2(Object stubo) {
        try {
            org.apache.axis2.client.Stub stub = (org.apache.axis2.client.Stub)stubo;
            OperationContext lastOperationContext = stub._getServiceClient().getLastOperationContext();
            if (null == lastOperationContext) {
                throw new SOAPFunc.UnableToGetXMLException("Web service object has not been initialized");
            }
            MessageContext messageContext = lastOperationContext.getMessageContext("Out");
            org.apache.axiom.soap.SOAPEnvelope envelope = messageContext.getEnvelope();
            Document dom = XmlRpcServiceImpl.convertToDOM((OMElement)envelope);
            XmlNodeList ret = new XmlNodeList(dom, true);
            return ret;
        }
        catch (AxisFault axisFault) {
            throw new SOAPFunc.NoEnvelopeException(axisFault.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new SOAPFunc.UnableToGetXMLException(e.toString());
        }
    }

    private static Document convertToDOM(OMElement element) throws SAXException, IOException, ParserConfigurationException {
        StringWriter stringWriter = new StringWriter();
        try {
            element.serializeAndConsume((Writer)stringWriter);
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        String response = stringWriter.toString();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document dom = factory.newDocumentBuilder().parse(new InputSource(new StringReader(response)));
        return dom;
    }

    public Object getSOAPResponseHeader2(Object stubo, String headerNamespace, String headerName, boolean asXML) {
        String value = null;
        try {
            org.apache.axis2.client.Stub stub = (org.apache.axis2.client.Stub)stubo;
            MessageContext messageContext = stub._getServiceClient().getLastOperationContext().getMessageContext("In");
            org.apache.axiom.soap.SOAPEnvelope envelope = messageContext.getEnvelope();
            SOAPHeader header = envelope.getHeader();
            if (null != header) {
                Iterator allHeaderBlocks = header.examineAllHeaderBlocks();
                while (allHeaderBlocks.hasNext()) {
                    SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)allHeaderBlocks.next();
                    if (!headerNamespace.equals(headerBlock.getNamespace().getNamespaceURI()) || !headerName.equals(headerBlock.getLocalName())) continue;
                    if (asXML) {
                        Element dom = XMLUtils.toDOM((OMElement)headerBlock);
                        value = new XmlNodeList((Node)dom, true);
                        continue;
                    }
                    value = headerBlock.getText();
                }
            }
        }
        catch (Exception e) {
            throw new SOAPFunc.UnableToGetHeaderException(headerNamespace, headerName, e.getLocalizedMessage());
        }
        if (null == value) {
            throw new SOAPFunc.UnableToGetHeaderException(headerNamespace, headerName, RB.getString((Object)this, (String)"Axis2ServiceProxy.couldNotFindHeader"));
        }
        return value;
    }

    public Object getSOAPRequestHeader2(String headerNamespace, String headerName, boolean asXML) {
        String value = null;
        MessageContext currentMessageContext = MessageContext.getCurrentMessageContext();
        if (currentMessageContext == null) {
            throw new SOAPFunc.NotInSOAPModeException("getSOAPRequestHeader");
        }
        try {
            MessageContext messageContext = currentMessageContext.getOperationContext().getMessageContext("In");
            org.apache.axiom.soap.SOAPEnvelope envelope = messageContext.getEnvelope();
            SOAPHeader header = envelope.getHeader();
            if (null != header) {
                Iterator allHeaderBlocks = header.examineAllHeaderBlocks();
                while (allHeaderBlocks.hasNext()) {
                    SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)allHeaderBlocks.next();
                    if (!headerNamespace.equals(headerBlock.getNamespace().getNamespaceURI()) || !headerName.equals(headerBlock.getLocalName())) continue;
                    if (asXML) {
                        Element dom = XMLUtils.toDOM((OMElement)headerBlock);
                        value = new XmlNodeList((Node)dom, true);
                        continue;
                    }
                    value = headerBlock.getText();
                }
            }
        }
        catch (AxisFault axisFault) {
            throw new SOAPFunc.NoEnvelopeException(axisFault.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new SOAPFunc.UnableToGetHeaderException(headerNamespace, headerName, e.toString());
        }
        if (null == value) {
            throw new SOAPFunc.UnableToGetHeaderException(headerNamespace, headerName, RB.getString(Axis2ServiceProxy.class, (String)"Axis2ServiceProxy.couldNotFindHeader"));
        }
        return value;
    }

    public boolean addSOAPResponseHeader2(String headerNamespace, String headerName, Object headerValue, boolean mustUnderstand) {
        MessageContext currentMessageContext = MessageContext.getCurrentMessageContext();
        if (currentMessageContext == null) {
            throw new SOAPFunc.NotInSOAPModeException("getSOAPRequestHeader");
        }
        ResponseHeaders.getInstance().addResponseHeader(headerNamespace, headerName, headerValue, mustUnderstand);
        return true;
    }

    public boolean _isSOAPRequest2() {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        return null != messageContext && messageContext.isServerSide();
    }

    public XmlNodeList _getSOAPRequest2() {
        try {
            MessageContext currentMessageContext = MessageContext.getCurrentMessageContext();
            if (currentMessageContext == null) {
                throw new SOAPFunc.NotInSOAPModeException("getSOAPRequestHeader");
            }
            MessageContext messageContext = currentMessageContext.getOperationContext().getMessageContext("In");
            org.apache.axiom.soap.SOAPEnvelope envelope = messageContext.getEnvelope();
            Document dom = XmlRpcServiceImpl.convertToDOM((OMElement)envelope);
            XmlNodeList ret = new XmlNodeList(dom, true);
            return ret;
        }
        catch (AxisFault axisFault) {
            throw new SOAPFunc.NoEnvelopeException(axisFault.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new SOAPFunc.UnableToGetXMLException(e.toString());
        }
    }

    public Object convertXml2(Object obj, Class target_type, Class stubClazz) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        if (Object.class.getName().equals(target_type.getName()) || XmlNodeList.class.getName().equals(target_type.getName())) {
            try {
                Class<?> docDelegate = stubClazz.getClassLoader().loadClass("coldfusion.xml.rpc.xsd.DocumentDelegate");
                Object docDelegateInstance = docDelegate.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method getDocumentMethod = docDelegate.getMethod("getDocument", new Class[0]);
                Class<?> innerDocClass = getDocumentMethod.getReturnType();
                Method setDocumentMethod = docDelegate.getMethod("setDocument", innerDocClass);
                Object innerDocInstance = innerDocClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method setExtraElementMethod = innerDocClass.getMethod("setExtraElement", OMElement.class);
                OMElement element = BeanUtil.convertDOMtoOM((OMFactory)fac, (Object)((XmlNodeList)obj).getFirstNode());
                setExtraElementMethod.invoke(innerDocInstance, element);
                setDocumentMethod.invoke(docDelegateInstance, innerDocInstance);
                return docDelegateInstance;
            }
            catch (Exception e) {
                return obj;
            }
        }
        if (OMElement.class.getName().equals(target_type.getName())) {
            try {
                OMElement element = BeanUtil.convertDOMtoOM((OMFactory)fac, (Object)((XmlNodeList)obj).getFirstNode());
                return element;
            }
            catch (Exception e) {
                return obj;
            }
        }
        try {
            Object docObject = target_type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method setExtraElementMethod = target_type.getMethod("setExtraElement", OMElement.class);
            OMElement element = BeanUtil.convertDOMtoOM((OMFactory)fac, (Object)((XmlNodeList)obj).getFirstNode());
            setExtraElementMethod.invoke(docObject, element);
            return docObject;
        }
        catch (Exception e) {
            return obj;
        }
    }

    public Object createXmlNodeList2(Object retval) {
        if ("coldfusion.xml.rpc.xsd.DocumentDelegate".equals(retval.getClass().getName())) {
            try {
                Method getDocMethod = retval.getClass().getMethod("getDocument", new Class[0]);
                Object axis2Doc = getDocMethod.invoke(retval, new Object[0]);
                Method getExtraEltMethod = axis2Doc.getClass().getMethod("getExtraElement", new Class[0]);
                OMElement element = (OMElement)getExtraEltMethod.invoke(axis2Doc, new Object[0]);
                Document dom = XmlRpcServiceImpl.convertToDOM(element);
                return new XmlNodeList(dom, true);
            }
            catch (Exception e) {
                return retval;
            }
        }
        if (retval instanceof OMElement) {
            try {
                OMElement element = (OMElement)retval;
                Document dom = XmlRpcServiceImpl.convertToDOM(element.getFirstElement());
                return new XmlNodeList(dom, true);
            }
            catch (Exception e) {
                return retval;
            }
        }
        Class<?> clazz = retval.getClass();
        try {
            Method getExtraEltMethod = clazz.getMethod("getExtraElement", new Class[0]);
            OMElement element = (OMElement)getExtraEltMethod.invoke(retval, new Object[0]);
            Document dom = XmlRpcServiceImpl.convertToDOM(element.getFirstElement());
            return new XmlNodeList(dom, true);
        }
        catch (Exception e) {
            return retval;
        }
    }

    public Object convertQuery2(Class target_type, QueryTable query, Class stubClazz) {
        try {
            if (target_type == Object.class || target_type == QueryTable.class) {
                target_type = stubClazz.getClassLoader().loadClass("coldfusion.xml.rpc.xsd.QueryBean");
            }
            Object returnVal = target_type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method setColumnListMethod = target_type.getMethod("setColumnList", String[].class);
            Class arrayOfObjectClazz = this.getArrayOfObjectClass(target_type);
            int count = query.getRecordCount();
            Class<?> arrayOfArrayOfObjectClass = Array.newInstance(arrayOfObjectClazz, 1).getClass();
            Object data = Array.newInstance(arrayOfObjectClazz, count);
            Method setDataMethod = target_type.getMethod("setData", arrayOfArrayOfObjectClass);
            String[] columnList = query.getColumnList();
            setColumnListMethod.invoke(returnVal, new Object[]{columnList});
            Method setArrayMethod = arrayOfObjectClazz.getMethod("setArray", Object[].class);
            for (int i = 0; i < count; ++i) {
                Object row = arrayOfObjectClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Object[] rowData = new Object[columnList.length];
                for (int j = 0; j < columnList.length; ++j) {
                    rowData[j] = this.convertCFPrimitives(query.getField(i + 1, j + 1));
                }
                setArrayMethod.invoke(row, new Object[]{rowData});
                Array.set(data, i, row);
            }
            setDataMethod.invoke(returnVal, data);
            return returnVal;
        }
        catch (Exception e) {
            return query;
        }
    }

    private Class getArrayOfObjectClass(Class target_type) throws SecurityException, NoSuchMethodException {
        Method method = target_type.getMethod("getData", new Class[0]);
        return method.getReturnType().getComponentType();
    }

    protected Object convertCFPrimitives(Object value) {
        if (value instanceof CFBoolean) {
            if (ServiceProxy.CF_WS_PRESERVE_DATA_TYPE) {
                return ((CFBoolean)value).value ? Boolean.TRUE : Boolean.FALSE;
            }
            return Cast._String((CFBoolean)((CFBoolean)value));
        }
        if (value instanceof CFNumber) {
            if (ServiceProxy.CF_WS_PRESERVE_DATA_TYPE) {
                return ((CFNumber)value).unwrap();
            }
            return value.toString();
        }
        return value;
    }

    public void logInfoMessage2(Object stubo) {
        if (CFLogs.WEBSERVICE_LOG.isLoggingEnabled()) {
            try {
                org.apache.axis2.client.Stub stub = (org.apache.axis2.client.Stub)stubo;
                String endPointAddress = stub._getServiceClient().getOptions().getTo().getAddress();
                CFLogs.WEBSERVICE_LOG.info((Object)RB.getString((Object)this, (String)"Axis2ServiceProxy.usingAxis2", (Object)endPointAddress));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void doAxisGet(Object axisServlet, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ((CFAxisServlet)((Object)axisServlet)).doGet(request, response);
    }

    public void doAxis2Get(Object axis2Servlet, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ((CFAxis2Servlet)((Object)axis2Servlet)).doGet(request, response);
    }

    public void doAxisPost(Object axisServlet, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ((CFAxisServlet)((Object)axisServlet)).doPost(request, response);
    }

    public void doAxis2Post(Object axis2Servlet, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ((CFAxis2Servlet)((Object)axis2Servlet)).doPost(request, response);
    }

    public Object initCFAxisServlet(ServletConfig config) throws ServletException {
        CFAxisServlet cfAxisServlet = new CFAxisServlet();
        cfAxisServlet.init(config);
        return cfAxisServlet;
    }

    public Object initCFAxis2Servlet(ServletConfig config) throws ServletException {
        CFAxis2Servlet cfAxis2Servlet = new CFAxis2Servlet();
        cfAxis2Servlet.init(config);
        return cfAxis2Servlet;
    }

    public Object getParamReaderInstance(Class c) throws IOException {
        return new ParamReader(c);
    }

    public String[] getParameterNames(Object paramReader, Method m) {
        return ((ParamReader)paramReader).getParameterNames(m);
    }

    public String makeNamespace(String className) {
        return Namespaces.makeNamespace((String)className);
    }

    public void register(TypeMapping tm, Class clazz, QName qn) {
        tm.register(clazz, qn, (SerializerFactory)BaseSerializerFactory.createFactory(BeanSerializerFactory.class, (Class)clazz, (QName)qn), (DeserializerFactory)BaseDeserializerFactory.createFactory(BeanDeserializerFactory.class, (Class)clazz, (QName)qn));
    }

    public boolean isInstanceOfAxisFault(Object obj) {
        return obj instanceof AxisFault;
    }

    public String dumpToString(Throwable t) {
        return ((AxisFault)t).dumpToString();
    }

    public TypeMapping getTypeMapping(AttributeCollection metadata, Object msgContextObj) {
        org.apache.axis.encoding.TypeMapping tm = null;
        org.apache.axis.MessageContext msgContext = (org.apache.axis.MessageContext)msgContextObj;
        String document = (String)metadata.get((Object)"style");
        if (document != null && document.equalsIgnoreCase("document")) {
            msgContext.setEncodingStyle("");
        } else {
            msgContext.setEncodingStyle(Constants.URI_DEFAULT_SOAP_ENC);
        }
        TypeMappingRegistry typeMappingRegistry = msgContext.getTypeMappingRegistry();
        tm = typeMappingRegistry.getOrMakeTypeMapping(msgContext.getEncodingStyle());
        return tm;
    }

    static {
        System.setProperty("org.apache.axis2.codegen.config", "/cf-codegen-config.properties");
        if (System.getSecurityManager() != null) {
            String propsFile = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("java.home") + File.separator + "lib" + File.separator + "wsdl.properties";
                }
            });
            wsdlFactorySandboxPerms = new Permission[]{new FilePermission(propsFile, "read")};
        }
        auth_mod = null;
        try {
            auth_mod = Class.forName("HTTPClient.AuthorizationModule");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static class InvalidWebServiceVersionForConsumptionException
    extends ApplicationException {
        private String version;
        private String url;

        InvalidWebServiceVersionForConsumptionException(String version, String url) {
            this.version = version;
            this.url = url;
        }

        public String getVersion() {
            return this.version;
        }

        public String getURL() {
            return this.url;
        }
    }

    public class NoPortException
    extends ApplicationException {
        NoPortException() {
        }
    }

    public class InvalidPortException
    extends ApplicationException {
        public String portName;

        InvalidPortException(String port) {
            this.portName = port;
        }
    }

    public class CantFindWSDLException
    extends ApplicationException {
        public String wsdl;
        public String err;

        CantFindWSDLException(String wsdl, String err) {
            this.wsdl = wsdl;
            this.err = err;
        }
    }
}

