/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLSocketFactory;
import org.jivesoftware.smack.TlsTrustManager;

public class TlsSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory factory;
    private TlsTrustManager trustManager = new TlsTrustManager();

    public TlsSocketFactory() {
        try {
            SSLContext context = SSLContext.getInstance((String)"TLS");
            context.init(null, new TrustManager[]{this.trustManager}, new SecureRandom());
            this.factory = context.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    public TlsTrustManager getTrustManager() {
        return this.trustManager;
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.factory.createSocket(address, port);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.factory.createSocket(address, port, localAddress, localPort);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.factory.createSocket(socket, host, port, autoClose);
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.factory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.factory.createSocket(host, port, localAddress, localPort);
    }

    public String[] getDefaultCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

