/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.session.external;

import coldfusion.log.CFLogs;
import coldfusion.monitor.memory.SessionMemoryMonitor;
import coldfusion.runtime.SessionKeyObject;
import coldfusion.runtime.SessionScope;
import coldfusion.runtime.session.AbstractSessionStorage;
import coldfusion.runtime.session.SessionEndEventInvoker;
import coldfusion.runtime.session.external.SessionMetadata;
import coldfusion.runtime.session.external.SessionSerializer;
import coldfusion.session.NodeDiscoveryManager;
import coldfusion.session.external.RedisConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

public class RedisSessionStorage
extends AbstractSessionStorage {
    private static final String SESSION_METADATA_BASE_KEY = "cf:sessions:metadata";
    private static final String SESSION_KEY_LIST = "cf:sessions:keylist";
    private static final String NODE_SESSION_LIST = "cf:sessions:nodes:";
    private static final String NODE_TIMEOUT_LIST = "cf:timeout:nodes:";
    private static final String SESSION_TIMEOUT_BASE_KEY = "cf:sessions:timeout";
    private JedisPool connectionPool = null;
    NodeDiscoveryManager nodeDiscoveryManager;
    private String node_seession_set_key;
    private String node_timeout_set_key;
    private RedisConfig redisConfig = null;
    private ConcurrentHashMap<String, Object> sessionTimeouts = new ConcurrentHashMap();
    private int expiredSessionCount;
    private boolean scriptExist = false;
    private static final String getSessionCountScript = "local count=0 local s={} local r={} r=redis.call('smembers','cf:sessions:keylist') for k,v in pairs(r) do s=redis.call('hgetall',v) for _ in pairs(s) do count=count+1 end end return count";
    private static final String getActiveSessionCountScript = "local count=0 local s=nil local r={} r=redis.call('smembers','cf:sessions:keylist') for k,v in pairs(r) do s=redis.pcall('hget',v,ARGV[1]) if type(s)=='string' then count=count+1 end end return count";
    private String getSessionCountScriptSha1Digest = "4f60d91b08e6c2cdd22ad79959f9c345b028f3fa";
    private String getActiveSessionCountScriptSha1Digest = "5a30de33eba6943cef53b052a925711b7054ddbb";
    private static boolean REDIS_DEBUG = Boolean.getBoolean("redisperfcheck");

    public RedisSessionStorage(RedisConfig config, NodeDiscoveryManager dm) {
        Map redisSessionTimeouts;
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setBlockWhenExhausted(config.isBlockWhenExhausted());
        poolConfig.setTestOnBorrow(config.isValidateConnection());
        poolConfig.setTestOnReturn(config.isValidateConnectionOnCheckout());
        poolConfig.setMaxWaitMillis(config.getMaxwaitMillis());
        poolConfig.setMaxTotal(config.getMaxConnections());
        poolConfig.setMaxIdle(config.getMaxIdle());
        poolConfig.setMinIdle(config.getMinIdle());
        poolConfig.setJmxEnabled(config.isJmxEnabled());
        poolConfig.setJmxNamePrefix(RedisConfig.jmxPrefix);
        this.connectionPool = new JedisPool(poolConfig, config.getHost(), config.getPort(), config.getTimeout(), config.getPassword(), config.getDatabase(), config.isSSL());
        this.redisConfig = config;
        this.expiredSessionCount = 0;
        config.setPassword(null);
        this.nodeDiscoveryManager = dm;
        this.node_seession_set_key = this.getNodeSessionListKey(this.nodeDiscoveryManager.getNode().getName());
        this.node_timeout_set_key = this.getNodeTimeoutListKey(this.nodeDiscoveryManager.getNode().getName());
        try (Jedis jedis = this.connectionPool.getResource();){
            redisSessionTimeouts = jedis.hgetAll(this.node_timeout_set_key);
        }
        for (Map.Entry entry : redisSessionTimeouts.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            try {
                this.sessionTimeouts.put(key, Long.parseLong(value));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public RedisConfig getRedisConfig() {
        return this.redisConfig;
    }

    public void test(String host, int port, String password, String ... args) {
        RedisSessionStorage.testConnection(host, port, password, false, false, args);
    }

    public void test(String host, int port, String password, boolean isCluster, String ... args) {
        RedisSessionStorage.testConnection(host, port, password, isCluster, false, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testConnection(String host, int port, String password, boolean isCluster, boolean ssl, String ... args) {
        if (!isCluster) {
            try (Jedis connection = null;){
                connection = new Jedis(host, port, ssl);
                if (password != null && !password.trim().equalsIgnoreCase("")) {
                    connection.auth(password);
                }
                connection.ping();
                connection.set("test", "test");
                connection.del("test");
            }
        }
        try (JedisCluster con = null;){
            HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
            jedisClusterNode.add(new HostAndPort(host, port));
            con = new JedisCluster(jedisClusterNode, new GenericObjectPoolConfig());
        }
    }

    public SessionScope getSession(String appName, String key) throws IOException {
        byte[] sessionBytes;
        try (Jedis jedis = this.connectionPool.getResource();){
            sessionBytes = this.getSessionBytes(appName, key, jedis);
        }
        return this.deSerializeSession(sessionBytes);
    }

    private byte[] getSessionBytes(String appName, String key, Jedis jedis) throws IOException {
        return jedis.hget(key.getBytes(), appName.getBytes());
    }

    private SessionScope deSerializeSession(byte[] serializedSession) throws IOException {
        if (serializedSession != null) {
            return (SessionScope)SessionSerializer.deSerialize((byte[])serializedSession);
        }
        return null;
    }

    public void setSession(String appName, String key, SessionScope s) throws IOException {
        byte[] sessionBytes = SessionSerializer.serialize((Object)s);
        byte[] appNameBytes = appName.getBytes();
        String sessionTimeoutKey = this.getSessionTimeoutKey(key).substring(20) + "_" + appName;
        long lastAccess = System.currentTimeMillis();
        byte[] metadataBytes = SessionSerializer.serialize((Object)new SessionMetadata(lastAccess, s.getMaxInactiveInterval() * 1000L));
        long ttl = lastAccess / 1000L + s.getMaxInactiveInterval();
        byte[] sessionMetadataKey = this.getSessionMetadataKey(key);
        try (Jedis jedis = this.connectionPool.getResource();){
            jedis.hset(key.getBytes(), appNameBytes, sessionBytes);
            jedis.hset(sessionMetadataKey, appNameBytes, metadataBytes);
            this.sessionTimeouts.put(sessionTimeoutKey, ttl);
            jedis.hset(this.node_timeout_set_key, sessionTimeoutKey, String.valueOf(ttl));
            jedis.sadd(SESSION_KEY_LIST, new String[]{key});
            jedis.sadd(this.node_seession_set_key, new String[]{key});
        }
    }

    private String getNodeSessionListKey(String key) {
        return NODE_SESSION_LIST + key;
    }

    private String getNodeTimeoutListKey(String key) {
        return NODE_TIMEOUT_LIST + key;
    }

    private byte[] getSessionMetadataKey(String key) {
        return ("cf:sessions:metadata:" + key).getBytes();
    }

    private String getSessionTimeoutKey(String key) {
        return "cf:sessions:timeout:" + key;
    }

    public void remove(String key, String appName) {
        try (Jedis jedis = this.connectionPool.getResource();){
            this.remove(key, appName, jedis);
        }
    }

    private void remove(String key, String appName, Jedis jedis) {
        jedis.hdel(this.getSessionMetadataKey(key), (byte[][])new byte[][]{appName.getBytes()});
        jedis.hdel(key.getBytes(), (byte[][])new byte[][]{appName.getBytes()});
        if (jedis.hlen(key.getBytes()) <= 0L) {
            jedis.srem(SESSION_KEY_LIST, new String[]{key});
            jedis.srem(this.node_seession_set_key, new String[]{key});
            jedis.hdel(this.node_timeout_set_key, new String[]{key + "_" + appName});
            this.sessionTimeouts.remove(key + "_" + appName);
        }
    }

    private SessionScope getAndRemove(String key, String appName, Jedis jedis) {
        SessionScope sessionScope = null;
        try {
            byte[] sessionBytes = this.getSessionBytes(appName, key, jedis);
            sessionScope = this.deSerializeSession(sessionBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.remove(key, appName, jedis);
        return sessionScope;
    }

    public List<SessionEndEventInvoker> cleanUp() {
        Iterator<String> nodes = this.nodeDiscoveryManager.getNodesForSessionCleanup();
        if (nodes != null && nodes.hasNext()) {
            try (Jedis jedis = this.connectionPool.getResource();){
                while (nodes.hasNext()) {
                    String node = nodes.next();
                    Map<String, Object> nodeSessionTimeouts = null;
                    nodeSessionTimeouts = !node.equalsIgnoreCase(this.nodeDiscoveryManager.getNode().getName()) ? jedis.hgetAll(this.node_timeout_set_key) : this.sessionTimeouts;
                    long currentTimeMillis = System.currentTimeMillis();
                    long currentTimeSeconds = currentTimeMillis / 1000L;
                    for (Map.Entry<String, Object> sessionEntry : nodeSessionTimeouts.entrySet()) {
                        int firstUnderScoreIndex;
                        String sessionKeyWithApp = sessionEntry.getKey();
                        Object timeoutObj = sessionEntry.getValue();
                        long timeout = timeoutObj instanceof String ? Long.parseLong((String)timeoutObj) : (Long)timeoutObj;
                        if (timeout >= currentTimeSeconds || (firstUnderScoreIndex = sessionKeyWithApp.indexOf(95)) < 0 || sessionKeyWithApp.length() < firstUnderScoreIndex + 1) continue;
                        int appSplitIndex = sessionKeyWithApp.indexOf("_", firstUnderScoreIndex + 1);
                        if (appSplitIndex == -1) {
                            appSplitIndex = firstUnderScoreIndex;
                        }
                        String sessionKey = sessionKeyWithApp.substring(0, appSplitIndex);
                        String appName = appSplitIndex < 0 || sessionKeyWithApp.length() < appSplitIndex + 1 ? "" : sessionKeyWithApp.substring(appSplitIndex + 1);
                        SessionScope sessionScope = this.getAndRemove(sessionKey, appName, jedis);
                        ++this.expiredSessionCount;
                        this.invokeSessionEnd(sessionScope, appName);
                    }
                    if (!REDIS_DEBUG) continue;
                    CFLogs.SERVER_LOG.info((Object)("Local Timedout sessions dealt with in :" + (System.currentTimeMillis() - currentTimeMillis) + " milliseconds"));
                }
            }
        }
        return null;
    }

    public int getActiveSessionCount(String appName) throws IOException {
        if (appName == null) {
            return this.getSessionCount();
        }
        return this._getSessionCount(this.getActiveSessionCountScriptSha1Digest, getActiveSessionCountScript, Collections.emptyList(), Collections.singletonList(appName));
    }

    private int _getSessionCount(String sha1Digest, String script, List<String> keys, List<String> args) {
        try (Jedis jedis = null;){
            jedis = this.connectionPool.getResource();
            if (!this.scriptExist) {
                this.loadScripts(jedis);
            }
            int n = ((Long)jedis.evalsha(sha1Digest, keys, args)).intValue();
            return n;
        }
    }

    private void loadScripts(Jedis jedis) {
        jedis.scriptLoad(getSessionCountScript);
        jedis.scriptLoad(getActiveSessionCountScript);
        this.scriptExist = true;
    }

    public ConcurrentMap<String, Object> getApplicationSessionMap(String key) throws IOException {
        Map sessionsAppsKeys = null;
        try (Jedis jedis = this.connectionPool.getResource();){
            sessionsAppsKeys = jedis.hgetAll(key.getBytes());
        }
        if (sessionsAppsKeys != null) {
            Set appNameKeys = sessionsAppsKeys.keySet();
            ConcurrentHashMap<String, Object> appSessionMap = new ConcurrentHashMap<String, Object>();
            for (byte[] app : appNameKeys) {
                appSessionMap.put(new String(app), SessionSerializer.deSerialize((byte[])((byte[])sessionsAppsKeys.get(app))));
            }
            return appSessionMap;
        }
        return null;
    }

    public ConcurrentMap<String, Object> getAppSessions(String appName) throws IOException {
        ArrayList<byte[]> appSessionsBytes;
        ConcurrentHashMap<String, Object> appSessions;
        block17: {
            appSessions = new ConcurrentHashMap<String, Object>();
            appSessionsBytes = new ArrayList<byte[]>();
            byte[] appNameBytes = appName.getBytes();
            try (Jedis jedis = this.connectionPool.getResource();){
                Set sessionKeys = jedis.smembers(SESSION_KEY_LIST);
                if (sessionKeys != null) {
                    for (String sessionKey : sessionKeys) {
                        byte[] obj = jedis.hget(sessionKey.getBytes(), appNameBytes);
                        if (obj == null) continue;
                        appSessionsBytes.add(obj);
                    }
                    break block17;
                }
                ConcurrentHashMap<String, Object> concurrentHashMap = appSessions;
                return concurrentHashMap;
            }
        }
        Iterator it = appSessionsBytes.iterator();
        while (it.hasNext()) {
            byte[] sessionBytes = (byte[])it.next();
            Object session = SessionSerializer.deSerialize((byte[])sessionBytes);
            it.remove();
            appSessions.put(((SessionScope)session).getTrackerSessionId(), session);
        }
        return appSessions;
    }

    public void setAppSession(String key, ConcurrentMap<String, Object> sessions) throws IOException {
        if (sessions != null && sessions.size() > 0) {
            for (Map.Entry sessionEntry : sessions.entrySet()) {
                this.setSession((String)sessionEntry.getKey(), key, (SessionScope)sessionEntry.getValue());
            }
        }
    }

    public int getSessionCount() throws IOException {
        return this._getSessionCount(this.getSessionCountScriptSha1Digest, getSessionCountScript, Collections.emptyList(), Collections.emptyList()) / 2;
    }

    public Set<SessionKeyObject> getSessionKeyObjects() {
        return null;
    }

    public Set<String> getSessionKeys() {
        try (Jedis jedis = this.connectionPool.getResource();){
            Set set = jedis.hkeys(SESSION_METADATA_BASE_KEY);
            return set;
        }
    }

    public boolean sessionExists(String m_cfid, String m_cftoken) {
        String key = this.getKey(m_cfid, m_cftoken);
        try (Jedis jedis = this.connectionPool.getResource();){
            boolean bl = jedis.sismember(SESSION_KEY_LIST, key);
            return bl;
        }
    }

    private String getKey(SessionScope scope) {
        return this.getKey((String)scope.get((Object)"cfid"), (String)scope.get((Object)"cftoken"));
    }

    private String getKey(String m_cfid, String m_cftoken) {
        StringBuilder builder = new StringBuilder();
        builder.append(m_cfid).append('_').append(m_cftoken);
        return builder.toString();
    }

    public boolean isMomoryTrackingSupported() {
        return false;
    }

    public SessionMemoryMonitor getSessionMemoryMonitor() {
        return null;
    }

    public void updateLastAccess(SessionScope session) throws IOException {
        String sessionKey = this.getKey(session);
        byte[] appNameBytes = session.getAppName().getBytes();
        byte[] sessionBytes = SessionSerializer.serialize((Object)session);
        byte[] sessionMetadataKey = this.getSessionMetadataKey(sessionKey);
        String sessionTimeoutKey = this.getSessionTimeoutKey(sessionKey).substring(20) + "_" + session.getAppName();
        long lastAccess = System.currentTimeMillis();
        byte[] sessionMetadataBytes = SessionSerializer.serialize((Object)new SessionMetadata(lastAccess, session.getMaxInactiveInterval() * 1000L));
        long ttl = lastAccess / 1000L + session.getMaxInactiveInterval();
        try (Jedis jedis = this.connectionPool.getResource();){
            jedis.hset(sessionKey.getBytes(), appNameBytes, sessionBytes);
            jedis.hset(sessionMetadataKey, appNameBytes, sessionMetadataBytes);
            this.sessionTimeouts.put(sessionTimeoutKey, ttl);
            jedis.hset(this.node_timeout_set_key, sessionTimeoutKey, String.valueOf(ttl));
        }
        catch (Exception e) {
            CFLogs.SECURITY_LOG.error((Object)"Unable to save session to redis", (Throwable)e);
        }
    }

    public int getExpiredSessionCount() throws IOException {
        return this.expiredSessionCount;
    }

    public void clearExpiredSessionCount() {
        this.expiredSessionCount = 0;
    }
}

