/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.document.DocumentFontException;
import coldfusion.log.CFLogs;
import coldfusion.server.ServiceFactory;
import com.lowagie.text.FontFactory;
import ice.pilots.html4.FontProvider;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BrowserFontProvider
implements FontProvider {
    private static BrowserFontProvider _fontProvider = null;
    private static Graphics2D _graphics = null;
    private static ArrayList fontFamilies = null;
    private static final HashMap fontCache = new HashMap();
    private static final boolean isMac = System.getProperty("os.name").equals("Mac OS X");
    private static final String ARIAL_UNICODE = "arial unicode ms";

    public BrowserFontProvider() {
        try {
            ServiceFactory.getDocumentService().waitForFontInitialization();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static BrowserFontProvider getInstance() {
        if (_fontProvider == null) {
            _fontProvider = new BrowserFontProvider();
        }
        return _fontProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Font getFont(String fontFamilyName, int fontstyle, int size) {
        Font font = new Font(fontFamilyName, fontstyle, size);
        if (font.getFamily().equalsIgnoreCase(fontFamilyName)) {
            return font;
        }
        String path = FontFactory.getFontPath((String)fontFamilyName, (int)fontstyle);
        Font awtFont = null;
        if (path != null) {
            try {
                int index = path.indexOf(",");
                if (index > 0) {
                    path = path.substring(0, index);
                }
                HashMap hashMap = fontCache;
                synchronized (hashMap) {
                    awtFont = (Font)fontCache.get(path);
                    if (awtFont != null) {
                        return awtFont.deriveFont(fontstyle, size);
                    }
                }
                File file = new File(path);
                String filename = file.getName().toLowerCase();
                if (filename.endsWith(".otf")) {
                    return null;
                }
                if (!file.canRead()) return awtFont;
                FileInputStream is = new FileInputStream(file);
                awtFont = Font.createFont(0, is);
                awtFont = awtFont.deriveFont(fontstyle, size);
                HashMap hashMap2 = fontCache;
                synchronized (hashMap2) {
                    fontCache.put(path, awtFont);
                    return awtFont;
                }
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error((Throwable)e);
                throw new DocumentFontException(path, e);
            }
        }
        CFLogs.SERVER_LOG.info((Object)("BrowserFontProvider: Can't find font file for " + fontFamilyName));
        return awtFont;
    }

    public static synchronized void initializeFontFamilies() {
        fontFamilies = new ArrayList();
        Map map = BrowserFontProvider.getAvailableFontFamilies();
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            String key = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            String path = (String)value.get(key);
            if (path == null || path.equalsIgnoreCase(key)) continue;
            fontFamilies.add(key.toLowerCase());
        }
        if (isMac && fontFamilies.remove(ARIAL_UNICODE)) {
            fontFamilies.add(0, ARIAL_UNICODE);
        }
    }

    private static synchronized ArrayList getTrueTypeFontFamiliesAsList() {
        if (fontFamilies != null) {
            return fontFamilies;
        }
        BrowserFontProvider.initializeFontFamilies();
        return fontFamilies;
    }

    public String[] getFontFamilies() {
        ArrayList list = BrowserFontProvider.getTrueTypeFontFamiliesAsList();
        return list.toArray(new String[list.size()]);
    }

    public boolean isFamilySupported(String fontFamily) {
        ArrayList list = BrowserFontProvider.getTrueTypeFontFamiliesAsList();
        return list.contains(fontFamily.toLowerCase());
    }

    public static Map getAvailableFontFamilies() {
        HashMap FontFamilyMap = new HashMap();
        Map FontMap = FontFactory.getFontFaces();
        Map FontProp = FontFactory.getFontProperties();
        for (String fontFamilyName : FontMap.keySet()) {
            List list = (List)FontMap.get(fontFamilyName);
            Iterator is = list.iterator();
            HashMap FontFaceMap = new HashMap();
            while (is.hasNext()) {
                String fontface = ((String)is.next()).toLowerCase();
                if (!FontProp.containsKey(fontface)) continue;
                FontFaceMap.put(fontface, FontProp.get(fontface));
            }
            FontFamilyMap.put(fontFamilyName, FontFaceMap);
        }
        return FontFamilyMap;
    }

    public FontMetrics getFontMetrics(Font font) {
        if (_graphics == null) {
            BufferedImage bi = new BufferedImage(50, 50, 1);
            _graphics = bi.createGraphics();
            _graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            _graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            _graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        return _graphics.getFontMetrics(font);
    }
}

