/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCacheMonitor;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheFactory;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheManager;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWaitFacade;
import org.apache.commons.jcs.auxiliary.remote.RemoteLocation;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs.engine.CacheStatus;

public class RemoteCacheFailoverRunner<K, V>
extends AbstractAuxiliaryCacheMonitor {
    private final RemoteCacheNoWaitFacade<K, V> facade;
    private final RemoteCacheFactory cacheFactory;

    public RemoteCacheFailoverRunner(RemoteCacheNoWaitFacade<K, V> facade, RemoteCacheFactory cacheFactory) {
        super("JCS-RemoteCacheFailoverRunner");
        this.facade = facade;
        this.cacheFactory = cacheFactory;
        RemoteCacheFailoverRunner.setIdlePeriod(20000L);
    }

    @Override
    protected void dispose() {
    }

    @Override
    protected void doWork() {
    }

    @Override
    public void run() {
        this.connectAndRestore();
        if (this.log.isInfoEnabled()) {
            int failoverIndex = this.facade.getAuxiliaryCacheAttributes().getFailoverIndex();
            this.log.info((Object)("Exiting failover runner. Failover index = " + failoverIndex));
            if (failoverIndex <= 0) {
                this.log.info((Object)"Failover index is <= 0, meaning we are not connected to a failover server.");
            } else if (failoverIndex > 0) {
                this.log.info((Object)"Failover index is > 0, meaning we are connected to a failover server.");
            }
        }
    }

    private void connectAndRestore() {
        IRemoteCacheAttributes rca0 = this.facade.getAuxiliaryCacheAttributes();
        do {
            this.log.info((Object)"Remote cache FAILOVER RUNNING.");
            if (!this.allright.get()) {
                List<RemoteLocation> failovers = rca0.getFailovers();
                if (failovers == null) {
                    this.log.warn((Object)"Remote is misconfigured, failovers was null.");
                    return;
                }
                if (failovers.size() == 1) {
                    this.log.info((Object)"No failovers defined, exiting failover runner.");
                    return;
                }
                int fidx = rca0.getFailoverIndex();
                this.log.debug((Object)("fidx = " + fidx + " failovers.size = " + failovers.size()));
                ListIterator<RemoteLocation> i = failovers.listIterator(fidx);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("starting at failover i = " + i.nextIndex()));
                }
                while (i.hasNext() && !this.allright.get()) {
                    RemoteCacheNoWait ic;
                    RemoteLocation server = i.next();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Trying server [" + server + "] at failover index i = " + i));
                    }
                    RemoteCacheAttributes rca = (RemoteCacheAttributes)rca0.clone();
                    rca.setRemoteLocation(server);
                    RemoteCacheManager rcm = this.cacheFactory.getManager(rca);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("RemoteCacheAttributes for failover = " + rca.toString()));
                    }
                    if (rcm == null || (ic = rcm.getCache(rca)).getStatus() != CacheStatus.ALIVE) continue;
                    this.log.debug((Object)"resetting no wait");
                    this.facade.restorePrimaryServer(ic);
                    rca0.setFailoverIndex(i.nextIndex());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"setting ALLRIGHT to true");
                        if (i.hasPrevious()) {
                            this.log.debug((Object)("Moving to Primary Recovery Mode, failover index = " + i.nextIndex()));
                        } else {
                            this.log.debug((Object)"No need to connect to failover, the primary server is back up.");
                        }
                    }
                    this.allright.set(true);
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info((Object)("CONNECTED to host = [" + rca.getRemoteLocation() + "]"));
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"ALLRIGHT is true ");
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Failover runner is in primary recovery mode. Failover index = " + rca0.getFailoverIndex() + "\n" + "Will now try to reconnect to primary server."));
                }
            }
            boolean primaryRestoredSuccessfully = false;
            if (rca0.getFailoverIndex() > 0) {
                primaryRestoredSuccessfully = this.restorePrimary();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Primary recovery success state = " + primaryRestoredSuccessfully));
                }
            }
            if (primaryRestoredSuccessfully) continue;
            try {
                this.log.warn((Object)("Failed to reconnect to primary server. Cache failover runner is going to sleep for " + idlePeriod + " milliseconds."));
                Thread.sleep(idlePeriod);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (rca0.getFailoverIndex() > 0 || !this.allright.get());
    }

    private boolean restorePrimary() {
        RemoteCacheNoWait ic;
        IRemoteCacheAttributes rca0 = this.facade.getAuxiliaryCacheAttributes();
        RemoteLocation server = rca0.getFailovers().get(0);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Trying to restore connection to primary remote server [" + server + "]"));
        }
        RemoteCacheAttributes rca = (RemoteCacheAttributes)rca0.clone();
        rca.setRemoteLocation(server);
        RemoteCacheManager rcm = this.cacheFactory.getManager(rca);
        if (rcm != null && (ic = rcm.getCache(rca)).getStatus() == CacheStatus.ALIVE) {
            try {
                if (this.facade.getPrimaryServer() != null && this.facade.getPrimaryServer().getStatus() == CacheStatus.ALIVE) {
                    int fidx = rca0.getFailoverIndex();
                    if (fidx > 0) {
                        RemoteLocation serverOld = rca0.getFailovers().get(fidx);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Failover Index = " + fidx + " the server at that index is [" + serverOld + "]"));
                        }
                        if (serverOld != null) {
                            RemoteCacheAttributes rcaOld = (RemoteCacheAttributes)rca0.clone();
                            rcaOld.setRemoteLocation(serverOld);
                            RemoteCacheManager rcmOld = this.cacheFactory.getManager(rcaOld);
                            if (rcmOld != null) {
                                rcmOld.removeRemoteCacheListener(rcaOld);
                            }
                            if (this.log.isInfoEnabled()) {
                                this.log.info((Object)("Successfully deregistered from FAILOVER remote server = " + serverOld));
                            }
                        }
                    } else if (fidx == 0) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"No need to restore primary, it is already restored.");
                            return true;
                        }
                    } else if (fidx < 0) {
                        this.log.warn((Object)"Failover index is less than 0, this shouldn't happen");
                    }
                }
            }
            catch (IOException e) {
                this.log.error((Object)("Trouble trying to deregister old failover listener prior to restoring the primary = " + server), (Throwable)e);
            }
            RemoteCacheNoWait failoverNoWait = this.facade.getPrimaryServer();
            this.facade.restorePrimaryServer(ic);
            rca0.setFailoverIndex(0);
            if (this.log.isInfoEnabled()) {
                String message = "Successfully reconnected to PRIMARY remote server.  Substituted primary for failoverNoWait [" + failoverNoWait + "]";
                this.log.info((Object)message);
                if (this.facade.getCacheEventLogger() != null) {
                    this.facade.getCacheEventLogger().logApplicationEvent("RemoteCacheFailoverRunner", "RestoredPrimary", message);
                }
            }
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Primary server status in error, not connected.");
        }
        return false;
    }
}

