/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRDesignTextField
extends JRDesignTextElement
implements JRTextField {
    private static final long serialVersionUID = 10200L;
    protected boolean isStretchWithOverflow = false;
    protected byte evaluationTime = 1;
    protected String pattern = null;
    protected Boolean isBlankWhenNull = null;
    protected byte hyperlinkType = 0;
    protected String linkType;
    protected byte hyperlinkTarget = 1;
    private List hyperlinkParameters = new ArrayList();
    protected JRGroup evaluationGroup = null;
    protected JRExpression expression = null;
    protected JRExpression anchorNameExpression = null;
    protected JRExpression hyperlinkReferenceExpression = null;
    protected JRExpression hyperlinkAnchorExpression = null;
    protected JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    protected JRExpression altTextExpression = null;
    protected int bookmarkLevel = 0;

    public JRDesignTextField() {
        super(null);
    }

    public JRDesignTextField(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    @Override
    public boolean isStretchWithOverflow() {
        return this.isStretchWithOverflow;
    }

    @Override
    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    @Override
    public String getPattern() {
        return JRStyleResolver.getPattern(this);
    }

    @Override
    public String getOwnPattern() {
        return this.pattern;
    }

    @Override
    public boolean isBlankWhenNull() {
        return JRStyleResolver.isBlankWhenNull(this);
    }

    @Override
    public Boolean isOwnBlankWhenNull() {
        return this.isBlankWhenNull;
    }

    @Override
    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    @Override
    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public JRExpression getAltTextExpression() {
        return this.altTextExpression;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public void setStretchWithOverflow(boolean isStretch) {
        this.isStretchWithOverflow = isStretch;
    }

    public void setEvaluationTime(byte evaluationTime) {
        this.evaluationTime = evaluationTime;
    }

    @Override
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public void setBlankWhenNull(boolean isBlank) {
        this.isBlankWhenNull = isBlank ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void setBlankWhenNull(Boolean isBlank) {
        this.isBlankWhenNull = isBlank;
    }

    public void setHyperlinkType(byte hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(hyperlinkType));
    }

    public void setHyperlinkTarget(byte hyperlinkTarget) {
        this.hyperlinkTarget = hyperlinkTarget;
    }

    public void setEvaluationGroup(JRGroup evaluationGroup) {
        this.evaluationGroup = evaluationGroup;
    }

    public void setExpression(JRExpression expression) {
        this.expression = expression;
    }

    public void setAnchorNameExpression(JRExpression anchorNameExpression) {
        this.anchorNameExpression = anchorNameExpression;
    }

    public void setAltTextExpression(JRExpression altTextExpression) {
        this.altTextExpression = altTextExpression;
    }

    public void setHyperlinkReferenceExpression(JRExpression hyperlinkReferenceExpression) {
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
    }

    public void setHyperlinkAnchorExpression(JRExpression hyperlinkAnchorExpression) {
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
    }

    public void setHyperlinkPageExpression(JRExpression hyperlinkPageExpression) {
        this.hyperlinkPageExpression = hyperlinkPageExpression;
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getTextField(this);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void writeXml(JRXmlWriter xmlWriter) throws IOException {
        xmlWriter.writeTextField(this);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        this.bookmarkLevel = bookmarkLevel;
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String type) {
        this.linkType = type;
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] parameters;
        if (this.hyperlinkParameters.isEmpty()) {
            parameters = null;
        } else {
            parameters = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(parameters);
        }
        return parameters;
    }

    public List getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter parameter) {
        this.hyperlinkParameters.add(parameter);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter parameter) {
        this.hyperlinkParameters.remove(parameter);
    }

    public void removeHyperlinkParameter(String parameterName) {
        Iterator it = this.hyperlinkParameters.iterator();
        while (it.hasNext()) {
            JRHyperlinkParameter parameter = (JRHyperlinkParameter)it.next();
            if (parameter.getName() == null || !parameter.getName().equals(parameterName)) continue;
            it.remove();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.normalizeLinkType();
    }

    protected void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public void setHyperlinkTooltipExpression(JRExpression hyperlinkTooltipExpression) {
        this.hyperlinkTooltipExpression = hyperlinkTooltipExpression;
    }
}

