/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.messaging;

import coldfusion.tagext.net.websocket.messaging.ChannelRequestHeader;
import coldfusion.tagext.net.websocket.messaging.ChannelUtil;
import coldfusion.tagext.net.websocket.messaging.Subscriber;
import coldfusion.tagext.net.websocket.server.core.AbstractClientConnection;
import coldfusion.tagext.net.websocket.server.core.TokenMap;
import coldfusion.util.CaseInsensitiveHashtable;
import java.util.Map;

public class SubscriberData {
    private Subscriber subscriber;
    private final Map subscriberRequestInfoMap = new CaseInsensitiveHashtable();

    public SubscriberData(AbstractClientConnection aConnector, TokenMap aToken) {
        this.subscriber = new Subscriber(aConnector.getConnectionId());
        this.parseSubscriberRequestInfo(aToken);
    }

    public SubscriberData(AbstractClientConnection aConnector, TokenMap aToken, boolean safeMode) {
        this.subscriber = new Subscriber(aConnector.getConnectionId());
        if (safeMode) {
            this.parseSubscriberRequestInfoSafe(aToken);
        } else {
            this.parseSubscriberRequestInfo(aToken);
        }
    }

    public void parseSubscriberRequestInfo(TokenMap aToken) {
        ChannelRequestHeader subscriberRequestHeader = ChannelUtil.parseRequestHeader(aToken);
        this.subscriberRequestInfoMap.put(aToken.getString("channel"), subscriberRequestHeader);
    }

    public void parseSubscriberRequestInfoSafe(TokenMap aToken) {
        ChannelRequestHeader subscriberRequestHeader = ChannelUtil.parseRequestHeaderWithoutSelectors(aToken);
        this.subscriberRequestInfoMap.put(aToken.getString("channel"), subscriberRequestHeader);
    }

    public void compileSelectorsForChannel(TokenMap aToken, String channelId) {
        ChannelRequestHeader fullHeader = ChannelUtil.parseRequestHeader(aToken);
        this.subscriberRequestInfoMap.put(channelId, fullHeader);
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public ChannelRequestHeader getWSRequestInfo(String aChannelId) {
        return (ChannelRequestHeader)this.subscriberRequestInfoMap.get(aChannelId);
    }

    public ChannelRequestHeader removeWSRequestInfo(String aChannelId) {
        return (ChannelRequestHeader)this.subscriberRequestInfoMap.remove(aChannelId);
    }

    public Map getSubscriberRequestInfoMap() {
        return this.subscriberRequestInfoMap;
    }
}

