/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.net.ConnectionRoute;
import ice.util.Defs;
import java.io.Serializable;

public abstract class Indirect
extends ConnectionRoute
implements Serializable {
    private static final long DEFAULT_RETRY_INTERVAL = 1800000L;
    private static long retryInterval = Defs.sysPropertyInt((String)"ice.net.indirectRetryInterval", (int)1800000);
    private int failedCounter = 0;
    private String host;
    private Object lock = new Object();
    private int port;
    private long timestamp;

    protected Indirect(String host, int port) throws IllegalArgumentException {
        this.checkHost(host);
        this.checkPort(port);
        this.host = host.trim().toLowerCase();
        this.port = port;
    }

    public boolean equals(Object object) {
        if (object instanceof Indirect) {
            return super.equals(object) && this.host.equals(((Indirect)object).getHost()) && this.port == ((Indirect)object).getPort();
        }
        return false;
    }

    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public final int getStatus() {
        int _status = super.getStatus();
        if (_status == 3 && this.timestamp < System.currentTimeMillis() - (long)this.failedCounter * retryInterval) {
            _status = 1;
            super.setStatus(1);
        }
        return _status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setStatus(int status) {
        this.checkStatus(status);
        Object object = this.lock;
        synchronized (object) {
            super.setStatus(status);
            if (status == 3) {
                ++this.failedCounter;
                this.timestamp = System.currentTimeMillis();
            }
        }
    }

    protected final void checkHost(String host) throws IllegalArgumentException {
        if (host == null) {
            throw new IllegalArgumentException("host is null");
        }
        if (host.trim().length() == 0) {
            throw new IllegalArgumentException("host is empty");
        }
    }

    protected final void checkPort(int port) throws IllegalArgumentException {
        if (port < 0 || port > 65536) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
    }
}

