/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.math.ec.custom.gm;

import java.math.BigInteger;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECCurve;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECFieldElement;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECLookupTable;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECPoint;
import macromedia.db2util.externals.org.bouncycastle.math.ec.custom.gm.SM2P256V1FieldElement;
import macromedia.db2util.externals.org.bouncycastle.math.ec.custom.gm.SM2P256V1Point;
import macromedia.db2util.externals.org.bouncycastle.math.raw.Nat256;
import macromedia.db2util.externals.org.bouncycastle.util.encoders.Hex;

public class SM2P256V1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF"));
    private static final int SM2P256V1_DEFAULT_COORDS = 2;
    protected SM2P256V1Point infinity = new SM2P256V1Point(this, null, null);

    public SM2P256V1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93")));
        this.order = new BigInteger(1, Hex.decode("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SM2P256V1Curve();
    }

    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    public int getFieldSize() {
        return q.bitLength();
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SM2P256V1FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
        return new SM2P256V1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl) {
        return new SM2P256V1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, final int n3) {
        int n4 = 8;
        final int[] nArray = new int[n3 << 3 << 1];
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat256.copy(((SM2P256V1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n5);
            Nat256.copy(((SM2P256V1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n5 += 8);
            n5 += 8;
        }
        return new ECLookupTable(){

            public int getSize() {
                return n3;
            }

            public ECPoint lookup(int n2) {
                int[] nArray3 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n32 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = (i2 ^ n2) - 1 >> 31;
                    for (int i3 = 0; i3 < 8; ++i3) {
                        int n5 = i3;
                        nArray3[n5] = nArray3[n5] ^ nArray[n32 + i3] & n4;
                        int n6 = i3;
                        nArray2[n6] = nArray2[n6] ^ nArray[n32 + 8 + i3] & n4;
                    }
                    n32 += 16;
                }
                return SM2P256V1Curve.this.createRawPoint(new SM2P256V1FieldElement(nArray3), new SM2P256V1FieldElement(nArray2), false);
            }
        };
    }
}

