/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.security.SecureRandom;
import macromedia.db2util.externals.org.bouncycastle.crypto.BlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.KeyParameter;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithIV;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.ProtocolVersion;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsContext;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsFatalAlert;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsMac;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsUtils;
import macromedia.db2util.externals.org.bouncycastle.util.Arrays;

public class TlsBlockCipher
implements TlsCipher {
    protected TlsContext context;
    protected byte[] randomData;
    protected boolean useExplicitIV;
    protected boolean encryptThenMAC;
    protected BlockCipher encryptCipher;
    protected BlockCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsMac getWriteMac() {
        return this.writeMac;
    }

    public TlsMac getReadMac() {
        return this.readMac;
    }

    public TlsBlockCipher(TlsContext tlsContext, BlockCipher blockCipher, BlockCipher blockCipher2, Digest digest, Digest digest2, int n2) throws IOException {
        ParametersWithIV parametersWithIV;
        ParametersWithIV parametersWithIV2;
        byte[] byArray;
        byte[] byArray2;
        this.context = tlsContext;
        this.randomData = new byte[256];
        tlsContext.getNonceRandomGenerator().nextBytes(this.randomData);
        this.useExplicitIV = TlsUtils.isTLSv11(tlsContext);
        this.encryptThenMAC = tlsContext.getSecurityParameters().encryptThenMAC;
        int n3 = 2 * n2 + digest.getDigestSize() + digest2.getDigestSize();
        if (!this.useExplicitIV) {
            n3 += blockCipher.getBlockSize() + blockCipher2.getBlockSize();
        }
        byte[] byArray3 = TlsUtils.calculateKeyBlock(tlsContext, n3);
        int n4 = 0;
        TlsMac tlsMac = new TlsMac(tlsContext, digest, byArray3, n4, digest.getDigestSize());
        TlsMac tlsMac2 = new TlsMac(tlsContext, digest2, byArray3, n4 += digest.getDigestSize(), digest2.getDigestSize());
        KeyParameter keyParameter = new KeyParameter(byArray3, n4 += digest2.getDigestSize(), n2);
        KeyParameter keyParameter2 = new KeyParameter(byArray3, n4 += n2, n2);
        n4 += n2;
        if (this.useExplicitIV) {
            byArray2 = new byte[blockCipher.getBlockSize()];
            byArray = new byte[blockCipher2.getBlockSize()];
        } else {
            int n5 = n4;
            byArray2 = Arrays.copyOfRange(byArray3, n5, n5 + blockCipher.getBlockSize());
            int n6 = n4 += blockCipher.getBlockSize();
            byArray = Arrays.copyOfRange(byArray3, n6, n6 + blockCipher2.getBlockSize());
            n4 += blockCipher2.getBlockSize();
        }
        if (n4 != n3) {
            throw new TlsFatalAlert(80);
        }
        if (tlsContext.isServer()) {
            this.writeMac = tlsMac2;
            this.readMac = tlsMac;
            this.encryptCipher = blockCipher2;
            this.decryptCipher = blockCipher;
            parametersWithIV2 = new ParametersWithIV(keyParameter2, byArray);
            parametersWithIV = new ParametersWithIV(keyParameter, byArray2);
        } else {
            this.writeMac = tlsMac;
            this.readMac = tlsMac2;
            this.encryptCipher = blockCipher;
            this.decryptCipher = blockCipher2;
            parametersWithIV2 = new ParametersWithIV(keyParameter, byArray2);
            parametersWithIV = new ParametersWithIV(keyParameter2, byArray);
        }
        this.encryptCipher.init(true, parametersWithIV2);
        this.decryptCipher.init(false, parametersWithIV);
    }

    public int getPlaintextLimit(int n2) {
        int n3 = this.encryptCipher.getBlockSize();
        int n4 = this.writeMac.getSize();
        int n5 = n2;
        if (this.useExplicitIV) {
            n5 -= n3;
        }
        if (this.encryptThenMAC) {
            int n6 = n5 -= n4;
            n5 = n6 - n6 % n3;
        } else {
            int n7 = n5;
            n5 = n7 - n7 % n3;
            n5 -= n4;
        }
        return --n5;
    }

    public byte[] encodePlaintext(long l2, short s2, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.encryptCipher.getBlockSize();
        int n7 = this.writeMac.getSize();
        ProtocolVersion protocolVersion = this.context.getServerVersion();
        int n8 = n3;
        if (!this.encryptThenMAC) {
            n8 += n7;
        }
        int n9 = n6 - 1 - n8 % n6;
        if (!(!this.encryptThenMAC && this.context.getSecurityParameters().truncatedHMac || protocolVersion.isDTLS() || protocolVersion.isSSL())) {
            n5 = (255 - n9) / n6;
            TlsBlockCipher tlsBlockCipher = this;
            int n10 = tlsBlockCipher.chooseExtraPadBlocks(tlsBlockCipher.context.getSecureRandom(), n5);
            n9 += n10 * n6;
        }
        n5 = n3 + n7 + n9 + 1;
        if (this.useExplicitIV) {
            n5 += n6;
        }
        byte[] byArray2 = new byte[n5];
        int n11 = 0;
        if (this.useExplicitIV) {
            byte[] byArray3 = new byte[n6];
            this.context.getNonceRandomGenerator().nextBytes(byArray3);
            this.encryptCipher.init(true, new ParametersWithIV(null, byArray3));
            System.arraycopy(byArray3, 0, byArray2, n11, n6);
            n11 += n6;
        }
        int n12 = n11;
        System.arraycopy(byArray, n2, byArray2, n11, n3);
        n11 += n3;
        if (!this.encryptThenMAC) {
            byte[] byArray4 = this.writeMac.calculateMac(l2, s2, byArray, n2, n3);
            System.arraycopy(byArray4, 0, byArray2, n11, byArray4.length);
            n11 += byArray4.length;
        }
        for (n4 = 0; n4 <= n9; ++n4) {
            byArray2[n11++] = (byte)n9;
        }
        for (n4 = n12; n4 < n11; n4 += n6) {
            this.encryptCipher.processBlock(byArray2, n4, byArray2, n4);
        }
        if (this.encryptThenMAC) {
            byte[] byArray5 = this.writeMac.calculateMac(l2, s2, byArray2, 0, n11);
            System.arraycopy(byArray5, 0, byArray2, n11, byArray5.length);
            n11 += byArray5.length;
        }
        return byArray2;
    }

    public byte[] decodeCiphertext(long l2, short s2, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int n6 = this.decryptCipher.getBlockSize();
        int n7 = this.readMac.getSize();
        int n8 = n6;
        n8 = this.encryptThenMAC ? (n8 += n7) : Math.max(n8, n7 + 1);
        if (this.useExplicitIV) {
            n8 += n6;
        }
        if (n3 < n8) {
            throw new TlsFatalAlert(50);
        }
        int n9 = n3;
        if (this.encryptThenMAC) {
            n9 -= n7;
        }
        if (n9 % n6 != 0) {
            throw new TlsFatalAlert(21);
        }
        if (this.encryptThenMAC) {
            n5 = n2 + n3;
            byte[] byArray2 = Arrays.copyOfRange(byArray, n5 - n7, n5);
            byte[] byArray3 = this.readMac.calculateMac(l2, s2, byArray, n2, n3 - n7);
            int n10 = n4 = !Arrays.constantTimeAreEqual(byArray3, byArray2) ? 1 : 0;
            if (n4 != 0) {
                throw new TlsFatalAlert(20);
            }
        }
        if (this.useExplicitIV) {
            this.decryptCipher.init(false, new ParametersWithIV(null, byArray, n2, n6));
            n2 += n6;
            n9 -= n6;
        }
        for (n5 = 0; n5 < n9; n5 += n6) {
            this.decryptCipher.processBlock(byArray, n2 + n5, byArray, n2 + n5);
        }
        n5 = this.checkPaddingConstantTime(byArray, n2, n9, n6, this.encryptThenMAC ? 0 : n7);
        boolean bl = n5 == 0;
        int n11 = n9 - n5;
        if (!this.encryptThenMAC) {
            int n12;
            n4 = n11 -= n7;
            int n13 = n12 = n2 + n4;
            byte[] byArray4 = Arrays.copyOfRange(byArray, n13, n13 + n7);
            byte[] byArray5 = this.readMac.calculateMacConstantTime(l2, s2, byArray, n2, n4, n9 - n7, this.randomData);
            bl |= !Arrays.constantTimeAreEqual(byArray5, byArray4);
        }
        if (bl) {
            throw new TlsFatalAlert(20);
        }
        int n14 = n2;
        return Arrays.copyOfRange(byArray, n14, n14 + n11);
    }

    protected int checkPaddingConstantTime(byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6 = n2 + n3;
        byte by = byArray[n6 - 1];
        int n7 = by & 0xFF;
        int n8 = n7 + 1;
        int n9 = 0;
        int n10 = 0;
        if (TlsUtils.isSSL(this.context) && n8 > n4 || n5 + n8 > n3) {
            n8 = 0;
        } else {
            int n11 = n6 - n8;
            do {
                n10 = (byte)(n10 | byArray[n11++] ^ by);
            } while (n11 < n6);
            n9 = n8;
            if (n10 != 0) {
                n8 = 0;
            }
        }
        byte[] byArray2 = this.randomData;
        while (n9 < 256) {
            n10 = (byte)(n10 | byArray2[n9++] ^ by);
        }
        byArray2[0] = (byte)(byArray2[0] ^ n10);
        return n8;
    }

    protected int chooseExtraPadBlocks(SecureRandom secureRandom, int n2) {
        int n3 = secureRandom.nextInt();
        int n4 = this.lowestBitSet(n3);
        return Math.min(n4, n2);
    }

    protected int lowestBitSet(int n2) {
        if (n2 == 0) {
            return 32;
        }
        int n3 = 0;
        while ((n2 & 1) == 0) {
            ++n3;
            n2 >>= 1;
        }
        return n3;
    }
}

