/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsUtils;

public class ByteQueue {
    private static final int DEFAULT_CAPACITY = 1024;
    private byte[] databuf;
    private int skipped = 0;
    private int available = 0;
    private boolean readOnlyBuf = false;

    public static int nextTwoPow(int n2) {
        int n3 = n2;
        int n4 = n2 = n3 | n3 >> 1;
        int n5 = n2 = n4 | n4 >> 2;
        int n6 = n2 = n5 | n5 >> 4;
        int n7 = n2 = n6 | n6 >> 8;
        n2 = n7 | n7 >> 16;
        return n2 + 1;
    }

    public ByteQueue() {
        this(1024);
    }

    public ByteQueue(int n2) {
        this.databuf = n2 == 0 ? TlsUtils.EMPTY_BYTES : new byte[n2];
    }

    public ByteQueue(byte[] byArray, int n2, int n3) {
        this.databuf = byArray;
        this.skipped = n2;
        this.available = n3;
        this.readOnlyBuf = true;
    }

    public void addData(byte[] byArray, int n2, int n3) {
        if (this.readOnlyBuf) {
            throw new IllegalStateException("Cannot add data to read-only buffer");
        }
        if (this.skipped + this.available + n3 > this.databuf.length) {
            int n4 = ByteQueue.nextTwoPow(this.available + n3);
            if (n4 > this.databuf.length) {
                byte[] byArray2 = new byte[n4];
                System.arraycopy(this.databuf, this.skipped, byArray2, 0, this.available);
                this.databuf = byArray2;
            } else {
                System.arraycopy(this.databuf, this.skipped, this.databuf, 0, this.available);
            }
            this.skipped = 0;
        }
        System.arraycopy(byArray, n2, this.databuf, this.skipped + this.available, n3);
        this.available += n3;
    }

    public int available() {
        return this.available;
    }

    public void copyTo(OutputStream outputStream, int n2) throws IOException {
        if (n2 > this.available) {
            throw new IllegalStateException("Cannot copy " + n2 + " bytes, only got " + this.available);
        }
        outputStream.write(this.databuf, this.skipped, n2);
    }

    public void read(byte[] byArray, int n2, int n3, int n4) {
        if (byArray.length - n2 < n3) {
            throw new IllegalArgumentException("Buffer size of " + byArray.length + " is too small for a read of " + n3 + " bytes");
        }
        if (this.available - n4 < n3) {
            throw new IllegalStateException("Not enough data to read");
        }
        System.arraycopy(this.databuf, this.skipped + n4, byArray, n2, n3);
    }

    public ByteArrayInputStream readFrom(int n2) {
        if (n2 > this.available) {
            throw new IllegalStateException("Cannot read " + n2 + " bytes, only got " + this.available);
        }
        int n3 = this.skipped;
        this.available -= n2;
        this.skipped += n2;
        return new ByteArrayInputStream(this.databuf, n3, n2);
    }

    public void removeData(int n2) {
        if (n2 > this.available) {
            throw new IllegalStateException("Cannot remove " + n2 + " bytes, only got " + this.available);
        }
        this.available -= n2;
        this.skipped += n2;
    }

    public void removeData(byte[] byArray, int n2, int n3, int n4) {
        this.read(byArray, n2, n3, n4);
        this.removeData(n4 + n3);
    }

    public byte[] removeData(int n2, int n3) {
        byte[] byArray = new byte[n2];
        this.removeData(byArray, 0, n2, n3);
        return byArray;
    }

    public void shrink() {
        if (this.available == 0) {
            this.databuf = TlsUtils.EMPTY_BYTES;
            this.skipped = 0;
        } else {
            int n2 = ByteQueue.nextTwoPow(this.available);
            if (n2 < this.databuf.length) {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.databuf, this.skipped, byArray, 0, this.available);
                this.databuf = byArray;
                this.skipped = 0;
            }
        }
    }
}

