/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.tls;

import java.security.SecureRandom;
import macromedia.db2util.externals.org.bouncycastle.crypto.Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.prng.DigestRandomGenerator;
import macromedia.db2util.externals.org.bouncycastle.crypto.prng.RandomGenerator;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.ProtocolVersion;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.SecurityParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsContext;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsSession;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsUtils;
import macromedia.db2util.externals.org.bouncycastle.util.Times;

abstract class AbstractTlsContext
implements TlsContext {
    private static long counter = Times.nanoTime();
    private RandomGenerator nonceRandom;
    private SecureRandom secureRandom;
    private SecurityParameters securityParameters;
    private ProtocolVersion clientVersion = null;
    private ProtocolVersion serverVersion = null;
    private TlsSession session = null;
    private Object userObject = null;

    private static synchronized long nextCounterValue() {
        return ++counter;
    }

    AbstractTlsContext(SecureRandom secureRandom, SecurityParameters securityParameters) {
        Digest digest = TlsUtils.createHash((short)4);
        byte[] byArray = new byte[digest.getDigestSize()];
        secureRandom.nextBytes(byArray);
        this.nonceRandom = new DigestRandomGenerator(digest);
        this.nonceRandom.addSeedMaterial(AbstractTlsContext.nextCounterValue());
        this.nonceRandom.addSeedMaterial(Times.nanoTime());
        this.nonceRandom.addSeedMaterial(byArray);
        this.secureRandom = secureRandom;
        this.securityParameters = securityParameters;
    }

    public RandomGenerator getNonceRandomGenerator() {
        return this.nonceRandom;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public SecurityParameters getSecurityParameters() {
        return this.securityParameters;
    }

    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    final void setClientVersion(ProtocolVersion protocolVersion) {
        this.clientVersion = protocolVersion;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    final void setServerVersion(ProtocolVersion protocolVersion) {
        this.serverVersion = protocolVersion;
    }

    public TlsSession getResumableSession() {
        return this.session;
    }

    final void setResumableSession(TlsSession tlsSession) {
        this.session = tlsSession;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public byte[] exportKeyingMaterial(String string, byte[] byArray, int n2) {
        if (byArray != null && !TlsUtils.isValidUint16(byArray.length)) {
            throw new IllegalArgumentException("'context_value' must have length less than 2^16 (or be null)");
        }
        SecurityParameters securityParameters = this.getSecurityParameters();
        byte[] byArray2 = securityParameters.getClientRandom();
        byte[] byArray3 = securityParameters.getServerRandom();
        int n3 = byArray2.length + byArray3.length;
        if (byArray != null) {
            n3 += 2 + byArray.length;
        }
        byte[] byArray4 = new byte[n3];
        int n4 = 0;
        System.arraycopy(byArray2, 0, byArray4, n4, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, n4 += byArray2.length, byArray3.length);
        n4 += byArray3.length;
        if (byArray != null) {
            TlsUtils.writeUint16(byArray.length, byArray4, n4);
            System.arraycopy(byArray, 0, byArray4, n4 += 2, byArray.length);
            n4 += byArray.length;
        }
        if (n4 != n3) {
            throw new IllegalStateException("error in calculation of seed for export");
        }
        return TlsUtils.PRF(this, securityParameters.getMasterSecret(), string, byArray4, n2);
    }
}

