/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.modes;

import macromedia.db2util.externals.org.bouncycastle.crypto.BlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.db2util.externals.org.bouncycastle.crypto.StreamBlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.modes.GOST3413CipherUtil;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithIV;
import macromedia.db2util.externals.org.bouncycastle.util.Arrays;

public class G3413CTRBlockCipher
extends StreamBlockCipher {
    private final int s;
    private byte[] CTR;
    private byte[] IV;
    private byte[] buf;
    private final int blockSize;
    private final BlockCipher cipher;
    private int byteCount;
    private boolean initialized;

    public G3413CTRBlockCipher(BlockCipher blockCipher) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, blockCipher2.getBlockSize() << 3);
    }

    public G3413CTRBlockCipher(BlockCipher blockCipher, int n2) {
        super(blockCipher);
        this.byteCount = 0;
        if (n2 < 0 || n2 > blockCipher.getBlockSize() << 3) {
            throw new IllegalArgumentException("Parameter bitBlockSize must be in range 0 < bitBlockSize <= " + (blockCipher.getBlockSize() << 3));
        }
        this.cipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.s = n2 / 8;
        this.CTR = new byte[this.blockSize];
    }

    public void init(boolean bl, dda dda10) throws IllegalArgumentException {
        if (dda10 instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)dda10;
            this.initArrays();
            this.IV = Arrays.clone(parametersWithIV.getIV());
            if (this.IV.length != this.blockSize / 2) {
                throw new IllegalArgumentException("Parameter IV length must be == blockSize/2");
            }
            System.arraycopy(this.IV, 0, this.CTR, 0, this.IV.length);
            for (int i2 = this.IV.length; i2 < this.blockSize; ++i2) {
                this.CTR[i2] = 0;
            }
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.initArrays();
            if (dda10 != null) {
                this.cipher.init(true, dda10);
            }
        }
        this.initialized = true;
    }

    private final void initArrays() {
        this.IV = new byte[this.blockSize / 2];
        this.CTR = new byte[this.blockSize];
        this.buf = new byte[this.s];
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/GCTR";
    }

    public int getBlockSize() {
        return this.s;
    }

    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n2, this.s, byArray2, n3);
        return this.s;
    }

    protected byte calculateByte(byte by) {
        if (this.byteCount == 0) {
            this.buf = this.generateBuf();
        }
        byte by2 = (byte)(this.buf[this.byteCount] ^ by);
        ++this.byteCount;
        if (this.byteCount == this.s) {
            this.byteCount = 0;
            this.generateCRT();
        }
        return by2;
    }

    private final void generateCRT() {
        byte[] byArray = this.CTR;
        int n2 = this.CTR.length - 1;
        byArray[n2] = (byte)(byArray[n2] + 1);
    }

    private final byte[] generateBuf() {
        byte[] byArray = new byte[this.CTR.length];
        this.cipher.processBlock(this.CTR, 0, byArray, 0);
        return GOST3413CipherUtil.MSB(byArray, this.s);
    }

    public void reset() {
        if (this.initialized) {
            System.arraycopy(this.IV, 0, this.CTR, 0, this.IV.length);
            for (int i2 = this.IV.length; i2 < this.blockSize; ++i2) {
                this.CTR[i2] = 0;
            }
            this.byteCount = 0;
            this.cipher.reset();
        }
    }
}

