/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.engines;

import macromedia.db2util.externals.org.bouncycastle.crypto.engines.SerpentEngineBase;
import macromedia.db2util.externals.org.bouncycastle.util.Pack;

public final class TnepresEngine
extends SerpentEngineBase {
    public String getAlgorithmName() {
        return "Tnepres";
    }

    protected int[] makeWorkingKey(byte[] byArray) throws IllegalArgumentException {
        int n2;
        int[] nArray = new int[16];
        int n3 = 0;
        int n4 = 0;
        for (n3 = byArray.length - 4; n3 > 0; n3 -= 4) {
            nArray[n4++] = Pack.bigEndianToInt(byArray, n3);
        }
        if (n3 == 0) {
            nArray[n4++] = Pack.bigEndianToInt(byArray, 0);
            if (n4 < 8) {
                nArray[n4] = 1;
            }
        } else {
            throw new IllegalArgumentException("key must be a multiple of 4 bytes");
        }
        int n5 = 132;
        int[] nArray2 = new int[n5];
        for (n2 = 8; n2 < 16; ++n2) {
            nArray[n2] = TnepresEngine.rotateLeft(nArray[n2 - 8] ^ nArray[n2 - 5] ^ nArray[n2 - 3] ^ nArray[n2 - 1] ^ 0x9E3779B9 ^ n2 - 8, 11);
        }
        System.arraycopy(nArray, 8, nArray2, 0, 8);
        for (n2 = 8; n2 < n5; ++n2) {
            nArray2[n2] = TnepresEngine.rotateLeft(nArray2[n2 - 8] ^ nArray2[n2 - 5] ^ nArray2[n2 - 3] ^ nArray2[n2 - 1] ^ 0x9E3779B9 ^ n2, 11);
        }
        this.sb3(nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
        nArray2[0] = this.X0;
        nArray2[1] = this.X1;
        nArray2[2] = this.X2;
        nArray2[3] = this.X3;
        this.sb2(nArray2[4], nArray2[5], nArray2[6], nArray2[7]);
        nArray2[4] = this.X0;
        nArray2[5] = this.X1;
        nArray2[6] = this.X2;
        nArray2[7] = this.X3;
        this.sb1(nArray2[8], nArray2[9], nArray2[10], nArray2[11]);
        nArray2[8] = this.X0;
        nArray2[9] = this.X1;
        nArray2[10] = this.X2;
        nArray2[11] = this.X3;
        this.sb0(nArray2[12], nArray2[13], nArray2[14], nArray2[15]);
        nArray2[12] = this.X0;
        nArray2[13] = this.X1;
        nArray2[14] = this.X2;
        nArray2[15] = this.X3;
        this.sb7(nArray2[16], nArray2[17], nArray2[18], nArray2[19]);
        nArray2[16] = this.X0;
        nArray2[17] = this.X1;
        nArray2[18] = this.X2;
        nArray2[19] = this.X3;
        this.sb6(nArray2[20], nArray2[21], nArray2[22], nArray2[23]);
        nArray2[20] = this.X0;
        nArray2[21] = this.X1;
        nArray2[22] = this.X2;
        nArray2[23] = this.X3;
        this.sb5(nArray2[24], nArray2[25], nArray2[26], nArray2[27]);
        nArray2[24] = this.X0;
        nArray2[25] = this.X1;
        nArray2[26] = this.X2;
        nArray2[27] = this.X3;
        this.sb4(nArray2[28], nArray2[29], nArray2[30], nArray2[31]);
        nArray2[28] = this.X0;
        nArray2[29] = this.X1;
        nArray2[30] = this.X2;
        nArray2[31] = this.X3;
        this.sb3(nArray2[32], nArray2[33], nArray2[34], nArray2[35]);
        nArray2[32] = this.X0;
        nArray2[33] = this.X1;
        nArray2[34] = this.X2;
        nArray2[35] = this.X3;
        this.sb2(nArray2[36], nArray2[37], nArray2[38], nArray2[39]);
        nArray2[36] = this.X0;
        nArray2[37] = this.X1;
        nArray2[38] = this.X2;
        nArray2[39] = this.X3;
        this.sb1(nArray2[40], nArray2[41], nArray2[42], nArray2[43]);
        nArray2[40] = this.X0;
        nArray2[41] = this.X1;
        nArray2[42] = this.X2;
        nArray2[43] = this.X3;
        this.sb0(nArray2[44], nArray2[45], nArray2[46], nArray2[47]);
        nArray2[44] = this.X0;
        nArray2[45] = this.X1;
        nArray2[46] = this.X2;
        nArray2[47] = this.X3;
        this.sb7(nArray2[48], nArray2[49], nArray2[50], nArray2[51]);
        nArray2[48] = this.X0;
        nArray2[49] = this.X1;
        nArray2[50] = this.X2;
        nArray2[51] = this.X3;
        this.sb6(nArray2[52], nArray2[53], nArray2[54], nArray2[55]);
        nArray2[52] = this.X0;
        nArray2[53] = this.X1;
        nArray2[54] = this.X2;
        nArray2[55] = this.X3;
        this.sb5(nArray2[56], nArray2[57], nArray2[58], nArray2[59]);
        nArray2[56] = this.X0;
        nArray2[57] = this.X1;
        nArray2[58] = this.X2;
        nArray2[59] = this.X3;
        this.sb4(nArray2[60], nArray2[61], nArray2[62], nArray2[63]);
        nArray2[60] = this.X0;
        nArray2[61] = this.X1;
        nArray2[62] = this.X2;
        nArray2[63] = this.X3;
        this.sb3(nArray2[64], nArray2[65], nArray2[66], nArray2[67]);
        nArray2[64] = this.X0;
        nArray2[65] = this.X1;
        nArray2[66] = this.X2;
        nArray2[67] = this.X3;
        this.sb2(nArray2[68], nArray2[69], nArray2[70], nArray2[71]);
        nArray2[68] = this.X0;
        nArray2[69] = this.X1;
        nArray2[70] = this.X2;
        nArray2[71] = this.X3;
        this.sb1(nArray2[72], nArray2[73], nArray2[74], nArray2[75]);
        nArray2[72] = this.X0;
        nArray2[73] = this.X1;
        nArray2[74] = this.X2;
        nArray2[75] = this.X3;
        this.sb0(nArray2[76], nArray2[77], nArray2[78], nArray2[79]);
        nArray2[76] = this.X0;
        nArray2[77] = this.X1;
        nArray2[78] = this.X2;
        nArray2[79] = this.X3;
        this.sb7(nArray2[80], nArray2[81], nArray2[82], nArray2[83]);
        nArray2[80] = this.X0;
        nArray2[81] = this.X1;
        nArray2[82] = this.X2;
        nArray2[83] = this.X3;
        this.sb6(nArray2[84], nArray2[85], nArray2[86], nArray2[87]);
        nArray2[84] = this.X0;
        nArray2[85] = this.X1;
        nArray2[86] = this.X2;
        nArray2[87] = this.X3;
        this.sb5(nArray2[88], nArray2[89], nArray2[90], nArray2[91]);
        nArray2[88] = this.X0;
        nArray2[89] = this.X1;
        nArray2[90] = this.X2;
        nArray2[91] = this.X3;
        this.sb4(nArray2[92], nArray2[93], nArray2[94], nArray2[95]);
        nArray2[92] = this.X0;
        nArray2[93] = this.X1;
        nArray2[94] = this.X2;
        nArray2[95] = this.X3;
        this.sb3(nArray2[96], nArray2[97], nArray2[98], nArray2[99]);
        nArray2[96] = this.X0;
        nArray2[97] = this.X1;
        nArray2[98] = this.X2;
        nArray2[99] = this.X3;
        this.sb2(nArray2[100], nArray2[101], nArray2[102], nArray2[103]);
        nArray2[100] = this.X0;
        nArray2[101] = this.X1;
        nArray2[102] = this.X2;
        nArray2[103] = this.X3;
        this.sb1(nArray2[104], nArray2[105], nArray2[106], nArray2[107]);
        nArray2[104] = this.X0;
        nArray2[105] = this.X1;
        nArray2[106] = this.X2;
        nArray2[107] = this.X3;
        this.sb0(nArray2[108], nArray2[109], nArray2[110], nArray2[111]);
        nArray2[108] = this.X0;
        nArray2[109] = this.X1;
        nArray2[110] = this.X2;
        nArray2[111] = this.X3;
        this.sb7(nArray2[112], nArray2[113], nArray2[114], nArray2[115]);
        nArray2[112] = this.X0;
        nArray2[113] = this.X1;
        nArray2[114] = this.X2;
        nArray2[115] = this.X3;
        this.sb6(nArray2[116], nArray2[117], nArray2[118], nArray2[119]);
        nArray2[116] = this.X0;
        nArray2[117] = this.X1;
        nArray2[118] = this.X2;
        nArray2[119] = this.X3;
        this.sb5(nArray2[120], nArray2[121], nArray2[122], nArray2[123]);
        nArray2[120] = this.X0;
        nArray2[121] = this.X1;
        nArray2[122] = this.X2;
        nArray2[123] = this.X3;
        this.sb4(nArray2[124], nArray2[125], nArray2[126], nArray2[127]);
        nArray2[124] = this.X0;
        nArray2[125] = this.X1;
        nArray2[126] = this.X2;
        nArray2[127] = this.X3;
        this.sb3(nArray2[128], nArray2[129], nArray2[130], nArray2[131]);
        nArray2[128] = this.X0;
        nArray2[129] = this.X1;
        nArray2[130] = this.X2;
        nArray2[131] = this.X3;
        return nArray2;
    }

    protected void encryptBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        this.X3 = Pack.bigEndianToInt(byArray, n2);
        this.X2 = Pack.bigEndianToInt(byArray, n2 + 4);
        this.X1 = Pack.bigEndianToInt(byArray, n2 + 8);
        this.X0 = Pack.bigEndianToInt(byArray, n2 + 12);
        TnepresEngine tnepresEngine = this;
        tnepresEngine.sb0(tnepresEngine.wKey[0] ^ this.X0, this.wKey[1] ^ this.X1, this.wKey[2] ^ this.X2, this.wKey[3] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine2 = this;
        tnepresEngine2.sb1(tnepresEngine2.wKey[4] ^ this.X0, this.wKey[5] ^ this.X1, this.wKey[6] ^ this.X2, this.wKey[7] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine3 = this;
        tnepresEngine3.sb2(tnepresEngine3.wKey[8] ^ this.X0, this.wKey[9] ^ this.X1, this.wKey[10] ^ this.X2, this.wKey[11] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine4 = this;
        tnepresEngine4.sb3(tnepresEngine4.wKey[12] ^ this.X0, this.wKey[13] ^ this.X1, this.wKey[14] ^ this.X2, this.wKey[15] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine5 = this;
        tnepresEngine5.sb4(tnepresEngine5.wKey[16] ^ this.X0, this.wKey[17] ^ this.X1, this.wKey[18] ^ this.X2, this.wKey[19] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine6 = this;
        tnepresEngine6.sb5(tnepresEngine6.wKey[20] ^ this.X0, this.wKey[21] ^ this.X1, this.wKey[22] ^ this.X2, this.wKey[23] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine7 = this;
        tnepresEngine7.sb6(tnepresEngine7.wKey[24] ^ this.X0, this.wKey[25] ^ this.X1, this.wKey[26] ^ this.X2, this.wKey[27] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine8 = this;
        tnepresEngine8.sb7(tnepresEngine8.wKey[28] ^ this.X0, this.wKey[29] ^ this.X1, this.wKey[30] ^ this.X2, this.wKey[31] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine9 = this;
        tnepresEngine9.sb0(tnepresEngine9.wKey[32] ^ this.X0, this.wKey[33] ^ this.X1, this.wKey[34] ^ this.X2, this.wKey[35] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine10 = this;
        tnepresEngine10.sb1(tnepresEngine10.wKey[36] ^ this.X0, this.wKey[37] ^ this.X1, this.wKey[38] ^ this.X2, this.wKey[39] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine11 = this;
        tnepresEngine11.sb2(tnepresEngine11.wKey[40] ^ this.X0, this.wKey[41] ^ this.X1, this.wKey[42] ^ this.X2, this.wKey[43] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine12 = this;
        tnepresEngine12.sb3(tnepresEngine12.wKey[44] ^ this.X0, this.wKey[45] ^ this.X1, this.wKey[46] ^ this.X2, this.wKey[47] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine13 = this;
        tnepresEngine13.sb4(tnepresEngine13.wKey[48] ^ this.X0, this.wKey[49] ^ this.X1, this.wKey[50] ^ this.X2, this.wKey[51] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine14 = this;
        tnepresEngine14.sb5(tnepresEngine14.wKey[52] ^ this.X0, this.wKey[53] ^ this.X1, this.wKey[54] ^ this.X2, this.wKey[55] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine15 = this;
        tnepresEngine15.sb6(tnepresEngine15.wKey[56] ^ this.X0, this.wKey[57] ^ this.X1, this.wKey[58] ^ this.X2, this.wKey[59] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine16 = this;
        tnepresEngine16.sb7(tnepresEngine16.wKey[60] ^ this.X0, this.wKey[61] ^ this.X1, this.wKey[62] ^ this.X2, this.wKey[63] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine17 = this;
        tnepresEngine17.sb0(tnepresEngine17.wKey[64] ^ this.X0, this.wKey[65] ^ this.X1, this.wKey[66] ^ this.X2, this.wKey[67] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine18 = this;
        tnepresEngine18.sb1(tnepresEngine18.wKey[68] ^ this.X0, this.wKey[69] ^ this.X1, this.wKey[70] ^ this.X2, this.wKey[71] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine19 = this;
        tnepresEngine19.sb2(tnepresEngine19.wKey[72] ^ this.X0, this.wKey[73] ^ this.X1, this.wKey[74] ^ this.X2, this.wKey[75] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine20 = this;
        tnepresEngine20.sb3(tnepresEngine20.wKey[76] ^ this.X0, this.wKey[77] ^ this.X1, this.wKey[78] ^ this.X2, this.wKey[79] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine21 = this;
        tnepresEngine21.sb4(tnepresEngine21.wKey[80] ^ this.X0, this.wKey[81] ^ this.X1, this.wKey[82] ^ this.X2, this.wKey[83] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine22 = this;
        tnepresEngine22.sb5(tnepresEngine22.wKey[84] ^ this.X0, this.wKey[85] ^ this.X1, this.wKey[86] ^ this.X2, this.wKey[87] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine23 = this;
        tnepresEngine23.sb6(tnepresEngine23.wKey[88] ^ this.X0, this.wKey[89] ^ this.X1, this.wKey[90] ^ this.X2, this.wKey[91] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine24 = this;
        tnepresEngine24.sb7(tnepresEngine24.wKey[92] ^ this.X0, this.wKey[93] ^ this.X1, this.wKey[94] ^ this.X2, this.wKey[95] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine25 = this;
        tnepresEngine25.sb0(tnepresEngine25.wKey[96] ^ this.X0, this.wKey[97] ^ this.X1, this.wKey[98] ^ this.X2, this.wKey[99] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine26 = this;
        tnepresEngine26.sb1(tnepresEngine26.wKey[100] ^ this.X0, this.wKey[101] ^ this.X1, this.wKey[102] ^ this.X2, this.wKey[103] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine27 = this;
        tnepresEngine27.sb2(tnepresEngine27.wKey[104] ^ this.X0, this.wKey[105] ^ this.X1, this.wKey[106] ^ this.X2, this.wKey[107] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine28 = this;
        tnepresEngine28.sb3(tnepresEngine28.wKey[108] ^ this.X0, this.wKey[109] ^ this.X1, this.wKey[110] ^ this.X2, this.wKey[111] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine29 = this;
        tnepresEngine29.sb4(tnepresEngine29.wKey[112] ^ this.X0, this.wKey[113] ^ this.X1, this.wKey[114] ^ this.X2, this.wKey[115] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine30 = this;
        tnepresEngine30.sb5(tnepresEngine30.wKey[116] ^ this.X0, this.wKey[117] ^ this.X1, this.wKey[118] ^ this.X2, this.wKey[119] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine31 = this;
        tnepresEngine31.sb6(tnepresEngine31.wKey[120] ^ this.X0, this.wKey[121] ^ this.X1, this.wKey[122] ^ this.X2, this.wKey[123] ^ this.X3);
        this.LT();
        TnepresEngine tnepresEngine32 = this;
        tnepresEngine32.sb7(tnepresEngine32.wKey[124] ^ this.X0, this.wKey[125] ^ this.X1, this.wKey[126] ^ this.X2, this.wKey[127] ^ this.X3);
        Pack.intToBigEndian(this.wKey[131] ^ this.X3, byArray2, n3);
        Pack.intToBigEndian(this.wKey[130] ^ this.X2, byArray2, n3 + 4);
        Pack.intToBigEndian(this.wKey[129] ^ this.X1, byArray2, n3 + 8);
        Pack.intToBigEndian(this.wKey[128] ^ this.X0, byArray2, n3 + 12);
    }

    protected void decryptBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        this.X3 = this.wKey[131] ^ Pack.bigEndianToInt(byArray, n2);
        this.X2 = this.wKey[130] ^ Pack.bigEndianToInt(byArray, n2 + 4);
        this.X1 = this.wKey[129] ^ Pack.bigEndianToInt(byArray, n2 + 8);
        this.X0 = this.wKey[128] ^ Pack.bigEndianToInt(byArray, n2 + 12);
        TnepresEngine tnepresEngine = this;
        tnepresEngine.ib7(tnepresEngine.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[124];
        this.X1 ^= this.wKey[125];
        this.X2 ^= this.wKey[126];
        this.X3 ^= this.wKey[127];
        this.inverseLT();
        TnepresEngine tnepresEngine2 = this;
        tnepresEngine2.ib6(tnepresEngine2.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[120];
        this.X1 ^= this.wKey[121];
        this.X2 ^= this.wKey[122];
        this.X3 ^= this.wKey[123];
        this.inverseLT();
        TnepresEngine tnepresEngine3 = this;
        tnepresEngine3.ib5(tnepresEngine3.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[116];
        this.X1 ^= this.wKey[117];
        this.X2 ^= this.wKey[118];
        this.X3 ^= this.wKey[119];
        this.inverseLT();
        TnepresEngine tnepresEngine4 = this;
        tnepresEngine4.ib4(tnepresEngine4.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[112];
        this.X1 ^= this.wKey[113];
        this.X2 ^= this.wKey[114];
        this.X3 ^= this.wKey[115];
        this.inverseLT();
        TnepresEngine tnepresEngine5 = this;
        tnepresEngine5.ib3(tnepresEngine5.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[108];
        this.X1 ^= this.wKey[109];
        this.X2 ^= this.wKey[110];
        this.X3 ^= this.wKey[111];
        this.inverseLT();
        TnepresEngine tnepresEngine6 = this;
        tnepresEngine6.ib2(tnepresEngine6.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[104];
        this.X1 ^= this.wKey[105];
        this.X2 ^= this.wKey[106];
        this.X3 ^= this.wKey[107];
        this.inverseLT();
        TnepresEngine tnepresEngine7 = this;
        tnepresEngine7.ib1(tnepresEngine7.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[100];
        this.X1 ^= this.wKey[101];
        this.X2 ^= this.wKey[102];
        this.X3 ^= this.wKey[103];
        this.inverseLT();
        TnepresEngine tnepresEngine8 = this;
        tnepresEngine8.ib0(tnepresEngine8.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[96];
        this.X1 ^= this.wKey[97];
        this.X2 ^= this.wKey[98];
        this.X3 ^= this.wKey[99];
        this.inverseLT();
        TnepresEngine tnepresEngine9 = this;
        tnepresEngine9.ib7(tnepresEngine9.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[92];
        this.X1 ^= this.wKey[93];
        this.X2 ^= this.wKey[94];
        this.X3 ^= this.wKey[95];
        this.inverseLT();
        TnepresEngine tnepresEngine10 = this;
        tnepresEngine10.ib6(tnepresEngine10.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[88];
        this.X1 ^= this.wKey[89];
        this.X2 ^= this.wKey[90];
        this.X3 ^= this.wKey[91];
        this.inverseLT();
        TnepresEngine tnepresEngine11 = this;
        tnepresEngine11.ib5(tnepresEngine11.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[84];
        this.X1 ^= this.wKey[85];
        this.X2 ^= this.wKey[86];
        this.X3 ^= this.wKey[87];
        this.inverseLT();
        TnepresEngine tnepresEngine12 = this;
        tnepresEngine12.ib4(tnepresEngine12.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[80];
        this.X1 ^= this.wKey[81];
        this.X2 ^= this.wKey[82];
        this.X3 ^= this.wKey[83];
        this.inverseLT();
        TnepresEngine tnepresEngine13 = this;
        tnepresEngine13.ib3(tnepresEngine13.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[76];
        this.X1 ^= this.wKey[77];
        this.X2 ^= this.wKey[78];
        this.X3 ^= this.wKey[79];
        this.inverseLT();
        TnepresEngine tnepresEngine14 = this;
        tnepresEngine14.ib2(tnepresEngine14.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[72];
        this.X1 ^= this.wKey[73];
        this.X2 ^= this.wKey[74];
        this.X3 ^= this.wKey[75];
        this.inverseLT();
        TnepresEngine tnepresEngine15 = this;
        tnepresEngine15.ib1(tnepresEngine15.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[68];
        this.X1 ^= this.wKey[69];
        this.X2 ^= this.wKey[70];
        this.X3 ^= this.wKey[71];
        this.inverseLT();
        TnepresEngine tnepresEngine16 = this;
        tnepresEngine16.ib0(tnepresEngine16.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[64];
        this.X1 ^= this.wKey[65];
        this.X2 ^= this.wKey[66];
        this.X3 ^= this.wKey[67];
        this.inverseLT();
        TnepresEngine tnepresEngine17 = this;
        tnepresEngine17.ib7(tnepresEngine17.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[60];
        this.X1 ^= this.wKey[61];
        this.X2 ^= this.wKey[62];
        this.X3 ^= this.wKey[63];
        this.inverseLT();
        TnepresEngine tnepresEngine18 = this;
        tnepresEngine18.ib6(tnepresEngine18.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[56];
        this.X1 ^= this.wKey[57];
        this.X2 ^= this.wKey[58];
        this.X3 ^= this.wKey[59];
        this.inverseLT();
        TnepresEngine tnepresEngine19 = this;
        tnepresEngine19.ib5(tnepresEngine19.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[52];
        this.X1 ^= this.wKey[53];
        this.X2 ^= this.wKey[54];
        this.X3 ^= this.wKey[55];
        this.inverseLT();
        TnepresEngine tnepresEngine20 = this;
        tnepresEngine20.ib4(tnepresEngine20.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[48];
        this.X1 ^= this.wKey[49];
        this.X2 ^= this.wKey[50];
        this.X3 ^= this.wKey[51];
        this.inverseLT();
        TnepresEngine tnepresEngine21 = this;
        tnepresEngine21.ib3(tnepresEngine21.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[44];
        this.X1 ^= this.wKey[45];
        this.X2 ^= this.wKey[46];
        this.X3 ^= this.wKey[47];
        this.inverseLT();
        TnepresEngine tnepresEngine22 = this;
        tnepresEngine22.ib2(tnepresEngine22.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[40];
        this.X1 ^= this.wKey[41];
        this.X2 ^= this.wKey[42];
        this.X3 ^= this.wKey[43];
        this.inverseLT();
        TnepresEngine tnepresEngine23 = this;
        tnepresEngine23.ib1(tnepresEngine23.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[36];
        this.X1 ^= this.wKey[37];
        this.X2 ^= this.wKey[38];
        this.X3 ^= this.wKey[39];
        this.inverseLT();
        TnepresEngine tnepresEngine24 = this;
        tnepresEngine24.ib0(tnepresEngine24.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[32];
        this.X1 ^= this.wKey[33];
        this.X2 ^= this.wKey[34];
        this.X3 ^= this.wKey[35];
        this.inverseLT();
        TnepresEngine tnepresEngine25 = this;
        tnepresEngine25.ib7(tnepresEngine25.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[28];
        this.X1 ^= this.wKey[29];
        this.X2 ^= this.wKey[30];
        this.X3 ^= this.wKey[31];
        this.inverseLT();
        TnepresEngine tnepresEngine26 = this;
        tnepresEngine26.ib6(tnepresEngine26.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[24];
        this.X1 ^= this.wKey[25];
        this.X2 ^= this.wKey[26];
        this.X3 ^= this.wKey[27];
        this.inverseLT();
        TnepresEngine tnepresEngine27 = this;
        tnepresEngine27.ib5(tnepresEngine27.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[20];
        this.X1 ^= this.wKey[21];
        this.X2 ^= this.wKey[22];
        this.X3 ^= this.wKey[23];
        this.inverseLT();
        TnepresEngine tnepresEngine28 = this;
        tnepresEngine28.ib4(tnepresEngine28.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[16];
        this.X1 ^= this.wKey[17];
        this.X2 ^= this.wKey[18];
        this.X3 ^= this.wKey[19];
        this.inverseLT();
        TnepresEngine tnepresEngine29 = this;
        tnepresEngine29.ib3(tnepresEngine29.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[12];
        this.X1 ^= this.wKey[13];
        this.X2 ^= this.wKey[14];
        this.X3 ^= this.wKey[15];
        this.inverseLT();
        TnepresEngine tnepresEngine30 = this;
        tnepresEngine30.ib2(tnepresEngine30.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[8];
        this.X1 ^= this.wKey[9];
        this.X2 ^= this.wKey[10];
        this.X3 ^= this.wKey[11];
        this.inverseLT();
        TnepresEngine tnepresEngine31 = this;
        tnepresEngine31.ib1(tnepresEngine31.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[4];
        this.X1 ^= this.wKey[5];
        this.X2 ^= this.wKey[6];
        this.X3 ^= this.wKey[7];
        this.inverseLT();
        TnepresEngine tnepresEngine32 = this;
        tnepresEngine32.ib0(tnepresEngine32.X0, this.X1, this.X2, this.X3);
        Pack.intToBigEndian(this.X3 ^ this.wKey[3], byArray2, n3);
        Pack.intToBigEndian(this.X2 ^ this.wKey[2], byArray2, n3 + 4);
        Pack.intToBigEndian(this.X1 ^ this.wKey[1], byArray2, n3 + 8);
        Pack.intToBigEndian(this.X0 ^ this.wKey[0], byArray2, n3 + 12);
    }
}

