/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.engines;

import macromedia.db2util.externals.org.bouncycastle.crypto.InvalidCipherTextException;
import macromedia.db2util.externals.org.bouncycastle.crypto.Wrapper;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.engines.GOST28147Engine;
import macromedia.db2util.externals.org.bouncycastle.crypto.macs.GOST28147Mac;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.KeyParameter;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithIV;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithSBox;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithUKM;
import macromedia.db2util.externals.org.bouncycastle.util.Arrays;

public class GOST28147WrapEngine
implements Wrapper {
    private GOST28147Engine cipher = new GOST28147Engine();
    private GOST28147Mac mac = new GOST28147Mac();

    public void init(boolean bl, dda dda10) {
        dda dda11;
        if (dda10 instanceof ParametersWithRandom) {
            dda11 = (ParametersWithRandom)dda10;
            dda10 = ((ParametersWithRandom)dda11).getParameters();
        }
        dda11 = (ParametersWithUKM)dda10;
        this.cipher.init(bl, ((ParametersWithUKM)dda11).getParameters());
        KeyParameter keyParameter = ((ParametersWithUKM)dda11).getParameters() instanceof ParametersWithSBox ? (KeyParameter)((ParametersWithSBox)((ParametersWithUKM)dda11).getParameters()).getParameters() : (KeyParameter)((ParametersWithUKM)dda11).getParameters();
        this.mac.init(new ParametersWithIV(keyParameter, ((ParametersWithUKM)dda11).getUKM()));
    }

    public String getAlgorithmName() {
        return "GOST28147Wrap";
    }

    public byte[] wrap(byte[] byArray, int n2, int n3) {
        this.mac.update(byArray, n2, n3);
        byte[] byArray2 = new byte[n3 + this.mac.getMacSize()];
        this.cipher.processBlock(byArray, n2, byArray2, 0);
        this.cipher.processBlock(byArray, n2 + 8, byArray2, 8);
        this.cipher.processBlock(byArray, n2 + 16, byArray2, 16);
        this.cipher.processBlock(byArray, n2 + 24, byArray2, 24);
        this.mac.doFinal(byArray2, n3);
        return byArray2;
    }

    public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte[] byArray2 = new byte[n3 - this.mac.getMacSize()];
        this.cipher.processBlock(byArray, n2, byArray2, 0);
        this.cipher.processBlock(byArray, n2 + 8, byArray2, 8);
        this.cipher.processBlock(byArray, n2 + 16, byArray2, 16);
        this.cipher.processBlock(byArray, n2 + 24, byArray2, 24);
        byte[] byArray3 = new byte[this.mac.getMacSize()];
        this.mac.update(byArray2, 0, byArray2.length);
        this.mac.doFinal(byArray3, 0);
        byte[] byArray4 = new byte[this.mac.getMacSize()];
        System.arraycopy(byArray, n2 + n3 - 4, byArray4, 0, this.mac.getMacSize());
        if (!Arrays.constantTimeAreEqual(byArray3, byArray4)) {
            throw new IllegalStateException("mac mismatch");
        }
        return byArray2;
    }
}

