/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1BitString;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Boolean;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1EncodableVector;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Enumerated;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Exception;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1GeneralizedTime;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Integer;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1OctetString;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1StreamParser;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1UTCTime;
import macromedia.db2util.externals.org.bouncycastle.asn1.BERApplicationSpecificParser;
import macromedia.db2util.externals.org.bouncycastle.asn1.BEROctetString;
import macromedia.db2util.externals.org.bouncycastle.asn1.BEROctetStringParser;
import macromedia.db2util.externals.org.bouncycastle.asn1.BERSequenceParser;
import macromedia.db2util.externals.org.bouncycastle.asn1.BERSetParser;
import macromedia.db2util.externals.org.bouncycastle.asn1.BERTaggedObjectParser;
import macromedia.db2util.externals.org.bouncycastle.asn1.BERTags;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERApplicationSpecific;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERBMPString;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERExternal;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERExternalParser;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERFactory;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERGeneralString;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERGraphicString;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERIA5String;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERNull;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERNumericString;
import macromedia.db2util.externals.org.bouncycastle.asn1.DEROctetString;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERPrintableString;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERT61String;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERUTF8String;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERUniversalString;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERVideotexString;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERVisibleString;
import macromedia.db2util.externals.org.bouncycastle.asn1.DefiniteLengthInputStream;
import macromedia.db2util.externals.org.bouncycastle.asn1.IndefiniteLengthInputStream;
import macromedia.db2util.externals.org.bouncycastle.asn1.LazyEncodedSequence;
import macromedia.db2util.externals.org.bouncycastle.asn1.StreamUtil;
import macromedia.db2util.externals.org.bouncycastle.util.io.Streams;

public class ASN1InputStream
extends FilterInputStream
implements BERTags {
    private final int limit;
    private final boolean lazyEvaluate;
    private final byte[][] tmpBuffers;

    public ASN1InputStream(InputStream inputStream) {
        InputStream inputStream2 = inputStream;
        this(inputStream2, StreamUtil.findLimit(inputStream2));
    }

    public ASN1InputStream(byte[] byArray) {
        this((InputStream)new ByteArrayInputStream(byArray), byArray.length);
    }

    public ASN1InputStream(byte[] byArray, boolean bl) {
        this(new ByteArrayInputStream(byArray), byArray.length, bl);
    }

    public ASN1InputStream(InputStream inputStream, int n2) {
        this(inputStream, n2, false);
    }

    public ASN1InputStream(InputStream inputStream, boolean bl) {
        InputStream inputStream2 = inputStream;
        this(inputStream2, StreamUtil.findLimit(inputStream2), bl);
    }

    public ASN1InputStream(InputStream inputStream, int n2, boolean bl) {
        super(inputStream);
        this.limit = n2;
        this.lazyEvaluate = bl;
        this.tmpBuffers = new byte[11][];
    }

    final int getLimit() {
        return this.limit;
    }

    protected int readLength() throws IOException {
        ASN1InputStream aSN1InputStream = this;
        return ASN1InputStream.readLength(aSN1InputStream, aSN1InputStream.limit);
    }

    protected void readFully(byte[] byArray) throws IOException {
        if (Streams.readFully(this, byArray) != byArray.length) {
            throw new EOFException("EOF encountered in middle of object");
        }
    }

    protected ASN1Primitive buildObject(int n2, int n3, int n4) throws IOException {
        boolean bl = (n2 & 0x20) != 0;
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this, n4);
        if ((n2 & 0x40) != 0) {
            return new DERApplicationSpecific(bl, n3, definiteLengthInputStream.toByteArray());
        }
        if ((n2 & 0x80) != 0) {
            return new ASN1StreamParser(definiteLengthInputStream).readTaggedObject(bl, n3);
        }
        if (bl) {
            switch (n3) {
                case 4: {
                    ASN1EncodableVector aSN1EncodableVector = this.buildDEREncodableVector(definiteLengthInputStream);
                    ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[aSN1EncodableVector.size()];
                    for (int i2 = 0; i2 != aSN1OctetStringArray.length; ++i2) {
                        aSN1OctetStringArray[i2] = (ASN1OctetString)aSN1EncodableVector.get(i2);
                    }
                    return new BEROctetString(aSN1OctetStringArray);
                }
                case 16: {
                    if (this.lazyEvaluate) {
                        return new LazyEncodedSequence(definiteLengthInputStream.toByteArray());
                    }
                    return DERFactory.createSequence(this.buildDEREncodableVector(definiteLengthInputStream));
                }
                case 17: {
                    return DERFactory.createSet(this.buildDEREncodableVector(definiteLengthInputStream));
                }
                case 8: {
                    return new DERExternal(this.buildDEREncodableVector(definiteLengthInputStream));
                }
            }
            throw new IOException("unknown tag " + n3 + " encountered");
        }
        return ASN1InputStream.createPrimitiveDERObject(n3, definiteLengthInputStream, this.tmpBuffers);
    }

    final ASN1EncodableVector buildEncodableVector() throws IOException {
        ASN1Primitive aSN1Primitive;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while ((aSN1Primitive = this.readObject()) != null) {
            aSN1EncodableVector.add(aSN1Primitive);
        }
        return aSN1EncodableVector;
    }

    final ASN1EncodableVector buildDEREncodableVector(DefiniteLengthInputStream definiteLengthInputStream) throws IOException {
        return new ASN1InputStream(definiteLengthInputStream).buildEncodableVector();
    }

    public ASN1Primitive readObject() throws IOException {
        int n2 = this.read();
        if (n2 <= 0) {
            if (n2 == 0) {
                throw new IOException("unexpected end-of-contents marker");
            }
            return null;
        }
        int n3 = ASN1InputStream.readTagNumber(this, n2);
        boolean bl = (n2 & 0x20) != 0;
        int n4 = this.readLength();
        if (n4 < 0) {
            if (!bl) {
                throw new IOException("indefinite-length primitive encoding encountered");
            }
            ASN1InputStream aSN1InputStream = this;
            IndefiniteLengthInputStream indefiniteLengthInputStream = new IndefiniteLengthInputStream(aSN1InputStream, aSN1InputStream.limit);
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(indefiniteLengthInputStream, this.limit);
            if ((n2 & 0x40) != 0) {
                return new BERApplicationSpecificParser(n3, aSN1StreamParser).getLoadedObject();
            }
            if ((n2 & 0x80) != 0) {
                return new BERTaggedObjectParser(true, n3, aSN1StreamParser).getLoadedObject();
            }
            switch (n3) {
                case 4: {
                    return new BEROctetStringParser(aSN1StreamParser).getLoadedObject();
                }
                case 16: {
                    return new BERSequenceParser(aSN1StreamParser).getLoadedObject();
                }
                case 17: {
                    return new BERSetParser(aSN1StreamParser).getLoadedObject();
                }
                case 8: {
                    return new DERExternalParser(aSN1StreamParser).getLoadedObject();
                }
            }
            throw new IOException("unknown BER object encountered");
        }
        try {
            return this.buildObject(n2, n3, n4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception("corrupted stream detected", illegalArgumentException);
        }
    }

    static int readTagNumber(InputStream inputStream, int n2) throws IOException {
        int n3 = n2 & 0x1F;
        if (n3 == 31) {
            n3 = 0;
            int n4 = inputStream.read();
            if ((n4 & 0x7F) == 0) {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
            while (n4 >= 0 && (n4 & 0x80) != 0) {
                n3 |= n4 & 0x7F;
                n3 <<= 7;
                n4 = inputStream.read();
            }
            if (n4 < 0) {
                throw new EOFException("EOF found inside tag value.");
            }
            n3 |= n4 & 0x7F;
        }
        return n3;
    }

    static int readLength(InputStream inputStream, int n2) throws IOException {
        int n3 = inputStream.read();
        if (n3 < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (n3 == 128) {
            return -1;
        }
        if (n3 > 127) {
            int n4 = n3 & 0x7F;
            if (n4 > 4) {
                throw new IOException("DER length more than 4 bytes: " + n4);
            }
            n3 = 0;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = inputStream.read();
                if (n5 < 0) {
                    throw new EOFException("EOF found reading length");
                }
                n3 = (n3 << 8) + n5;
            }
            if (n3 < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (n3 >= n2) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return n3;
    }

    private static byte[] getBuffer(DefiniteLengthInputStream definiteLengthInputStream, byte[][] byArray) throws IOException {
        int n2 = definiteLengthInputStream.getRemaining();
        if (definiteLengthInputStream.getRemaining() < byArray.length) {
            byte[] byArray2 = byArray[n2];
            if (byArray2 == null) {
                int n3 = n2;
                byte[] byArray3 = new byte[n3];
                byArray[n3] = byArray3;
                byArray2 = byArray3;
            }
            Streams.readFully(definiteLengthInputStream, byArray2);
            return byArray2;
        }
        return definiteLengthInputStream.toByteArray();
    }

    private static char[] getBMPCharBuffer(DefiniteLengthInputStream definiteLengthInputStream) throws IOException {
        int n2;
        int n3;
        int n4 = definiteLengthInputStream.getRemaining() / 2;
        char[] cArray = new char[n4];
        int n5 = 0;
        while (n5 < n4 && (n3 = definiteLengthInputStream.read()) >= 0 && (n2 = definiteLengthInputStream.read()) >= 0) {
            cArray[n5++] = (char)(n3 << 8 | n2 & 0xFF);
        }
        return cArray;
    }

    static ASN1Primitive createPrimitiveDERObject(int n2, DefiniteLengthInputStream definiteLengthInputStream, byte[][] byArray) throws IOException {
        switch (n2) {
            case 3: {
                return ASN1BitString.fromInputStream(definiteLengthInputStream.getRemaining(), definiteLengthInputStream);
            }
            case 30: {
                return new DERBMPString(ASN1InputStream.getBMPCharBuffer(definiteLengthInputStream));
            }
            case 1: {
                return ASN1Boolean.fromOctetString(ASN1InputStream.getBuffer(definiteLengthInputStream, byArray));
            }
            case 10: {
                return ASN1Enumerated.fromOctetString(ASN1InputStream.getBuffer(definiteLengthInputStream, byArray));
            }
            case 24: {
                return new ASN1GeneralizedTime(definiteLengthInputStream.toByteArray());
            }
            case 27: {
                return new DERGeneralString(definiteLengthInputStream.toByteArray());
            }
            case 22: {
                return new DERIA5String(definiteLengthInputStream.toByteArray());
            }
            case 2: {
                return new ASN1Integer(definiteLengthInputStream.toByteArray(), false);
            }
            case 5: {
                return DERNull.INSTANCE;
            }
            case 18: {
                return new DERNumericString(definiteLengthInputStream.toByteArray());
            }
            case 6: {
                return ASN1ObjectIdentifier.fromOctetString(ASN1InputStream.getBuffer(definiteLengthInputStream, byArray));
            }
            case 4: {
                return new DEROctetString(definiteLengthInputStream.toByteArray());
            }
            case 19: {
                return new DERPrintableString(definiteLengthInputStream.toByteArray());
            }
            case 20: {
                return new DERT61String(definiteLengthInputStream.toByteArray());
            }
            case 28: {
                return new DERUniversalString(definiteLengthInputStream.toByteArray());
            }
            case 23: {
                return new ASN1UTCTime(definiteLengthInputStream.toByteArray());
            }
            case 12: {
                return new DERUTF8String(definiteLengthInputStream.toByteArray());
            }
            case 26: {
                return new DERVisibleString(definiteLengthInputStream.toByteArray());
            }
            case 25: {
                return new DERGraphicString(definiteLengthInputStream.toByteArray());
            }
            case 21: {
                return new DERVideotexString(definiteLengthInputStream.toByteArray());
            }
        }
        throw new IOException("unknown tag " + n2 + " encountered");
    }
}

