/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway.impl;

import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.eventgateway.EventRequestDispatcher;
import coldfusion.eventgateway.EventRequestHandler;
import coldfusion.eventgateway.Gateway;
import coldfusion.eventgateway.GatewayInfo;
import coldfusion.eventgateway.Logger;
import coldfusion.log.CFLogs;
import coldfusion.log.LogService;
import coldfusion.runtime.CFPage;
import coldfusion.server.ConfigMap;
import coldfusion.server.ConfigMapListener;
import coldfusion.server.EventGatewayService;
import coldfusion.server.LicenseService;
import coldfusion.server.Service;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.util.FastHashtable;
import coldfusion.util.RB;
import coldfusion.util.URLDecoder;
import com.zion.jbuddy.IClientFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.smpp.smscsim.Simulator;

public class EventServiceImpl
extends ServiceBase
implements EventGatewayService {
    private File _configFile = null;
    private static coldfusion.log.Logger eventLog = null;
    private static boolean bEventService = false;
    private static ConfigMap settings;
    private static Vector gateways;
    private static Vector instances;
    private static ConfigMap global;
    private static EventRequestDispatcher reqDispatcher;
    private static EventRequestHandler eventReqHandler;
    private static int threadpoolsize;
    private static int devloperThreadLimit;
    private static int standardThreadLimit;
    private static int maxqueuesize;
    private static int devloperQueueLimit;
    private static String jigid;
    private static boolean bJigid;
    private static final long cert_checksum = 1445857997L;
    private static final String trustedSubject = "Zion Software, LLC";
    private static boolean bDeveloperEdition;
    private static boolean bStandardEdition;
    private static FastHashtable gatewayType_map;
    private static FastHashtable instance_map;
    private static FastHashtable gwinfo_map;
    private final String rootDirPattern = "{cf.rootdir}";
    private final int rootDirLen = "{cf.rootdir}".length();
    private String rootdir = null;
    private int status = 1;
    private Simulator smsTestServer = null;
    private static final String USERSFILE = "sms-test-users.txt";
    private static final String sd = "[B@cbf92";
    private boolean jbuddyIMGatewayInitialized;

    public EventServiceImpl(File f, String rd) {
        this._configFile = f;
        this.rootdir = rd;
        this.status = 16;
        eventLog = CFLogs.EVENT_LOG;
        this.setWatchFile(this._configFile);
    }

    public void start() throws ServiceException {
        this.status = 2;
        try {
            super.start();
            if (bEventService) {
                this.startEventBackendHandlers();
                this.startEventGateways();
                this.setEnableWatch(true);
                this.registerWithWatchService();
                this.status = 4;
            } else {
                if (!ServiceFactory.getRuntimeService().isCommandLineCompile()) {
                    eventLog.info((Object)RB.getString((Object)((Object)this), (String)"EventService.Disabled"));
                }
                this.status = 16;
            }
        }
        catch (Throwable ex) {
            if (eventLog != null) {
                eventLog.debug(ex);
            }
            this.status = 16;
            throw new ServiceException(ex);
        }
    }

    public void stop() throws ServiceException {
        this.status = 8;
        if (bEventService) {
            Enumeration e = gwinfo_map.keys();
            eventLog.info((Object)RB.getString((Object)((Object)this), (String)"EventService.StoppingGateways"));
            while (e.hasMoreElements()) {
                GatewayInfo gwInfo = (GatewayInfo)gwinfo_map.get(e.nextElement());
                this.stopEventGateway(gwInfo.getGw().getGatewayID());
            }
            this.unregisterWithWatchService();
            bEventService = false;
            reqDispatcher.stop();
        }
        this.status = 16;
    }

    public void load() throws ServiceException {
        try {
            settings = (ConfigMap)this.deserialize(this._configFile);
            settings.init((Service)this, "configuration");
            if (this.setSettings((Map)settings)) {
                CentralConfigClientUtil.delayStore((ServiceBase)this);
            }
            settings.setConfigMapListener((ConfigMapListener)this);
            global.setConfigMapListener((ConfigMapListener)this);
        }
        catch (Throwable ex) {
            throw new ServiceException(ex);
        }
    }

    public void store() throws ServiceException {
        this.setSettings((Map)settings);
        this.serialize(settings, this._configFile);
        settings.setUnchanged();
    }

    public void store(boolean broadcast) throws ServiceException {
        this.store(null, null, null, broadcast);
    }

    public void store(Object key, Object value, Object oldValue) throws ServiceException {
        this.store(key, value, oldValue, true);
    }

    public void store(Object key, Object value, Object oldValue, boolean broadcast) throws ServiceException {
        this.setSettings((Map)settings);
        this.serialize(settings, this._configFile, broadcast, key, value, oldValue);
        settings.setUnchanged();
    }

    public EventRequestHandler getEventRequestHandler() {
        return eventReqHandler;
    }

    public EventRequestDispatcher getEventRequestDispatcher() {
        return reqDispatcher;
    }

    public Logger getLogger() {
        return new Logger(eventLog);
    }

    public Logger getLogger(String logfile) {
        LogService logService = (LogService)ServiceFactory.getLoggingService();
        return new Logger(logService.getUserLog(logfile));
    }

    public int getStatus() {
        return this.status;
    }

    public Map getSettings() {
        return settings;
    }

    public Vector getGateways() {
        return instances;
    }

    public Map getGatewayInfo(String gwID) {
        return (Map)instance_map.get((Object)gwID);
    }

    public Vector getGatewayTypes() {
        return gateways;
    }

    public Map getGatewayTypeInfo(String type) {
        return (Map)gatewayType_map.get((Object)type);
    }

    public Map getGlobals() {
        return global;
    }

    public synchronized void setEnable(boolean bEnable) throws ServiceException {
        global.put((Object)"ENABLEEVENTGATEWAYSERVICE", (Object)(bEnable ? Boolean.TRUE : Boolean.FALSE));
        if (!bEnable) {
            this.stop();
        } else {
            this.start();
        }
    }

    public synchronized void setThreadpoolsize(int size) {
        if (bDeveloperEdition && threadpoolsize > devloperThreadLimit) {
            size = devloperThreadLimit;
        }
        if (bStandardEdition && threadpoolsize > standardThreadLimit) {
            size = standardThreadLimit;
        }
        threadpoolsize = size;
        global.put((Object)"THREADPOOLSIZE", (Object)new Integer(threadpoolsize));
    }

    public synchronized void setMaxqueuesize(int size) {
        if (bDeveloperEdition && maxqueuesize > devloperQueueLimit) {
            size = devloperQueueLimit;
        }
        maxqueuesize = size;
        global.put((Object)"MAXQUEUESIZE", (Object)new Integer(maxqueuesize));
    }

    public void startEventGateway(String gwID) throws ServiceRuntimeException {
        if (!bEventService) {
            return;
        }
        ConfigMap instance = (ConfigMap)instance_map.get((Object)gwID);
        if (instance == null) {
            throw new ServiceRuntimeException(RB.getString((Object)((Object)this), (String)"EventService.UnknownGateway", (Object)gwID));
        }
        String mode = (String)instance.get((Object)"MODE");
        String type = (String)instance.get((Object)"TYPE");
        ConfigMap gateway = (ConfigMap)gatewayType_map.get((Object)type);
        int starttimeout = ((Number)gateway.get((Object)"STARTTIMEOUT")).intValue();
        boolean bKillOnTimeOut = (Boolean)gateway.get((Object)"KILLONTIMEOUT");
        if (!mode.equalsIgnoreCase("DISABLED")) {
            try {
                Gateway gw = this.allocateEventGateway(gwID);
                if (gw != null) {
                    GatewayInfo gwInfo = new GatewayInfo(gw, type);
                    gwinfo_map.put((Object)gwID, (Object)gwInfo);
                    this.configureListeners(gwID, gw);
                    GatewayStarter gs = new GatewayStarter(gw, starttimeout, bKillOnTimeOut);
                    gs.start();
                }
            }
            catch (Exception ex) {
                eventLog.error((Throwable)ex);
                if (ex instanceof ServiceRuntimeException) {
                    throw (ServiceRuntimeException)ex;
                }
                throw new ServiceRuntimeException((Throwable)ex);
            }
        }
    }

    public void stopEventGateway(String gwID) {
        if (!bEventService) {
            return;
        }
        GatewayInfo gwInfo = (GatewayInfo)gwinfo_map.get((Object)gwID);
        if (gwInfo == null) {
            return;
        }
        Gateway gw = gwInfo.getGw();
        eventLog.info((Object)RB.getString((Object)((Object)this), (String)"EventService.StoppingGW", (Object)gw.getGatewayID(), (Object)gw.getClass().getName()));
        try {
            gw.stop();
        }
        catch (Exception e) {
            eventLog.error((Throwable)e);
        }
    }

    public void restartEventGateway(String gwID) {
        if (!bEventService) {
            return;
        }
        GatewayInfo gwInfo = (GatewayInfo)gwinfo_map.get((Object)gwID);
        if (gwInfo == null) {
            return;
        }
        Gateway gw = gwInfo.getGw();
        eventLog.info((Object)RB.getString((Object)((Object)this), (String)"EventService.RestartingGW", (Object)gw.getGatewayID(), (Object)gw.getClass().getName()));
        try {
            gw.restart();
        }
        catch (Exception e) {
            eventLog.error((Throwable)e);
        }
    }

    public int getEventGatewayStatus(String gwID) {
        if (!bEventService) {
            return 4;
        }
        Gateway gw = this.getGateway(gwID);
        if (gw != null) {
            return gw.getStatus();
        }
        return 4;
    }

    public Gateway getGateway(String gwID) {
        GatewayInfo gwInfo = (GatewayInfo)gwinfo_map.get((Object)gwID);
        if (gwInfo == null) {
            return null;
        }
        return gwInfo.getGw();
    }

    public synchronized void incrementEventsIn(String gwID) {
        GatewayInfo gwInfo = (GatewayInfo)gwinfo_map.get((Object)gwID);
        if (gwInfo == null) {
            return;
        }
        ++gwInfo.incount;
    }

    public synchronized long getEventsIn(String gwID) {
        GatewayInfo gwInfo = (GatewayInfo)gwinfo_map.get((Object)gwID);
        if (gwInfo == null) {
            return 0L;
        }
        return gwInfo.incount;
    }

    public synchronized void resetEventsIn(String gwID) {
        GatewayInfo gwInfo = (GatewayInfo)gwinfo_map.get((Object)gwID);
        if (gwInfo == null) {
            return;
        }
        gwInfo.incount = 0L;
    }

    public synchronized void incrementEventsOut(String gwID) {
        GatewayInfo gwInfo = (GatewayInfo)gwinfo_map.get((Object)gwID);
        if (gwInfo == null) {
            return;
        }
        ++gwInfo.outcount;
    }

    public synchronized long getEventsOut(String gwID) {
        GatewayInfo gwInfo = (GatewayInfo)gwinfo_map.get((Object)gwID);
        if (gwInfo == null) {
            return 0L;
        }
        return gwInfo.outcount;
    }

    public synchronized void resetEventsOut(String gwID) {
        GatewayInfo gwInfo = (GatewayInfo)gwinfo_map.get((Object)gwID);
        if (gwInfo == null) {
            return;
        }
        gwInfo.outcount = 0L;
    }

    public synchronized GatewayInfo getGatewayStats(String gwID) {
        return (GatewayInfo)gwinfo_map.get((Object)gwID);
    }

    public synchronized void updateGatewayMode(String gwID, String startup) {
        String mode = startup.toUpperCase();
        if (!(mode.equals("AUTO") || mode.equals("MANUAL") || mode.equals("DISABLED"))) {
            throw new ServiceRuntimeException(RB.getString((Object)((Object)this), (String)"EventService.BadMode", (Object)startup));
        }
        Object entry = instance_map.get((Object)gwID);
        if (entry != null) {
            ((ConfigMap)entry).put((Object)"MODE", (Object)mode);
        }
        this.mapModified();
    }

    public synchronized void registerGatewayType(String typeName, String description, String javaClass, int timeout, boolean kill) throws ServiceRuntimeException {
        this.verifyClass(javaClass);
        Object entry = gatewayType_map.get((Object)typeName);
        if (entry != null) {
            gatewayType_map.remove((Object)typeName);
            gateways.remove(entry);
        }
        ConfigMap gw = new ConfigMap();
        gw.put((Object)"TYPE", (Object)typeName);
        gw.put((Object)"DESCRIPTION", (Object)description);
        gw.put((Object)"CLASS", (Object)javaClass);
        gw.put((Object)"STARTTIMEOUT", (Object)new Integer(timeout));
        gw.put((Object)"KILLONTIMEOUT", (Object)kill);
        gatewayType_map.put((Object)typeName, (Object)gw);
        gateways.add(gw);
        this.mapModified(null, typeName, gw, entry);
    }

    public synchronized void registerGateway(String gwID, String type, String config, String[] cfcpaths, String startup) throws ServiceRuntimeException {
        String mode = startup.toUpperCase();
        if (!(mode.equals("AUTO") || mode.equals("MANUAL") || mode.equals("DISABLED"))) {
            throw new ServiceRuntimeException(RB.getString((Object)((Object)this), (String)"EventService.BadMode", (Object)startup));
        }
        Vector<String> cfcs = new Vector<String>(cfcpaths.length);
        for (int i = 0; i < cfcpaths.length; ++i) {
            File f;
            String path = cfcpaths[i];
            cfcs.add(path);
            if (path.indexOf("{cf.rootdir}") != -1) {
                path = this.rootdir + path.substring(path.indexOf("{cf.rootdir}") + this.rootDirLen);
            }
            if ((f = new File(path)).exists() && f.isFile()) continue;
            throw new ServiceRuntimeException(RB.getString((Object)((Object)this), (String)"EventService.missingCFC", (Object)path));
        }
        Object entry = instance_map.get((Object)gwID);
        if (entry != null) {
            this.removeGateway(gwID);
        }
        ConfigMap gw = new ConfigMap();
        gw.put((Object)"GATEWAYID", (Object)gwID);
        gw.put((Object)"TYPE", (Object)type);
        gw.put((Object)"CONFIGURATIONPATH", (Object)config);
        gw.put((Object)"CFCPATHS", cfcs);
        gw.put((Object)"MODE", (Object)mode);
        instance_map.put((Object)gwID, (Object)gw);
        instances.add(gw);
        this.mapModified(null, gwID, gw, null);
    }

    public synchronized void removeGatewayType(String type) throws ServiceRuntimeException {
        ConfigMap typeInfo = (ConfigMap)gatewayType_map.get((Object)type);
        if (typeInfo == null) {
            throw new ServiceRuntimeException(RB.getString((Object)((Object)this), (String)"EventService.UnknownType", (Object)type));
        }
        Enumeration e = instance_map.elements();
        while (e.hasMoreElements()) {
            ConfigMap configMap = (ConfigMap)e.nextElement();
            if (!type.equals(configMap.get((Object)"TYPE"))) continue;
            this.removeGateway((String)configMap.get((Object)"GATEWAYID"));
        }
        gatewayType_map.remove((Object)type);
        gateways.remove(typeInfo);
        this.mapModified(null, type, null, typeInfo);
    }

    public synchronized void removeGateway(String gwID) throws ServiceRuntimeException {
        Map gwConfig = (Map)instance_map.get((Object)gwID);
        if (gwConfig == null) {
            throw new ServiceRuntimeException(RB.getString((Object)((Object)this), (String)"EventService.UnknownGateway", (Object)gwID));
        }
        GatewayInfo gwinfo = (GatewayInfo)gwinfo_map.get((Object)gwID);
        if (gwinfo != null && gwinfo.getGw().getStatus() == 2) {
            this.stopEventGateway(gwID);
        }
        instance_map.remove((Object)gwID);
        instances.remove(gwConfig);
        gwinfo_map.remove((Object)gwID);
        eventReqHandler.removeCFCPaths(gwID);
        this.mapModified(null, gwID, null, gwConfig);
    }

    public String[] getGatewayCFCListeners(String gwID) {
        return eventReqHandler.getCFCPaths(gwID);
    }

    public synchronized void setCFCListeners(String gwID, String[] listeners) {
        Gateway gateway = this.getGateway(gwID);
        if (gateway == null) {
            throw new ServiceRuntimeException(RB.getString((Object)((Object)this), (String)"EventService.UnknownGateway", (Object)gwID));
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i].indexOf("{cf.rootdir}") == -1) continue;
            String cfcPath = this.rootdir + listeners[i].substring(listeners[i].indexOf("{cf.rootdir}") + this.rootDirLen);
            try {
                listeners[i] = new File(cfcPath).getCanonicalPath();
                continue;
            }
            catch (IOException ex) {
                eventLog.error((Throwable)ex);
                throw new ServiceRuntimeException((Throwable)ex);
            }
        }
        gateway.setCFCListeners(listeners);
        eventReqHandler.setCFCPaths(gwID, listeners);
        ConfigMap gwCfg = (ConfigMap)instance_map.get((Object)gwID);
        gwCfg.put((Object)"CFCPATHS", (Object)listeners);
        this.mapModified();
    }

    public void startSMSTestServer(final int port) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (EventServiceImpl.this.smsTestServer == null) {
                    EventServiceImpl.this.smsTestServer = new Simulator();
                }
                String usersfile = EventServiceImpl.this.rootdir + File.separatorChar + "lib" + File.separatorChar + EventServiceImpl.USERSFILE;
                String logdir = ((LogService)ServiceFactory.getLoggingService()).getLogDirectory() + File.separatorChar;
                try {
                    EventServiceImpl.this.smsTestServer.start(port, usersfile, logdir);
                    return null;
                }
                catch (IOException e) {
                    try {
                        EventServiceImpl.this.smsTestServer.stop();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new ServiceRuntimeException(RB.getString((Object)this, (String)"EventService.cantstartSMStest"), (Throwable)e);
                }
            }
        });
        eventLog.info((Object)RB.getString((Object)((Object)this), (String)"EventService.StartedSMStest"));
    }

    public void stopSMSTestServer() {
        if (this.smsTestServer != null) {
            try {
                this.smsTestServer.stop();
            }
            catch (IOException e) {
                throw new ServiceRuntimeException(RB.getString((Object)((Object)this), (String)"EventService.cantstopSMStest"), (Throwable)e);
            }
            eventLog.info((Object)RB.getString((Object)((Object)this), (String)"EventService.StoppedSMStest"));
        }
    }

    public boolean isSMSTestRunning() {
        return this.smsTestServer != null && this.smsTestServer.isRunning();
    }

    private void configureListeners(String gwID, Gateway gw) throws Exception {
        ConfigMap instance = (ConfigMap)instance_map.get((Object)gwID);
        Vector cfc = (Vector)instance.get((Object)"CFCPATHS");
        String[] cfc_paths = new String[cfc.size()];
        for (int i = 0; i < cfc.size(); ++i) {
            cfc_paths[i] = (String)cfc.elementAt(i);
            if (cfc_paths[i].indexOf("{cf.rootdir}") == -1) continue;
            String cfcPath = this.rootdir + cfc_paths[i].substring(cfc_paths[i].indexOf("{cf.rootdir}") + this.rootDirLen);
            cfc_paths[i] = new File(cfcPath).getCanonicalPath();
        }
        gw.setCFCListeners(cfc_paths);
        eventReqHandler.setCFCPaths(gwID, cfc_paths);
    }

    private Gateway allocateEventGateway(String gwID) throws ServiceRuntimeException {
        Object gw;
        if (!bEventService) {
            return null;
        }
        ConfigMap instance = (ConfigMap)instance_map.get((Object)gwID);
        String type = (String)instance.get((Object)"TYPE");
        String configPath = (String)instance.get((Object)"CONFIGURATIONPATH");
        if (configPath.indexOf("{cf.rootdir}") != -1) {
            configPath = this.rootdir + configPath.substring(configPath.indexOf("{cf.rootdir}") + this.rootDirLen);
        }
        ConfigMap gateway = (ConfigMap)gatewayType_map.get((Object)type);
        String gatewayClass = (String)gateway.get((Object)"CLASS");
        Class thisClass = this.verifyClass(gatewayClass);
        Constructor c = null;
        Object[] params = null;
        try {
            Class[] paramTypes = new Class[]{String.class, String.class};
            c = thisClass.getConstructor(paramTypes);
            params = new Object[]{gwID, configPath};
        }
        catch (NoSuchMethodException e) {
            try {
                Class[] paramTypes = new Class[]{String.class};
                c = thisClass.getConstructor(paramTypes);
                params = new Object[]{gwID};
            }
            catch (NoSuchMethodException paramTypes) {
                // empty catch block
            }
        }
        try {
            gw = params != null ? c.newInstance(params) : thisClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ServiceRuntimeException) {
                throw (ServiceRuntimeException)t;
            }
            throw new ServiceRuntimeException("", e.getTargetException());
        }
        catch (Exception ex) {
            throw new ServiceRuntimeException(RB.getString((Object)((Object)this), (String)"EventService.CantCreate"), (Throwable)ex);
        }
        if (gw instanceof Gateway) {
            ((Gateway)gw).setGatewayID(gwID);
            return (Gateway)gw;
        }
        return null;
    }

    private void startEventBackendHandlers() {
        eventLog.info((Object)RB.getString((Object)((Object)this), (String)"EventService.StartingHandlers"));
        reqDispatcher.init((EventGatewayService)this, threadpoolsize, maxqueuesize);
        eventReqHandler.init((EventGatewayService)this);
    }

    private void startEventGateways() throws Exception {
        eventLog.info((Object)RB.getString((Object)((Object)this), (String)"EventService.StartingGateways"));
        Enumeration e = instance_map.keys();
        while (e.hasMoreElements()) {
            String gwID = (String)e.nextElement();
            ConfigMap instance = (ConfigMap)instance_map.get((Object)gwID);
            String mode = (String)instance.get((Object)"MODE");
            if (!mode.equalsIgnoreCase("AUTO")) continue;
            try {
                this.startEventGateway(gwID);
            }
            catch (Exception exception) {}
        }
    }

    private Class verifyClass(final String javaClass) throws ServiceRuntimeException {
        Class impl;
        try {
            final ClassLoader cl = Thread.currentThread().getContextClassLoader();
            impl = System.getSecurityManager() == null ? cl.loadClass(javaClass) : (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return cl.loadClass(javaClass);
                }
            });
            if (!Gateway.class.isAssignableFrom(impl)) {
                throw new ServiceRuntimeException(RB.getString((Object)((Object)this), (String)"EventService.MustImplement", (Object)javaClass));
            }
        }
        catch (PrivilegedActionException e) {
            Exception t = e.getException();
            if (t instanceof ClassNotFoundException) {
            }
            throw new ServiceRuntimeException((Throwable)t);
        }
        finally {
            throw new ServiceRuntimeException(RB.getString((Object)((Object)this), (String)"EventService.ClassNotFound", (Object)javaClass));
        }
        return impl;
    }

    private boolean setSettings(Map settings) {
        boolean dosave = false;
        gateways = (Vector)settings.get("GATEWAYS");
        global = (ConfigMap)settings.get("GLOBAL");
        instances = (Vector)settings.get("INSTANCES");
        bEventService = global.get((Object)"ENABLEEVENTGATEWAYSERVICE") != null && (Boolean)global.get((Object)"ENABLEEVENTGATEWAYSERVICE") != false;
        threadpoolsize = global.get((Object)"THREADPOOLSIZE") != null ? ((Number)global.get((Object)"THREADPOOLSIZE")).intValue() : threadpoolsize;
        maxqueuesize = global.get((Object)"MAXQUEUESIZE") != null ? ((Number)global.get((Object)"MAXQUEUESIZE")).intValue() : maxqueuesize;
        jigid = global.get((Object)"JIGID") != null ? (String)global.get((Object)"JIGID") : null;
        Enumeration e = gateways.elements();
        while (e.hasMoreElements()) {
            ConfigMap gateway = (ConfigMap)e.nextElement();
            gatewayType_map.put(gateway.get((Object)"TYPE"), (Object)gateway);
        }
        e = instances.elements();
        while (e.hasMoreElements()) {
            ConfigMap instance = (ConfigMap)e.nextElement();
            instance_map.put(instance.get((Object)"GATEWAYID"), (Object)instance);
        }
        LicenseService ls = ServiceFactory.getLicenseService();
        int tl = threadpoolsize;
        int ql = maxqueuesize;
        if (ls.isDeveloper()) {
            bDeveloperEdition = true;
            tl = devloperThreadLimit;
            ql = devloperQueueLimit;
        } else if (ls.isStandard()) {
            bStandardEdition = true;
            tl = standardThreadLimit;
        }
        if (threadpoolsize > tl) {
            threadpoolsize = tl;
            global.put((Object)"THREADPOOLSIZE", (Object)new Integer(threadpoolsize));
            dosave = true;
        }
        if (maxqueuesize > ql) {
            maxqueuesize = ql;
            global.put((Object)"MAXQUEUESIZE", (Object)new Integer(maxqueuesize));
            dosave = true;
        }
        return dosave;
    }

    public synchronized void initializeJBuddyIMGateway() {
        block12: {
            if (this.jbuddyIMGatewayInitialized) {
                return;
            }
            String rd = this.rootdir;
            try {
                if (jigid != null) {
                    String lic = CFPage.Decrypt((String)URLDecoder.decode((String)jigid), (String)sd);
                    if (lic != null) {
                        boolean bResult = IClientFactory.useLicense((int)50, (String)"Macromedia Inc.", (String)lic);
                        if (!bResult) {
                            if (eventLog != null) {
                                eventLog.info((Object)RB.getString((Object)((Object)this), (String)"EventService.InvalidIMLicense"));
                            }
                        } else {
                            bJigid = true;
                        }
                    } else if (eventLog != null) {
                        eventLog.error((Object)RB.getString((Object)((Object)this), (String)"EventService.InvalidIMLicense"));
                    }
                } else if (eventLog != null) {
                    eventLog.error((Object)RB.getString((Object)((Object)this), (String)"EventService.InvalidIMLicense"));
                }
            }
            catch (Exception e) {
                if (eventLog == null) break block12;
                eventLog.error((Object)RB.getString((Object)((Object)this), (String)"EventService.ErrorActivatingIMLicense", (Object)e.toString()));
            }
        }
        this.jbuddyIMGatewayInitialized = true;
    }

    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("configuration.keys", "gateways,global,instances");
            this.rb.put("configuration.types", "java.util.Vector,coldfusion.server.ConfigMap,java.util.Vector");
            this.rb.put("configuration.formats", "coldfusion.server.MapFormatter,coldfusion.server.MapFormatter,coldfusion.server.MapFormatter");
            this.rb.put("global.keys", "threadpoolsize,enableeventgatewayservice,maxqueuesize,jigid");
            this.rb.put("global.types", "java.lang.Integer,java.lang.Boolean,java.lang.Integer,java.lang.String");
            this.rb.put("global.formats", "coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.NumberFormatter,coldfusion.server.StringFormatter");
            this.rb.put("gateways.keys", "");
            this.rb.put("gateways.types", "java.util.Vector");
            this.rb.put("gateways.formats", "coldfusion.server.MapFormatter");
            this.rb.put("gateways.value", "gateway");
            this.rb.put("gateway.keys", "type,starttimeout,description,killontimeout,class");
            this.rb.put("gateway.types", "java.lang.String,java.lang.Integer,java.lang.String,java.lang.Boolean,java.lang.String");
            this.rb.put("gateway.formats", "coldfusion.server.StringFormatter,coldfusion.server.NumberFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter");
            this.rb.put("instances.keys", "");
            this.rb.put("instances.types", "java.util.Vector");
            this.rb.put("instances.formats", "coldfusion.server.MapFormatter");
            this.rb.put("instances.value", "instance");
            this.rb.put("instance.keys", "configurationpath,gatewayid,type,cfcpaths,mode");
            this.rb.put("instance.types", "java.lang.String,java.lang.String,java.lang.String,coldfusion.server.ConfigMap,java.lang.String");
            this.rb.put("instance.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.MapFormatter,coldfusion.server.StringFormatter");
        }
        return this.rb;
    }

    static {
        reqDispatcher = new EventRequestDispatcher();
        eventReqHandler = new EventRequestHandler();
        threadpoolsize = 5;
        devloperThreadLimit = 1;
        standardThreadLimit = 1;
        maxqueuesize = 25000;
        devloperQueueLimit = 10;
        jigid = null;
        bJigid = false;
        bDeveloperEdition = false;
        bStandardEdition = false;
        gatewayType_map = new FastHashtable();
        instance_map = new FastHashtable();
        gwinfo_map = new FastHashtable();
    }

    private class GatewayStarter
    extends Thread {
        private Gateway gateway = null;
        private boolean bStart = false;
        private Timer timer = null;
        private int timeout = 30;
        private boolean bKillOnTimeOut = false;

        public GatewayStarter(Gateway g, int t, boolean b) {
            this.gateway = g;
            this.timer = new Timer();
            this.timeout = t;
            this.bKillOnTimeOut = b;
            this.timer.schedule((TimerTask)new TimeoutTask(this), this.timeout * 1000);
        }

        @Override
        public void run() {
            eventLog.info((Object)RB.getString((Object)this, (String)"EventService.StartingGW", (Object)this.gateway.getGatewayID(), (Object)this.gateway.getClass().getName()));
            try {
                this.gateway.start();
                this.setStart(true);
            }
            catch (Exception e) {
                eventLog.error((Throwable)e);
            }
            this.timer.cancel();
        }

        private synchronized void setStart(boolean b) {
            this.bStart = b;
        }

        private synchronized boolean getStart() {
            return this.bStart;
        }

        class TimeoutTask
        extends TimerTask {
            private GatewayStarter gs = null;

            public TimeoutTask(GatewayStarter gs) {
                this.gs = gs;
            }

            @Override
            public void run() {
                if (!this.gs.getStart()) {
                    String gwString = GatewayStarter.this.gateway.getGatewayID() + " (" + GatewayStarter.this.gateway.getClass().getName() + ")";
                    eventLog.warn((Object)RB.getString((Object)this, (String)"EventService.Timeout", (Object)gwString, (Object)Integer.toString(GatewayStarter.this.timeout)));
                    if (GatewayStarter.this.bKillOnTimeOut) {
                        this.gs.interrupt();
                        eventLog.warn((Object)RB.getString((Object)this, (String)"EventService.Interrupted", (Object)gwString));
                    }
                }
                GatewayStarter.this.timer.cancel();
            }
        }
    }
}

