/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.presentation;

import coldfusion.document.DocumentMargin;
import coldfusion.document.spi.Bookmark;
import coldfusion.document.spi.DocumentWriter;
import coldfusion.presentation.PPGraphics2D;
import coldfusion.runtime.ApplicationException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.poi.ddf.AbstractEscherOptRecord;
import org.apache.poi.ddf.EscherPropertyTypes;
import org.apache.poi.hslf.usermodel.HSLFBackground;
import org.apache.poi.hslf.usermodel.HSLFGroupShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTextBox;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextRun;
import org.apache.poi.sl.usermodel.TextParagraph;

public class PowerPointWriter
implements DocumentWriter {
    private HSLFGroupShape group = null;
    private int height;
    private int width;
    private HSLFSlideShow ppt;
    private HSLFSlide slide;

    public PowerPointWriter(HSLFSlideShow pptobj, String title, Color color) {
        this.ppt = pptobj;
        try {
            this.slide = this.ppt.createSlide();
        }
        catch (Exception e) {
            throw new InvalidPowerPointFileException(e);
        }
        this.slide.setFollowMasterBackground(false);
        this.slide.setFollowMasterObjects(false);
        this.slide.setFollowMasterScheme(false);
        if (title != null && !title.equalsIgnoreCase("")) {
            HSLFTextBox titlebox = new HSLFTextBox();
            Rectangle2D.Double anchor = new Rectangle2D.Double(0.0, 0.0, this.ppt.getPageSize().getWidth(), 50.0);
            ((HSLFTextParagraph)titlebox.getTextParagraphs().get(0)).setTextAlign(TextParagraph.TextAlign.CENTER);
            HSLFTextRun textRun = (HSLFTextRun)((HSLFTextParagraph)titlebox.getTextParagraphs().get(0)).getTextRuns().get(0);
            textRun.setFontSize(Double.valueOf(44.0));
            textRun.setFontFamily("Arial");
            titlebox.setAnchor((Rectangle2D)anchor);
            titlebox.setText(title);
            this.slide.addShape((HSLFShape)titlebox);
        }
        if (color != null) {
            HSLFBackground background = this.slide.getBackground();
            AbstractEscherOptRecord opt = background.getEscherOptRecord();
            int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
            HSLFShape.setEscherProperty((AbstractEscherOptRecord)opt, (EscherPropertyTypes)EscherPropertyTypes.FILL__FILLCOLOR, (int)rgb);
            HSLFShape.setEscherProperty((AbstractEscherOptRecord)opt, (EscherPropertyTypes)EscherPropertyTypes.FILL__FILLBACKCOLOR, (int)rgb);
        }
        this.group = new HSLFGroupShape();
        this.slide.addShape((HSLFShape)this.group);
    }

    public void close() throws IOException {
    }

    public void saveState() {
    }

    public Graphics2D createGraphics(float pageWidth, float pageHeight, DocumentMargin margin, boolean externalLinksOn) {
        double x = margin.getLeft();
        double y = margin.getTop();
        Rectangle bounds = new Rectangle((int)x, (int)y, (int)pageWidth, (int)pageHeight);
        this.group.setAnchor((Rectangle2D)bounds);
        Graphics2D g = this.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        AffineTransform atrans = new AffineTransform();
        atrans.translate(x, y);
        AffineTransform affTransform = g.getTransform();
        affTransform.concatenate(atrans);
        g.transform(atrans);
        return g;
    }

    public Graphics2D createGraphics(float pageWidth, float pageHeight, DocumentMargin margin) {
        return this.createGraphics(pageWidth, pageHeight, margin, true);
    }

    public Graphics2D createGraphics() {
        return new PPGraphics2D(this.group, this.slide, this.ppt);
    }

    public Bookmark addBookmark(String name) {
        return null;
    }

    public Bookmark addBookmark(String name, Bookmark parentBookmark) {
        return null;
    }

    public Bookmark addBookmark(String name, float left, float top) {
        return null;
    }

    public Bookmark addBookmark(String name, Bookmark parentBookmark, float left, float top) {
        return null;
    }

    public void flush() throws IOException {
    }

    public static class InvalidPowerPointFileException
    extends ApplicationException {
        public InvalidPowerPointFileException(Throwable ex) {
            super(ex);
        }
    }
}

