/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.runtime.Struct;
import coldfusion.s3.consumer.LifecycleRuleAndOperatorConsumer;
import coldfusion.s3.consumer.NoncurrentVersionTransitionConsumer;
import coldfusion.s3.consumer.TagConsumer;
import java.util.Collections;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator;
import software.amazon.awssdk.services.s3.model.LifecycleRuleFilter;
import software.amazon.awssdk.services.s3.model.Tag;

public class LifecycleRuleFilterConsumer
extends ConsumerMap<LifecycleRuleFilter.Builder> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static LifecycleRuleFilterConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LifecycleRuleFilterConsumer getInstance() {
        if (instance != null) return instance;
        Class<NoncurrentVersionTransitionConsumer> clazz = NoncurrentVersionTransitionConsumer.class;
        synchronized (NoncurrentVersionTransitionConsumer.class) {
            instance = new LifecycleRuleFilterConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LifecycleRuleFilterConsumer() {
        this.put("prefix", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"prefix");
            builder.prefix(input);
        }, Collections.emptyList()));
        this.put("tagging", new ConsumerValidator((builder, value) -> {
            Tag.Builder tag = Tag.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)tag, this.cast.getMapProperty(value), (ConsumerMap)TagConsumer.getInstance());
            builder.tag((Tag)tag.build());
        }, Collections.emptyList()));
        this.put("lifecycleRuleAndOperator", new ConsumerValidator((builder, value) -> {
            LifecycleRuleAndOperator.Builder lifecycleRuleAndOperator = LifecycleRuleAndOperator.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)lifecycleRuleAndOperator, this.cast.getMapProperty(value), (ConsumerMap)LifecycleRuleAndOperatorConsumer.getInstance());
            builder.and((LifecycleRuleAndOperator)lifecycleRuleAndOperator.build());
        }, Collections.emptyList()));
    }

    public Struct getStruct(LifecycleRuleFilter filter) {
        Struct struct = new Struct();
        Optional.ofNullable(filter).ifPresent(lifecycleRuleFilter -> {
            struct.put((Object)"prefix", (Object)filter.prefix());
            Optional.ofNullable(filter.tag()).ifPresent(tag -> struct.put((Object)"tagging", (Object)TagConsumer.getInstance().getStruct((Tag)tag)));
            struct.put((Object)"lifecycleRuleAndOperator", (Object)LifecycleRuleAndOperatorConsumer.getInstance().getStruct(filter.and()));
        });
        return struct;
    }
}

