/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.aws.AWSCredential;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.log.Logger;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.CloudMonitoringUtil;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.Invokable;
import coldfusion.runtime.InvokeMethodInvocationMap;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.MethodInvoker;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.Struct;
import coldfusion.s3.BucketAsRootReference;
import coldfusion.s3.BucketReference;
import coldfusion.s3.RootReference;
import coldfusion.s3.S3Service;
import coldfusion.s3.S3Utils;
import coldfusion.s3.consumer.BucketDeleteRequestConsumer;
import coldfusion.s3.consumer.CreateBucketRequestConsumer;
import coldfusion.s3.consumer.GetObjectRequestConsumer;
import coldfusion.s3.exception.S3APIException;
import coldfusion.s3.request.BucketDeleteRequest;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.jsp.PageContext;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.internal.presigner.DefaultS3Presigner;
import software.amazon.awssdk.services.s3.model.BucketAlreadyExistsException;
import software.amazon.awssdk.services.s3.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ObjectVersion;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.paginators.ListObjectVersionsIterable;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class S3ServiceImpl
implements S3Service,
Invokable,
NamedInvokable {
    private Logger logger = ServiceFactory.getLoggingService().getLogger("coldfusion.s3");
    private S3Client s3Client;
    private AWSCredential credential;
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.S3.name());
    private ValidatorFiller filler = ValidatorFiller.INSTANCE;
    private final String STATUS = "status";
    private final String SUCCESS = "Success";
    private final String FAILURE = "Failure";
    private static InvokeMethodInvocationMap<S3ServiceImpl> __invokeMethodInvocationMap = new InvokeMethodInvocationMap();
    private static InvokeNamedMethodInvocationMap<S3ServiceImpl> __InvokeNamedMethodInvocationMap;

    S3ServiceImpl(S3Client s3Client, AWSCredential credential) {
        this.s3Client = s3Client;
        this.credential = credential;
    }

    public S3ServiceImpl() {
    }

    public RootReference bucket(Object bucket) {
        if (bucket instanceof Struct) {
            return this.bucket((Struct)bucket);
        }
        return this.bucket(String.valueOf(bucket));
    }

    private RootReference bucket(String bucketName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"bucket", (boolean)true);
        this.logger.debug((Object)("getting bucket reference bucketName : " + bucketName));
        if (!this.isBucketExists(bucketName)) {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"bucket", (String)"get", (Object)"Failure", (TagAttributeList)this.tagAttributeList);
            throw new ValidationException(RB.getString(S3ServiceImpl.class, (String)"bucketNotFound"));
        }
        BucketReference ref = new BucketReference(this, bucketName);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"bucket", (String)"get", (Object)"Success", (TagAttributeList)this.tagAttributeList);
        return ref;
    }

    public RootReference bucket(String bucketName, boolean createIfNotExists) {
        RequestMonitorEventProcessor.onFunctionStart((String)"bucket", (boolean)true);
        String action = "get";
        String statusCode = "Success";
        try {
            if (!this.isBucketExists(bucketName) && createIfNotExists) {
                action = "post";
                CreateBucketRequest request = (CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build();
                RootReference ref = this.createBucket(request);
                CloudMonitoringUtil.onCloudFunctionEnd((String)"bucket", (String)action, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
                return ref;
            }
        }
        catch (BucketAlreadyExistsException | BucketAlreadyOwnedByYouException ex) {
            this.logger.info((Object)"bucket exits!", ex);
            statusCode = "Failure";
            CloudMonitoringUtil.onCloudFunctionEnd((String)"bucket", (String)action, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
            throw new S3APIException(RB.getString(S3ServiceImpl.class, (String)"createBucketError"), ex);
        }
        catch (S3APIException e) {
            statusCode = "Failure";
            CloudMonitoringUtil.onCloudFunctionEnd((String)"bucket", (String)action, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
            throw e;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while creating bucket", (Throwable)e);
            statusCode = "Failure";
            CloudMonitoringUtil.onCloudFunctionEnd((String)"bucket", (String)action, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
            throw new S3APIException(RB.getString(S3ServiceImpl.class, (String)"createBucketError"), e);
        }
        BucketReference ref = new BucketReference(this, bucketName);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"bucket", (String)action, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        return ref;
    }

    private RootReference bucket(Struct createBucketRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"bucket", (boolean)true);
        String statusCode = "Success";
        CreateBucketRequest.Builder builder = CreateBucketRequest.builder();
        this.filler.fillObject((Object)builder, (Map)createBucketRequest, (ConsumerMap)new CreateBucketRequestConsumer());
        CreateBucketRequest request = (CreateBucketRequest)builder.build();
        if (!this.isBucketExists(request.bucket())) {
            statusCode = "Failure";
            CloudMonitoringUtil.onCloudFunctionEnd((String)"bucket", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
            throw new ValidationException(RB.getString(S3ServiceImpl.class, (String)"bucketNotFound"));
        }
        BucketReference ref = new BucketReference(this, request.bucket());
        CloudMonitoringUtil.onCloudFunctionEnd((String)"bucket", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        return ref;
    }

    private RootReference createBucket(CreateBucketRequest request) throws S3APIException {
        this.s3Client.createBucket(request);
        BucketReference ref = new BucketReference(this, request.bucket());
        return ref;
    }

    public RootReference createBucket(Struct createBucketRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"createBucket", (boolean)true);
        CreateBucketRequest.Builder builder = CreateBucketRequest.builder();
        this.filler.fillObject((Object)builder, (Map)createBucketRequest, (ConsumerMap)new CreateBucketRequestConsumer());
        CreateBucketRequest request = (CreateBucketRequest)builder.build();
        RootReference ref = null;
        try {
            ref = this.createBucket(request);
        }
        catch (BucketAlreadyExistsException | BucketAlreadyOwnedByYouException ex) {
            this.logger.info((Object)"bucket exits!", ex);
            CloudMonitoringUtil.onCloudFunctionEnd((String)"createBucket", (String)"post", (Object)"Failure", (TagAttributeList)this.tagAttributeList);
            throw new S3APIException(RB.getString(S3ServiceImpl.class, (String)"createBucketError"), ex);
        }
        catch (S3APIException e) {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"createBucket", (String)"post", (Object)"Failure", (TagAttributeList)this.tagAttributeList);
            throw e;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while creating bucket", (Throwable)e);
            CloudMonitoringUtil.onCloudFunctionEnd((String)"createBucket", (String)"post", (Object)"Failure", (TagAttributeList)this.tagAttributeList);
            throw new S3APIException(RB.getString(S3ServiceImpl.class, (String)"createBucketError"), e);
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"createBucket", (String)"post", (Object)"Success", (TagAttributeList)this.tagAttributeList);
        return ref;
    }

    @Override
    public RootReference root(Object rootName) {
        if (rootName instanceof Struct) {
            return this.root((Struct)rootName);
        }
        return this.root(String.valueOf(rootName));
    }

    private RootReference root(String rootName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"root", (boolean)true);
        String statusCode = "Success";
        this.logger.debug((Object)("getting bucket reference bucketName : " + rootName));
        if (!this.isBucketExists(rootName)) {
            statusCode = "Failure";
            CloudMonitoringUtil.onCloudFunctionEnd((String)"root", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
            throw new ValidationException(RB.getString(S3ServiceImpl.class, (String)"bucketNotFound"));
        }
        BucketAsRootReference rootReference = new BucketAsRootReference(new BucketReference(this, rootName));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"root", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        return rootReference;
    }

    public RootReference root(String rootName, boolean createIfNotExists) {
        RequestMonitorEventProcessor.onFunctionStart((String)"root", (boolean)true);
        String statusCode = "Success";
        String action = "get";
        try {
            if (!this.isBucketExists(rootName) && createIfNotExists) {
                CreateBucketRequest request = (CreateBucketRequest)CreateBucketRequest.builder().bucket(rootName).build();
                action = "post";
                BucketAsRootReference bucketAsRootReference = new BucketAsRootReference((BucketReference)this.createBucket(request));
                return bucketAsRootReference;
            }
        }
        catch (BucketAlreadyExistsException | BucketAlreadyOwnedByYouException ex) {
            this.logger.info((Object)"bucket exits!", ex);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(S3ServiceImpl.class, (String)"createBucketError"), ex);
        }
        catch (S3APIException e) {
            statusCode = "Failure";
            throw e;
        }
        catch (Exception e) {
            statusCode = "Failure";
            this.logger.error((Object)"Error while creating bucket", (Throwable)e);
            throw new S3APIException(RB.getString(S3ServiceImpl.class, (String)"createBucketError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"root", (String)action, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return new BucketAsRootReference(new BucketReference(this, rootName));
    }

    private RootReference root(Struct rootName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"root", (boolean)true);
        CreateBucketRequest.Builder builder = CreateBucketRequest.builder();
        this.filler.fillObject((Object)builder, (Map)rootName, (ConsumerMap)new CreateBucketRequestConsumer());
        CreateBucketRequest request = (CreateBucketRequest)builder.build();
        if (!this.isBucketExists(request.bucket())) {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"root", (String)"get", (Object)"Failure", (TagAttributeList)this.tagAttributeList);
            throw new ValidationException(RB.getString(S3ServiceImpl.class, (String)"bucketNotFound"));
        }
        BucketAsRootReference ref = new BucketAsRootReference(new BucketReference(this, request.bucket()));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"root", (String)"get", (Object)"Success", (TagAttributeList)this.tagAttributeList);
        return ref;
    }

    private RootReference createRoot(CreateBucketRequest createRootRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"createRoot", (boolean)true);
        try {
            this.s3Client.createBucket(createRootRequest);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while creating bucket", (Throwable)e);
            CloudMonitoringUtil.onCloudFunctionEnd((String)"createRoot", (String)"post", (Object)"Failure", (TagAttributeList)this.tagAttributeList);
            throw new S3APIException(RB.getString(S3ServiceImpl.class, (String)"createBucketError"), e);
        }
        BucketAsRootReference ref = new BucketAsRootReference(new BucketReference(this, createRootRequest.bucket()));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"root", (String)"post", (Object)"Success", (TagAttributeList)this.tagAttributeList);
        return ref;
    }

    public RootReference createRoot(Struct createRootRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"createRoot", (boolean)true);
        CreateBucketRequest.Builder builder = CreateBucketRequest.builder();
        this.filler.fillObject((Object)builder, (Map)createRootRequest, (ConsumerMap)new CreateBucketRequestConsumer());
        CreateBucketRequest request = (CreateBucketRequest)builder.build();
        String statusCode = "Success";
        try {
            BucketAsRootReference ref;
            BucketAsRootReference bucketAsRootReference = ref = new BucketAsRootReference((BucketReference)this.createBucket(request));
            return bucketAsRootReference;
        }
        catch (BucketAlreadyExistsException | BucketAlreadyOwnedByYouException ex) {
            this.logger.info((Object)"bucket exits!", ex);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(S3ServiceImpl.class, (String)"createBucketError"), ex);
        }
        catch (S3APIException e) {
            statusCode = "Failure";
            throw e;
        }
        catch (Exception e) {
            statusCode = "Failure";
            this.logger.error((Object)"Error while creating bucket", (Throwable)e);
            throw new S3APIException(RB.getString(S3ServiceImpl.class, (String)"createBucketError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"createRoot", (String)"post", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    @Override
    public List<Struct> listAll() {
        RequestMonitorEventProcessor.onFunctionStart((String)"listAll", (boolean)true);
        List buckets = new LinkedList();
        try {
            buckets = this.s3Client.listBuckets().buckets();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while listing bucket", (Throwable)e);
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listAll", (String)"get", (Object)"Failure", (TagAttributeList)this.tagAttributeList);
            throw new S3APIException(RB.getString(S3ServiceImpl.class, (String)"listAllBucketError"), e);
        }
        List<Struct> res = ((List)Optional.ofNullable(buckets).orElse(new LinkedList())).stream().filter(Objects::nonNull).map(bucket -> {
            Struct bucketStruct = new Struct();
            bucketStruct.put((Object)"name", (Object)bucket.name());
            bucketStruct.put((Object)"creationDate", (Object)bucket.creationDate().toString());
            return bucketStruct;
        }).collect(Collectors.toList());
        CloudMonitoringUtil.onCloudFunctionEnd((String)"listAll", (String)"get", (Object)"Success", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    @Override
    public Struct delete(Object bucket) {
        if (bucket instanceof Struct) {
            return this.delete((Struct)bucket);
        }
        return this.delete(String.valueOf(bucket));
    }

    private Struct delete(String bucketName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"delete", (boolean)true);
        DeleteBucketRequest request = (DeleteBucketRequest)DeleteBucketRequest.builder().bucket(bucketName).build();
        try {
            this.s3Client.deleteBucket(request);
            Struct structResponse = new Struct();
            structResponse.put((Object)"status", (Object)"Success");
            Struct struct = structResponse;
            return struct;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while creating bucket", (Throwable)e);
            CloudMonitoringUtil.onCloudFunctionEnd((String)"delete", (String)"delete", (Object)"Failure", (TagAttributeList)this.tagAttributeList);
            throw new S3APIException(RB.getString(S3ServiceImpl.class, (String)"deleteBucketError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"delete", (String)"delete", (Object)"Success", (TagAttributeList)this.tagAttributeList);
        }
    }

    private Struct delete(Struct deleteRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"delete", (boolean)true);
        BucketDeleteRequest request = new BucketDeleteRequest();
        try {
            this.filler.fillObject((Object)request, (Map)deleteRequest, (ConsumerMap)new BucketDeleteRequestConsumer());
            DeleteBucketRequest deleteBucketRequest = (DeleteBucketRequest)request.getDeleteBucketRequest().build();
            if (request.isForceDelete()) {
                boolean isTruncated = true;
                ListObjectVersionsIterable versionList = this.s3Client.listObjectVersionsPaginator((ListObjectVersionsRequest)ListObjectVersionsRequest.builder().bucket(deleteBucketRequest.bucket()).build());
                isTruncated = true;
                this.logger.debug((Object)"deleting versioned objects of bucketdelete");
                while (isTruncated) {
                    for (ListObjectVersionsResponse response : versionList) {
                        for (ObjectVersion vs : response.versions()) {
                            this.s3Client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(deleteBucketRequest.bucket()).key(vs.key()).versionId(vs.versionId()).requestPayer(request.getRequestPayer()).bypassGovernanceRetention(request.getBypassGovernanceRetention()).mfa(request.getMfa()).build());
                        }
                        isTruncated = response.isTruncated();
                    }
                }
                isTruncated = true;
                this.logger.debug((Object)("deleting non-versioned object of bucket : " + deleteBucketRequest.bucket()));
                while (isTruncated) {
                    ListObjectsV2Iterable objectListing = this.s3Client.listObjectsV2Paginator((ListObjectsV2Request)ListObjectsV2Request.builder().bucket(deleteBucketRequest.bucket()).requestPayer(request.getRequestPayer()).build());
                    for (ListObjectsV2Response response : objectListing) {
                        for (S3Object s3Object : response.contents()) {
                            this.s3Client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(deleteBucketRequest.bucket()).key(s3Object.key()).mfa(request.getMfa()).bypassGovernanceRetention(request.getBypassGovernanceRetention()).requestPayer(request.getRequestPayer()).build());
                        }
                        isTruncated = response.isTruncated();
                    }
                }
            }
            this.s3Client.deleteBucket((DeleteBucketRequest)request.getDeleteBucketRequest().build());
            Struct structResponse = new Struct();
            structResponse.put((Object)"status", (Object)"Success");
            Struct struct = structResponse;
            return struct;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while creating bucket", (Throwable)e);
            CloudMonitoringUtil.onCloudFunctionEnd((String)"delete", (String)"delete", (Object)"Failure", (TagAttributeList)this.tagAttributeList);
            throw new S3APIException(RB.getString(S3ServiceImpl.class, (String)"deleteBucketError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"delete", (String)"delete", (Object)"Success", (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct getPreSignedUrl(Struct getPresignedRequest) {
        String res = "";
        RequestMonitorEventProcessor.onFunctionStart((String)"getPreSignedUrl", (boolean)true);
        S3Presigner presigner = DefaultS3Presigner.builder().credentialsProvider(S3Utils.getAWSCredential(this.credential)).region(Region.of((String)this.credential.getRegion())).build();
        GetObjectRequest.Builder getObjectRequest = GetObjectRequest.builder();
        this.filler.fillObject((Object)getObjectRequest, (Map)getPresignedRequest, (ConsumerMap)GetObjectRequestConsumer.getInstance());
        try {
            GetObjectPresignRequest request = GetObjectPresignRequest.builder().getObjectRequest((GetObjectRequest)getObjectRequest.build()).signatureDuration(Duration.ofMinutes(5L)).build();
            PresignedGetObjectRequest presignedGetObjectRequest = presigner.presignGetObject(request);
            res = presignedGetObjectRequest.url().toURI().toString();
            Struct struct = new Struct();
            struct.put((Object)"status", (Object)"Success");
            struct.put((Object)"url", (Object)res);
            struct.put((Object)"method", (Object)presignedGetObjectRequest.httpRequest().method().name());
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getPreSignedUrl", (String)"delete", (Object)"Success", (TagAttributeList)this.tagAttributeList);
            return struct;
        }
        catch (URISyntaxException e) {
            this.logger.error((Object)"Error while creating presigned url", (Throwable)e);
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getPreSignedUrl", (String)"delete", (Object)"Failure", (TagAttributeList)this.tagAttributeList);
            throw new S3APIException(RB.getString(S3ServiceImpl.class, (String)"getPreSignedUrlError"), e);
        }
    }

    private boolean isBucketExists(String bucketName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"isBucketExists", (boolean)true);
        List buckets = new LinkedList();
        try {
            buckets = this.s3Client.listBuckets().buckets();
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error while creating bucket", (Throwable)e);
            throw new S3APIException(RB.getString(S3ServiceImpl.class, (String)"errorCheckingBucketExistence"), e);
        }
        boolean res = buckets.stream().anyMatch(bucket -> bucket.name().equals(bucketName));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"isBucketExists", (String)"get", (Object)"Success", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    AWSCredential getCredential() {
        return this.credential;
    }

    S3Client getS3Client() {
        return this.s3Client;
    }

    public Object invoke(String methodName, Object[] args, PageContext pageContext) throws Throwable {
        MethodInvoker MethodInvoker2 = __invokeMethodInvocationMap.get((Object)methodName);
        if (MethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        this.logger.debug((Object)("s3 service method " + methodName + " invoked and started excecution... "));
        long startTime = System.currentTimeMillis();
        Object invokeObject = MethodInvoker2.invoke((Object)this, args);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this.logger.debug((Object)("s3 service method " + methodName + " finished execution successfully. Turn around time : " + timeElapsed + " milli secs"));
        return invokeObject;
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        this.logger.info((Object)("s3 service method " + methodName + " invoked and started excecution... "));
        long startTime = System.currentTimeMillis();
        Object invokeObject = NamedMethodInvoker2.invoke((Object)this, args);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this.logger.info((Object)("s3 service method " + methodName + " finished execution successfully. Turn around time : " + timeElapsed + " milli secs"));
        return invokeObject;
    }

    static {
        __invokeMethodInvocationMap.put((Object)"bucket", (obj, args) -> {
            int count = args != null ? args.length : 0;
            switch (count) {
                case 1: {
                    return obj.bucket(args[0]);
                }
                case 2: {
                    return obj.bucket(Cast._String((Object)args[0]), Cast._boolean((Object)args[1]));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("bucket", obj);
        });
        __invokeMethodInvocationMap.put((Object)"createBucket", (obj, args) -> {
            int count = args != null ? args.length : 0;
            switch (count) {
                case 1: {
                    return obj.createBucket((Struct)Cast._castForInvokeGen((Object)args[0], Struct.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createBucket", obj);
        });
        __invokeMethodInvocationMap.put((Object)"root", (obj, args) -> {
            int count = args != null ? args.length : 0;
            switch (count) {
                case 1: {
                    return obj.root(args[0]);
                }
                case 2: {
                    return obj.root(Cast._String((Object)args[0]), Cast._boolean((Object)args[1]));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("root", obj);
        });
        __invokeMethodInvocationMap.put((Object)"createRoot", (obj, args) -> {
            int count = args != null ? args.length : 0;
            switch (count) {
                case 1: {
                    return obj.createRoot((Struct)Cast._castForInvokeGen((Object)args[0], Struct.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createRoot", obj);
        });
        __invokeMethodInvocationMap.put((Object)"listAll", (obj, args) -> {
            int count = args != null ? args.length : 0;
            switch (count) {
                case 0: {
                    return obj.listAll();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listAll", obj);
        });
        __invokeMethodInvocationMap.put((Object)"delete", (obj, args) -> {
            int count = args != null ? args.length : 0;
            switch (count) {
                case 1: {
                    return obj.delete(args[0]);
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("delete", obj);
        });
        __invokeMethodInvocationMap.put((Object)"getPreSignedUrl", (obj, args) -> {
            int count = args != null ? args.length : 0;
            switch (count) {
                case 1: {
                    return obj.getPreSignedUrl((Struct)Cast._castForInvokeGen((Object)args[0], Struct.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getPreSignedUrl", obj);
        });
        __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();
        __InvokeNamedMethodInvocationMap.put((Object)"bucket", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"bucket"}, args);
                    return obj.bucket(argColl.get((Object)"bucket"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"bucketName", "createIfNotExists"}, args);
                    return obj.bucket(Cast._String((Object)argColl.get((Object)"bucketName")), Cast._boolean((Object)argColl.get((Object)"createIfNotExists")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("bucket", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createBucket", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"createBucketRequest"}, args);
                    return obj.createBucket((Struct)Cast._castForInvokeGen((Object)argColl.get((Object)"createBucketRequest"), Struct.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createBucket", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"root", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"rootName"}, args);
                    return obj.root(argColl.get((Object)"rootName"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"rootName", "createIfNotExists"}, args);
                    return obj.root(Cast._String((Object)argColl.get((Object)"rootName")), Cast._boolean((Object)argColl.get((Object)"createIfNotExists")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("root", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createRoot", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"createRootRequest"}, args);
                    return obj.createRoot((Struct)Cast._castForInvokeGen((Object)argColl.get((Object)"createRootRequest"), Struct.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createRoot", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listAll", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listAll();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listAll", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"delete", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"bucket"}, args);
                    return obj.delete(argColl.get((Object)"bucket"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("delete", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getPreSignedUrl", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"getPresignedRequest"}, args);
                    return obj.getPreSignedUrl((Struct)Cast._castForInvokeGen((Object)argColl.get((Object)"getPresignedRequest"), Struct.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getPreSignedUrl", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"invoke", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"methodName", "args", "pageContext"}, args);
                    return obj.invoke(Cast._String((Object)argColl.get((Object)"methodName")), (Object[])Cast._castForInvokeGen((Object)argColl.get((Object)"args"), Object[].class), (PageContext)Cast._castForInvokeGen((Object)argColl.get((Object)"pageContext"), PageContext.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("invoke", obj);
        });
    }
}

