/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore.impl;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.gcp.firestore.FirestoreDocumentReference;
import coldfusion.cloud.gcp.firestore.FirestoreWriteBatch;
import coldfusion.cloud.gcp.firestore.codecs.FirestoreSerializer;
import coldfusion.cloud.gcp.firestore.impl.FirestoreDocumentReferenceImpl;
import coldfusion.cloud.gcp.firestore.pmt.util.GCPFirestoreApis;
import coldfusion.cloud.gcp.firestore.pmt.util.PMTUtilForGCPFirestore;
import coldfusion.cloud.gcp.firestore.util.FirestoreUtils;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.async.Future;
import coldfusion.util.RB;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.WriteBatch;
import java.util.Map;
import java.util.Objects;

public class FirestoreWriteBatchImpl
implements FirestoreWriteBatch {
    private final WriteBatch writeBatch;
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.FIRESTORE.name());

    public FirestoreWriteBatchImpl(WriteBatch writeBatch) {
        this.writeBatch = writeBatch;
    }

    @Override
    public Future commit() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.commit, this.tagAttributeList);
        String status = "Success";
        try {
            Future future = new Future((java.util.concurrent.Future)this.writeBatch.commit(), FirestoreUtils.getWriteResultListConverter());
            return future;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.commit, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("put", status));
        }
    }

    private void validateArguments(FirestoreDocumentReference documentReference, Map<?, ?> data, String funcName) {
        if (Objects.isNull(documentReference)) {
            throw new ValidationException(RB.getString(FirestoreWriteBatchImpl.class, (String)"DOCUMENT_REFERENCE_NULL"));
        }
        if (Objects.isNull(data)) {
            throw new ValidationException(RB.getString(FirestoreWriteBatchImpl.class, (String)"ATOMIC_DATA_NULL", (Object)"batch", (Object)funcName));
        }
    }

    @Override
    public FirestoreWriteBatch create(FirestoreDocumentReference documentReference, Map<?, ?> data) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.create, this.tagAttributeList);
        String status = "Success";
        try {
            this.validateArguments(documentReference, data, "create");
            if (data instanceof TemplateProxy) {
                data = JSONUtils.getCFCDataAsMap((TemplateProxy)((TemplateProxy)data));
            }
            FirestoreWriteBatchImpl firestoreWriteBatchImpl = new FirestoreWriteBatchImpl((WriteBatch)this.writeBatch.create(((FirestoreDocumentReferenceImpl)documentReference).getReference(), FirestoreSerializer.serializeMap(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty((Object)data))));
            return firestoreWriteBatchImpl;
        }
        catch (IllegalArgumentException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(RB.getString(FirestoreWriteBatchImpl.class, (String)"PROVIDED_INCORRECT_INPUT", (Object)"create"), e);
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.create, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreWriteBatch set(FirestoreDocumentReference documentReference, Map<?, ?> data) {
        return this.set(documentReference, data, false);
    }

    @Override
    public FirestoreWriteBatch set(FirestoreDocumentReference documentReference, Map<?, ?> data, boolean merge) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.set, this.tagAttributeList);
        String status = "Success";
        try {
            this.validateArguments(documentReference, data, "set");
            if (data instanceof TemplateProxy) {
                data = JSONUtils.getCFCDataAsMap((TemplateProxy)((TemplateProxy)data));
            }
            if (merge) {
                FirestoreWriteBatchImpl firestoreWriteBatchImpl = new FirestoreWriteBatchImpl((WriteBatch)this.writeBatch.set(((FirestoreDocumentReferenceImpl)documentReference).getReference(), FirestoreSerializer.serializeMap(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty((Object)data)), SetOptions.merge()));
                return firestoreWriteBatchImpl;
            }
            FirestoreWriteBatchImpl firestoreWriteBatchImpl = new FirestoreWriteBatchImpl((WriteBatch)this.writeBatch.set(((FirestoreDocumentReferenceImpl)documentReference).getReference(), FirestoreSerializer.serializeMap(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty((Object)data))));
            return firestoreWriteBatchImpl;
        }
        catch (IllegalArgumentException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(RB.getString(FirestoreWriteBatchImpl.class, (String)"PROVIDED_INCORRECT_INPUT", (Object)"set"), e);
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.set, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreWriteBatch update(FirestoreDocumentReference documentReference, Map<?, ?> data) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.update, this.tagAttributeList);
        String status = "Success";
        try {
            this.validateArguments(documentReference, data, "update");
            FirestoreWriteBatchImpl firestoreWriteBatchImpl = new FirestoreWriteBatchImpl((WriteBatch)this.writeBatch.update(((FirestoreDocumentReferenceImpl)documentReference).getReference(), FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(data)));
            return firestoreWriteBatchImpl;
        }
        catch (IllegalArgumentException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(RB.getString(FirestoreWriteBatchImpl.class, (String)"PROVIDED_INCORRECT_INPUT", (Object)"update"), e);
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.update, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreWriteBatch delete(FirestoreDocumentReference documentReference) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.delete, this.tagAttributeList);
        String status = "Success";
        try {
            if (Objects.isNull(documentReference)) {
                status = "Failure";
                throw new ValidationException(RB.getString(FirestoreWriteBatchImpl.class, (String)"DOCUMENT_REFERENCE_NULL"));
            }
            FirestoreWriteBatchImpl firestoreWriteBatchImpl = new FirestoreWriteBatchImpl((WriteBatch)this.writeBatch.delete(((FirestoreDocumentReferenceImpl)documentReference).getReference()));
            return firestoreWriteBatchImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.delete, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public int getMutationSize() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.getMutationSize, this.tagAttributeList);
        String status = "Success";
        try {
            int n = this.writeBatch.getMutationsSize();
            return n;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.getMutationSize, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }
}

