/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore.config;

import coldfusion.cloud.consumer.AbstractCloudConfigConsumer;
import coldfusion.cloud.gcp.config.ChannelProviderBuilder;
import coldfusion.cloud.gcp.config.GrpcChannelProvider;
import coldfusion.cloud.gcp.config.RetrySettingsBuilder;
import coldfusion.cloud.gcp.consumer.GrpcChannelProviderConsumer;
import coldfusion.cloud.gcp.consumer.RetrySettingsBuilderConsumer;
import coldfusion.cloud.gcp.firestore.config.FirestoreConfig;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.NonEmptyStringValidator;
import java.util.Collections;
import java.util.Map;

public class FirestoreConfigConsumer
extends AbstractCloudConfigConsumer<FirestoreConfig> {
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static FirestoreConfigConsumer firestoreConfigConsumer = null;

    FirestoreConfigConsumer() {
        this.put("databaseId", new ConsumerValidator((firestoreConfig, value) -> {
            String local = this.cast.getStringProperty(value).trim();
            if (local.length() != 0) {
                firestoreConfig.setDatabaseId(local);
            }
        }, Collections.emptyList()));
        this.put("host", new ConsumerValidator((firestoreConfig, value) -> {
            String local = this.cast.getStringProperty(value).trim();
            if (local.length() != 0) {
                firestoreConfig.setHost(local);
            }
        }, Collections.emptyList()));
        this.put("emulatorHost", new ConsumerValidator((firestoreConfig, value) -> {
            String local = this.cast.getStringProperty(value).trim();
            if (local.length() != 0) {
                firestoreConfig.setEmulatorHost(local);
            }
        }, Collections.emptyList()));
        this.put("quotaProjectId", new ConsumerValidator((firestoreConfig, value) -> firestoreConfig.setQuotaProjectId(this.cast.getStringProperty(value)), Collections.singletonList(NonEmptyStringValidator.INSTANCE)));
        this.put("channelProvider", new ConsumerValidator((firestoreConfig, value) -> firestoreConfig.setChannelProvider(this.populateChannelProvider(this.cast.getStringObjectMapProperty(value))), Collections.emptyList()));
        this.put("headers", new ConsumerValidator((firestoreConfig, value) -> firestoreConfig.setHeaders(this.cast.getStringStringMapProperty(value)), Collections.emptyList()));
        this.put("retrySettings", new ConsumerValidator((firestoreConfig, value) -> firestoreConfig.setRetrySettings(this.populateRetrySettings(this.cast.getStringObjectMapProperty(value))), Collections.emptyList()));
    }

    private ChannelProviderBuilder populateChannelProvider(Map<String, Object> settings) {
        GrpcChannelProvider channelProvider = new GrpcChannelProvider();
        ValidatorFiller.INSTANCE.fillObject((Object)channelProvider, settings, GrpcChannelProviderConsumer.INSTANCE.getGrpcChannelProviderConsumerMap());
        return channelProvider;
    }

    private RetrySettingsBuilder populateRetrySettings(Map<String, Object> settings) {
        RetrySettingsBuilder builder = new RetrySettingsBuilder();
        ValidatorFiller.INSTANCE.fillObject((Object)builder, settings, RetrySettingsBuilderConsumer.INSTANCE.getRetrySettingsMap());
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FirestoreConfigConsumer getInstance() {
        if (firestoreConfigConsumer != null) return firestoreConfigConsumer;
        Class<FirestoreConfigConsumer> clazz = FirestoreConfigConsumer.class;
        synchronized (FirestoreConfigConsumer.class) {
            firestoreConfigConsumer = new FirestoreConfigConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return firestoreConfigConsumer;
        }
    }
}

