/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.cloud.CloudConfigSetService;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchemaFactory;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IndexSchemaFactory
implements NamedListInitializedPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static IndexSchema buildIndexSchema(String resourceName, SolrConfig config) {
        return IndexSchemaFactory.buildIndexSchema(resourceName, config, null);
    }

    public static IndexSchema buildIndexSchema(String resourceName, SolrConfig config, ConfigSetService configSetService) {
        return IndexSchemaFactory.newIndexSchemaFactory(config).create(resourceName, config, configSetService);
    }

    public static IndexSchemaFactory newIndexSchemaFactory(SolrConfig config) {
        IndexSchemaFactory factory;
        PluginInfo info = config.getPluginInfo(IndexSchemaFactory.class.getName());
        if (null != info) {
            factory = config.getResourceLoader().newInstance(info.className, IndexSchemaFactory.class);
            factory.init(info.initArgs);
        } else {
            factory = config.getResourceLoader().newInstance(ManagedIndexSchemaFactory.class.getName(), IndexSchemaFactory.class);
        }
        return factory;
    }

    public String getSchemaResourceName(String cdResourceName) {
        return cdResourceName;
    }

    public IndexSchema create(String resourceName, SolrConfig config, ConfigSetService configSetService) {
        SolrResourceLoader loader = config.getResourceLoader();
        InputStream schemaInputStream = null;
        if (null == resourceName) {
            resourceName = "schema.xml";
        }
        try {
            schemaInputStream = loader.openResource(resourceName);
            return new IndexSchema(resourceName, IndexSchemaFactory.getConfigResource(configSetService, schemaInputStream, loader, resourceName), config.luceneMatchVersion, loader, config.getSubstituteProperties());
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            String msg = "Error loading schema resource " + resourceName;
            log.error(msg, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
        }
    }

    public static ConfigSetService.ConfigResource getConfigResource(ConfigSetService configSetService, InputStream schemaInputStream, SolrResourceLoader loader, String name) throws IOException {
        if (configSetService instanceof CloudConfigSetService && schemaInputStream instanceof ZkSolrResourceLoader.ZkByteArrayInputStream) {
            ZkSolrResourceLoader.ZkByteArrayInputStream is = (ZkSolrResourceLoader.ZkByteArrayInputStream)schemaInputStream;
            Map configCache = (Map)((CloudConfigSetService)configSetService).getSolrCloudManager().getObjectCache().computeIfAbsent((Object)ConfigSetService.ConfigResource.class.getName(), s -> new ConcurrentHashMap());
            VersionedConfig cached = (VersionedConfig)configCache.get(is.fileName);
            if (cached != null) {
                if (cached.version != is.getStat().getVersion()) {
                    configCache.remove(is.fileName);
                } else {
                    return () -> versionedConfig.data;
                }
            }
            return () -> {
                ConfigNode data = ConfigSetService.getParsedSchema(schemaInputStream, loader, name);
                configCache.put(zkByteArrayInputStream.fileName, new VersionedConfig(is.getStat().getVersion(), data));
                return data;
            };
        }
        return () -> ConfigSetService.getParsedSchema(schemaInputStream, loader, name);
    }

    public static class VersionedConfig {
        public final int version;
        public final ConfigNode data;

        public VersionedConfig(int version, ConfigNode data) {
            this.version = version;
            this.data = data;
        }
    }
}

