/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.net.URI;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.backup.BackupFilePaths;
import org.apache.solr.core.backup.ShardBackupId;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.IncrementalShardBackup;
import org.apache.solr.handler.SnapShooter;
import org.apache.solr.handler.admin.CoreAdminHandler;

class BackupCoreOp
implements CoreAdminHandler.CoreAdminOp {
    BackupCoreOp() {
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        SolrParams params = it.req.getParams();
        String cname = params.required().get("core");
        boolean incremental = this.isIncrementalBackup(params);
        String name = this.parseBackupName(params);
        ShardBackupId shardBackupId = this.parseShardBackupId(params);
        String prevShardBackupIdStr = params.get("prevShardBackupId", null);
        String repoName = params.get("repository");
        String commitName = params.get("commitName");
        try (BackupRepository repository = it.handler.coreContainer.newBackupRepository(Optional.ofNullable(repoName));
             SolrCore core = it.handler.coreContainer.getCore(cname);){
            String location = repository.getBackupLocation(params.get("location"));
            if (location == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'location' is not specified as a query parameter or as a default repository property");
            }
            URI locationUri = repository.createURI(location);
            if (incremental) {
                if ("file".equals(locationUri.getScheme())) {
                    core.getCoreContainer().assertPathAllowed(Paths.get(locationUri));
                }
                ShardBackupId prevShardBackupId = prevShardBackupIdStr != null ? ShardBackupId.from(prevShardBackupIdStr) : null;
                BackupFilePaths incBackupFiles = new BackupFilePaths(repository, locationUri);
                IncrementalShardBackup incSnapShooter = new IncrementalShardBackup(repository, core, incBackupFiles, prevShardBackupId, shardBackupId, Optional.ofNullable(commitName));
                NamedList rsp = incSnapShooter.backup();
                it.rsp.addResponse(rsp);
            } else {
                SnapShooter snapShooter = new SnapShooter(repository, core, locationUri, name, commitName);
                if (!snapShooter.getBackupRepository().exists(snapShooter.getLocation())) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Directory to contain snapshots doesn't exist: " + snapShooter.getLocation() + ". " + "Note that Backup/Restore of a SolrCloud collection " + "requires a shared file system mounted at the same path on all nodes!");
                }
                snapShooter.validateCreateSnapshot();
                snapShooter.createSnapshot();
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to backup core=" + cname + " because " + e, (Throwable)e);
        }
    }

    private ShardBackupId parseShardBackupId(SolrParams params) {
        if (this.isIncrementalBackup(params)) {
            return ShardBackupId.from(params.required().get("shardBackupId"));
        }
        return null;
    }

    private String parseBackupName(SolrParams params) {
        if (this.isIncrementalBackup(params)) {
            return null;
        }
        return params.required().get("name");
    }

    private boolean isIncrementalBackup(SolrParams params) {
        return params.getBool("incremental", true);
    }
}

