/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.filestore;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.filestore.PackageStore;
import org.apache.solr.filestore.PackageStoreAPI;
import org.apache.solr.util.SimplePostTool;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistribPackageStore
implements PackageStore {
    static final long MAX_PKG_SIZE = Long.parseLong(System.getProperty("max.file.store.size", String.valueOf(0x6400000)));
    static final String ZK_PACKAGESTORE = "/packagestore";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CoreContainer coreContainer;
    private Map<String, FileInfo> tmpFiles = new ConcurrentHashMap<String, FileInfo>();
    private final Path solrhome;

    public DistribPackageStore(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.solrhome = Paths.get(this.coreContainer.getSolrHome(), new String[0]);
        this.ensurePackageStoreDir(Paths.get(coreContainer.getSolrHome(), new String[0]));
    }

    @Override
    public Path getRealpath(String path) {
        return DistribPackageStore._getRealPath(path, this.solrhome);
    }

    private static Path _getRealPath(String path, Path solrHome) {
        if (File.separatorChar == '\\') {
            path = path.replace('/', File.separatorChar);
        }
        if (!path.isEmpty() && path.charAt(0) != File.separatorChar) {
            path = File.separator + path;
        }
        return new File(solrHome + File.separator + "filestore" + path).toPath();
    }

    @Override
    public void put(PackageStore.FileEntry entry) throws IOException {
        FileInfo info = new FileInfo(entry.path);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Utils.writeJson((Object)entry.getMetaData(), (OutputStream)baos, (boolean)true);
        byte[] bytes = baos.toByteArray();
        info.persistToFile(entry.buf, ByteBuffer.wrap(bytes, 0, bytes.length));
        this.distribute(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void distribute(FileInfo info) {
        try {
            String dirName = info.path.substring(0, info.path.lastIndexOf(47));
            this.coreContainer.getZkController().getZkClient().makePath(ZK_PACKAGESTORE + dirName, false, true);
            this.coreContainer.getZkController().getZkClient().create(ZK_PACKAGESTORE + info.path, info.getDetails().getMetaData().sha512.getBytes(StandardCharsets.UTF_8), CreateMode.PERSISTENT, true);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create an entry in ZK", (Throwable)e);
        }
        this.tmpFiles.put(info.path, info);
        ArrayList<String> nodes = this.coreContainer.getPackageStoreAPI().shuffledNodes();
        int i = 0;
        int FETCHFROM_SRC = 50;
        String myNodeName = this.coreContainer.getZkController().getNodeName();
        try {
            for (String node : nodes) {
                String baseUrl = this.coreContainer.getZkController().getZkStateReader().getBaseUrlForNodeName(node);
                String url = baseUrl.replace("/solr", "/api") + "/node/files" + info.path + "?getFrom=";
                if (i < FETCHFROM_SRC) {
                    url = url + myNodeName;
                } else {
                    if (i == FETCHFROM_SRC) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    url = url + "*";
                }
                try {
                    Utils.executeGET((HttpClient)this.coreContainer.getUpdateShardHandler().getDefaultHttpClient(), (String)url, null);
                }
                catch (Exception e) {
                    log.info("Node: {} failed to respond for file fetch notification", (Object)node, (Object)e);
                }
                ++i;
            }
        }
        finally {
            this.coreContainer.getUpdateShardHandler().getUpdateExecutor().submit(() -> {
                try {
                    Thread.sleep(10000L);
                }
                finally {
                    this.tmpFiles.remove(fileInfo.path);
                }
                return null;
            });
        }
    }

    @Override
    public boolean fetch(String path, String from) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        FileInfo f = new FileInfo(path);
        try {
            if (f.exists(true, false)) {
                return true;
            }
        }
        catch (IOException e) {
            log.error("Error fetching file ", (Throwable)e);
            return false;
        }
        if (from == null || "*".equals(from)) {
            log.info("Missing file in package store: {}", (Object)path);
            if (f.fetchFromAnyNode()) {
                log.info("Successfully downloaded : {}", (Object)path);
                return true;
            }
            log.info("Unable to download file : {}", (Object)path);
            return false;
        }
        f.fetchFileFromNodeAndPersist(from);
        return false;
    }

    @Override
    public void get(String path, Consumer<PackageStore.FileEntry> consumer, boolean fetchmissing) throws IOException {
        File file = this.getRealpath(path).toFile();
        String simpleName = file.getName();
        if (DistribPackageStore.isMetaDataFile(simpleName)) {
            try (final FileInputStream is = new FileInputStream(file);){
                consumer.accept(new PackageStore.FileEntry(null, null, path){

                    @Override
                    public InputStream getInputStream() {
                        return is;
                    }
                });
            }
            return;
        }
        new FileInfo(path).readData(consumer);
    }

    @Override
    public void syncToAllNodes(String path) throws IOException {
        FileInfo fi = new FileInfo(path);
        if (!fi.exists(true, false)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such file : " + path);
        }
        fi.getFileData(true);
        this.distribute(fi);
    }

    @Override
    public List<PackageStore.FileDetails> list(String path, Predicate<String> predicate) {
        File file = this.getRealpath(path).toFile();
        ArrayList<PackageStore.FileDetails> fileDetails = new ArrayList<PackageStore.FileDetails>();
        PackageStore.FileType type = this.getType(path, false);
        if (type == PackageStore.FileType.DIRECTORY) {
            file.list((dir, name) -> {
                if ((predicate == null || predicate.test(name)) && !DistribPackageStore.isMetaDataFile(name)) {
                    fileDetails.add(new FileInfo(path + "/" + name).getDetails());
                }
                return false;
            });
        } else if (type == PackageStore.FileType.FILE) {
            fileDetails.add(new FileInfo(path).getDetails());
        }
        return fileDetails;
    }

    @Override
    public void delete(String path) {
        this.deleteLocal(path);
        ArrayList<String> nodes = this.coreContainer.getPackageStoreAPI().shuffledNodes();
        HttpClient client = this.coreContainer.getUpdateShardHandler().getDefaultHttpClient();
        for (String node : nodes) {
            String baseUrl = this.coreContainer.getZkController().getZkStateReader().getBaseUrlForNodeName(node);
            String url = baseUrl.replace("/solr", "/api") + "/node/files" + path;
            HttpDelete del = new HttpDelete(url);
            this.coreContainer.runAsync(() -> Utils.executeHttpMethod((HttpClient)client, (String)url, null, (HttpRequestBase)del));
        }
    }

    private void checkInZk(String path) {
        try {
            if (this.coreContainer.getZkController().getZkClient().exists(ZK_PACKAGESTORE + path, true).booleanValue()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The path exist ZK, delete and retry");
            }
        }
        catch (SolrException se) {
            throw se;
        }
        catch (Exception e) {
            log.error("Could not connect to ZK", (Throwable)e);
        }
    }

    @Override
    public void deleteLocal(String path) {
        this.checkInZk(path);
        FileInfo f = new FileInfo(path);
        f.deleteFile();
    }

    @Override
    public void refresh(String path) {
        try {
            List l = null;
            try {
                l = this.coreContainer.getZkController().getZkClient().getChildren(ZK_PACKAGESTORE + path, null, true);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
            if (l != null && !l.isEmpty()) {
                List<PackageStore.FileDetails> myFiles = this.list(path, s -> true);
                for (Object f : l) {
                    if (myFiles.contains(f)) continue;
                    log.info("{} does not exist locally, downloading.. ", f);
                    this.fetch(path + "/" + f.toString(), "*");
                }
            }
        }
        catch (Exception e) {
            log.error("Could not refresh files in {}", (Object)path, (Object)e);
        }
    }

    @Override
    public PackageStore.FileType getType(String path, boolean fetchMissing) {
        File file = this.getRealpath(path).toFile();
        if (!file.exists() && fetchMissing && this.fetch(path, null)) {
            file = this.getRealpath(path).toFile();
        }
        return DistribPackageStore._getFileType(file);
    }

    public static PackageStore.FileType _getFileType(File file) {
        if (!file.exists()) {
            return PackageStore.FileType.NOFILE;
        }
        if (file.isDirectory()) {
            return PackageStore.FileType.DIRECTORY;
        }
        return DistribPackageStore.isMetaDataFile(file.getName()) ? PackageStore.FileType.METADATA : PackageStore.FileType.FILE;
    }

    public static boolean isMetaDataFile(String file) {
        return file.charAt(0) == '.' && file.endsWith(".json");
    }

    private void ensurePackageStoreDir(Path solrHome) {
        File packageStoreDir = DistribPackageStore.getPackageStoreDirPath(solrHome).toFile();
        if (!packageStoreDir.exists()) {
            try {
                boolean created = packageStoreDir.mkdirs();
                if (!created) {
                    log.warn("Unable to create [{}] directory in SOLR_HOME [{}].  Features requiring this directory may fail.", (Object)packageStoreDir, (Object)solrHome);
                }
            }
            catch (Exception e) {
                log.warn("Unable to create [{}] directory in SOLR_HOME [{}].  Features requiring this directory may fail.", new Object[]{packageStoreDir, solrHome, e});
            }
        }
    }

    public static Path getPackageStoreDirPath(Path solrHome) {
        return Paths.get(solrHome.toAbsolutePath().toString(), "filestore").toAbsolutePath();
    }

    private static String _getMetapath(String path) {
        int idx = path.lastIndexOf(47);
        return path.substring(0, idx + 1) + "." + path.substring(idx + 1) + ".json";
    }

    public static void _persistToFile(Path solrHome, String path, ByteBuffer data, ByteBuffer meta) throws IOException {
        Map m;
        Path realpath = DistribPackageStore._getRealPath(path, solrHome);
        File file = realpath.toFile();
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if ((m = (Map)Utils.fromJSON((byte[])meta.array(), (int)meta.arrayOffset(), (int)meta.limit())) == null || m.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "invalid metadata , discarding : " + path);
        }
        File metdataFile = DistribPackageStore._getRealPath(DistribPackageStore._getMetapath(path), solrHome).toFile();
        try (FileOutputStream fos = new FileOutputStream(metdataFile);){
            fos.write(meta.array(), 0, meta.limit());
        }
        IOUtils.fsync((Path)metdataFile.toPath(), (boolean)false);
        fos = new FileOutputStream(file);
        var10_10 = null;
        try {
            fos.write(data.array(), 0, data.limit());
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (fos != null) {
                if (var10_10 != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    fos.close();
                }
            }
        }
        IOUtils.fsync((Path)file.toPath(), (boolean)false);
    }

    @Override
    public Map<String, byte[]> getKeys() throws IOException {
        return DistribPackageStore._getKeys(this.solrhome);
    }

    private static Map<String, byte[]> _getKeys(Path solrhome) throws IOException {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        Path keysDir = DistribPackageStore._getRealPath("/_trusted_/keys", solrhome);
        File[] keyFiles = keysDir.toFile().listFiles();
        if (keyFiles == null) {
            return result;
        }
        for (File keyFile : keyFiles) {
            if (!keyFile.isFile() || DistribPackageStore.isMetaDataFile(keyFile.getName())) continue;
            try (FileInputStream fis = new FileInputStream(keyFile);){
                result.put(keyFile.getName(), SimplePostTool.inputStreamToByteArray(fis).array());
            }
        }
        return result;
    }

    public static void deleteZKFileEntry(SolrZkClient client, String path) {
        try {
            client.delete(ZK_PACKAGESTORE + path, -1, true);
        }
        catch (InterruptedException | KeeperException e) {
            log.error("", e);
        }
    }

    class FileInfo {
        final String path;
        String metaPath;
        ByteBuffer fileData;
        ByteBuffer metaData;

        FileInfo(String path) {
            this.path = path;
        }

        ByteBuffer getFileData(boolean validate) throws IOException {
            if (this.fileData == null) {
                try (FileInputStream fis = new FileInputStream(DistribPackageStore.this.getRealpath(this.path).toFile());){
                    this.fileData = SimplePostTool.inputStreamToByteArray(fis);
                }
            }
            return this.fileData;
        }

        public String getMetaPath() {
            if (this.metaPath == null) {
                this.metaPath = DistribPackageStore._getMetapath(this.path);
            }
            return this.metaPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void persistToFile(ByteBuffer data, ByteBuffer meta) throws IOException {
            DistribPackageStore distribPackageStore = DistribPackageStore.this;
            synchronized (distribPackageStore) {
                this.metaData = meta;
                this.fileData = data;
                DistribPackageStore._persistToFile(DistribPackageStore.this.solrhome, this.path, data, meta);
                if (log.isInfoEnabled()) {
                    log.info("persisted a file {} and metadata. sizes {} {}", new Object[]{this.path, data.limit(), meta.limit()});
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean exists(boolean validateContent, boolean fetchMissing) throws IOException {
            File file = DistribPackageStore.this.getRealpath(this.path).toFile();
            if (!file.exists()) {
                if (!fetchMissing) return false;
                return this.fetchFromAnyNode();
            }
            if (!validateContent) return true;
            PackageStoreAPI.MetaData metaData = this.readMetaData();
            if (metaData == null) {
                return false;
            }
            try (FileInputStream is = new FileInputStream(DistribPackageStore.this.getRealpath(this.path).toFile());){
                if (!Objects.equals(DigestUtils.sha512Hex((InputStream)is), metaData.sha512)) {
                    this.deleteFile();
                    return false;
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "unable to parse metadata json file");
            }
        }

        private void deleteFile() {
            try {
                IOUtils.deleteFilesIfExist((Path[])new Path[]{DistribPackageStore.this.getRealpath(this.path), DistribPackageStore.this.getRealpath(this.getMetaPath())});
            }
            catch (IOException e) {
                log.error("Unable to delete files: {}", (Object)this.path);
            }
        }

        private boolean fetchFileFromNodeAndPersist(String fromNode) {
            log.info("fetching a file {} from {} ", (Object)this.path, (Object)fromNode);
            String url = DistribPackageStore.this.coreContainer.getZkController().getZkStateReader().getBaseUrlForNodeName(fromNode);
            if (url == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such node");
            }
            String baseUrl = url.replace("/solr", "/api");
            ByteBuffer metadata = null;
            Map m = null;
            try {
                metadata = (ByteBuffer)Utils.executeGET((HttpClient)DistribPackageStore.this.coreContainer.getUpdateShardHandler().getDefaultHttpClient(), (String)(baseUrl + "/node/files" + this.getMetaPath()), (Utils.InputStreamConsumer)Utils.newBytesConsumer((int)((int)MAX_PKG_SIZE)));
                m = (Map)Utils.fromJSON((byte[])metadata.array(), (int)metadata.arrayOffset(), (int)metadata.limit());
            }
            catch (SolrException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error fetching metadata", (Throwable)e);
            }
            try {
                ByteBuffer filedata = (ByteBuffer)Utils.executeGET((HttpClient)DistribPackageStore.this.coreContainer.getUpdateShardHandler().getDefaultHttpClient(), (String)(baseUrl + "/node/files" + this.path), (Utils.InputStreamConsumer)Utils.newBytesConsumer((int)((int)MAX_PKG_SIZE)));
                String sha512 = DigestUtils.sha512Hex((InputStream)new ByteBufferInputStream(filedata));
                String expected = (String)m.get("sha512");
                if (!sha512.equals(expected)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "sha512 mismatch downloading : " + this.path + " from node : " + fromNode);
                }
                this.persistToFile(filedata, metadata);
                return true;
            }
            catch (SolrException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error fetching data", (Throwable)e);
            }
            catch (IOException ioe) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error persisting file", (Throwable)ioe);
            }
        }

        boolean fetchFromAnyNode() {
            ArrayList<String> l = DistribPackageStore.this.coreContainer.getPackageStoreAPI().shuffledNodes();
            ZkStateReader stateReader = DistribPackageStore.this.coreContainer.getZkController().getZkStateReader();
            for (String liveNode : l) {
                try {
                    boolean success;
                    String baseurl = stateReader.getBaseUrlForNodeName(liveNode);
                    String url = baseurl.replace("/solr", "/api");
                    String reqUrl = url + "/node/files" + this.path + "?meta=true&wt=javabin&omitHeader=true";
                    boolean nodeHasBlob = false;
                    Object nl = Utils.executeGET((HttpClient)DistribPackageStore.this.coreContainer.getUpdateShardHandler().getDefaultHttpClient(), (String)reqUrl, (Utils.InputStreamConsumer)Utils.JAVABINCONSUMER);
                    if (Utils.getObjectByPath((Object)nl, (boolean)false, Arrays.asList("files", this.path)) != null) {
                        nodeHasBlob = true;
                    }
                    if (!nodeHasBlob || !(success = this.fetchFileFromNodeAndPersist(liveNode))) continue;
                    return true;
                }
                catch (Exception exception) {
                }
            }
            return false;
        }

        String getSimpleName() {
            int idx = this.path.lastIndexOf("/");
            if (idx == -1) {
                return this.path;
            }
            return this.path.substring(idx + 1);
        }

        public Path realPath() {
            return DistribPackageStore.this.getRealpath(this.path);
        }

        PackageStoreAPI.MetaData readMetaData() throws IOException {
            File file = DistribPackageStore.this.getRealpath(this.getMetaPath()).toFile();
            if (file.exists()) {
                try (FileInputStream fis = new FileInputStream(file);){
                    PackageStoreAPI.MetaData metaData = new PackageStoreAPI.MetaData((Map)Utils.fromJSON((InputStream)fis));
                    return metaData;
                }
            }
            return null;
        }

        public PackageStore.FileDetails getDetails() {
            final PackageStore.FileType type = DistribPackageStore.this.getType(this.path, false);
            return new PackageStore.FileDetails(){

                @Override
                public PackageStoreAPI.MetaData getMetaData() {
                    try {
                        return FileInfo.this.readMetaData();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public Date getTimeStamp() {
                    return new Date(FileInfo.this.realPath().toFile().lastModified());
                }

                @Override
                public boolean isDir() {
                    return type == PackageStore.FileType.DIRECTORY;
                }

                @Override
                public long size() {
                    return FileInfo.this.realPath().toFile().length();
                }

                public void writeMap(MapWriter.EntryWriter ew) throws IOException {
                    PackageStoreAPI.MetaData metaData = FileInfo.this.readMetaData();
                    ew.put((CharSequence)"name", (CharSequence)FileInfo.this.getSimpleName());
                    if (type == PackageStore.FileType.DIRECTORY) {
                        ew.put((CharSequence)"dir", true);
                        return;
                    }
                    ew.put((CharSequence)"size", this.size());
                    ew.put((CharSequence)"timestamp", (Object)this.getTimeStamp());
                    if (metaData != null) {
                        metaData.writeMap(ew);
                    }
                }
            };
        }

        public void readData(Consumer<PackageStore.FileEntry> consumer) throws IOException {
            PackageStoreAPI.MetaData meta = this.readMetaData();
            try (final FileInputStream is = new FileInputStream(this.realPath().toFile());){
                consumer.accept(new PackageStore.FileEntry(null, meta, this.path){

                    @Override
                    public InputStream getInputStream() {
                        return is;
                    }
                });
            }
        }
    }
}

