/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.AppointmentFilterInfo;
import coldfusion.exchange.ExchangeAppointment;
import coldfusion.exchange.ExchangeConnection;
import coldfusion.exchange.RecurrenceInfo;
import coldfusion.exchange.webdav.Utils;
import coldfusion.exchange.webservice.AvailabilityData;
import coldfusion.exchange.webservice.CFUserAvailability;
import coldfusion.exchange.webservice.EmailAddress;
import coldfusion.tagext.net.exchange.CalendarConstants;
import coldfusion.tagext.net.exchange.CalendarQuery;
import coldfusion.tagext.net.exchange.ExchangeCalendarTag;
import coldfusion.tagext.net.exchange.ExchangeExceptions;
import coldfusion.tagext.net.exchange.RoomQuery;
import coldfusion.tagext.net.exchange.UserAvailabilityQuery;
import coldfusion.tagext.validation.RequiredAttributesException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

class CalendarTagHelper
implements CalendarConstants {
    CalendarTagHelper() {
    }

    static void getCalendarEvents(ExchangeCalendarTag tag) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        boolean returnOccurrence = tag.getGetOccurrence();
        ArrayList calResults = null;
        AppointmentFilterInfo filter = tag.getFilterInfo();
        if (!returnOccurrence) {
            try {
                calResults = con.getAppointments(filter);
            }
            catch (Throwable t) {
                tag.processException(t);
            }
        } else {
            Date startDate = tag.getStartDate();
            Date endDate = tag.getEndDate();
            if (CalendarTagHelper.isFilterSet(tag)) {
                ExchangeExceptions.throwFilterNotSupportedException();
            }
            if (startDate != null && endDate != null && endDate.compareTo(startDate) < 0) {
                ExchangeExceptions.throwInvalidStartEndTimeException();
            }
            try {
                filter.setFromStartTime(startDate);
                filter.setFromEndTime(endDate);
                calResults = con.getAppointmentOccurences(filter);
            }
            catch (Throwable t) {
                tag.processException(t);
            }
        }
        CalendarQuery queryResult = new CalendarQuery();
        queryResult.populate(calResults);
        tag.getPageContext().setAttribute(tag.getName(), (Object)queryResult);
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    private static boolean isFilterSet(ExchangeCalendarTag tag) {
        AppointmentFilterInfo filterInfo = tag.getFilterInfo();
        return filterInfo.getHasAttachment() != null || filterInfo.getIsAllDay() != null || filterInfo.getIsPrivate() != null || filterInfo.getAppStateFlags() != null || filterInfo.getCategories() != null || filterInfo.getDuration() != null || filterInfo.getFromEndTime() != null || filterInfo.getFromId() != null || filterInfo.getFromLastModifiedDate() != null || filterInfo.getFromStartTime() != null || filterInfo.getHref() != null || filterInfo.getImportance() != null || filterInfo.getLabel() != null || filterInfo.getLocation() != null || filterInfo.getMessage() != null || filterInfo.getOptionalAttendees() != null || filterInfo.getOrganizer() != null || filterInfo.getRecurrenceId() != null || filterInfo.getRecurrenceIdRange() != null || filterInfo.getRecurringSeries() != null || filterInfo.getRequiredAttendees() != null || filterInfo.getResources() != null || filterInfo.getSensitivity() != null || filterInfo.getSubject() != null || filterInfo.getToEndTime() != null || filterInfo.getToLastModifiedDate() != null || filterInfo.getToStartTime() != null || filterInfo.getUids() != null;
    }

    static void saveCalendarEvent(ExchangeCalendarTag tag, Map event, boolean isNew) {
        String uidVarName;
        if (!isNew && tag.getUid() != null && tag.getUid().indexOf(44) != -1) {
            ExchangeExceptions.throwMultipleUIDsInModifyActionException("cfexchangecalendar");
        }
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        ExchangeAppointment apt = new ExchangeAppointment();
        Boolean isAllDayObj = tag.getBooleanAttribute(event, "AllDayEvent", false);
        if (isAllDayObj != null) {
            apt.setAllDay(isAllDayObj);
        } else {
            isAllDayObj = Boolean.FALSE;
        }
        Integer intObj = tag.getIntAttribute(event, "Duration", false);
        int duration = -1;
        if (intObj != null) {
            duration = intObj;
            apt.setDuration(duration);
        }
        apt.setStartTime(tag.getDateAttribute(event, "StartTime", isNew));
        if (!isAllDayObj.booleanValue()) {
            if (duration <= 0) {
                apt.setEndTime(tag.getDateAttribute(event, "EndTime", isNew));
            } else {
                Calendar cal = Calendar.getInstance();
                cal.setTime(apt.getStartTime());
                cal.add(12, duration);
                apt.setEndTime(cal.getTime());
            }
        } else {
            apt.setEndTime(tag.getDateAttribute(event, "EndTime", false));
        }
        String tmpStr = null;
        Integer tmpInt = null;
        apt.setSubject(tag.getStringAttribute(event, "Subject", false));
        apt.setMessage(tag.getStringAttribute(event, "Message", false));
        apt.setLocation(tag.getStringAttribute(event, "Location", false));
        apt.setOrganizer(tag.getStringAttribute(event, "Organizer", false));
        tmpStr = tag.getStringAttribute(event, "Sensitivity", false);
        if (tmpStr != null) {
            if (!tag.validateSensitivity(tmpStr)) {
                ExchangeExceptions.throwInvalidSensitivityException("Sensitivity");
            }
            apt.setSensitivity(tmpStr);
        }
        if ((tmpStr = tag.getStringAttribute(event, "Importance", false)) != null) {
            if (!tag.validateImportance(tmpStr)) {
                ExchangeExceptions.throwInvalidImportanceException("Importance");
            }
            apt.setImportance(tmpStr);
        }
        String attendees = tag.getStringAttribute(event, "RequiredAttendees", false);
        try {
            if (attendees != null) {
                InternetAddress.parse((String)attendees, (boolean)true);
            }
        }
        catch (AddressException e) {
            ExchangeExceptions.throwInvalidEmailException("RequiredAttendees");
        }
        if (attendees != null && attendees.trim().length() != 0) {
            apt.setRequiredAttendees(attendees);
        }
        attendees = tag.getStringAttribute(event, "OptionalAttendees", false);
        try {
            if (attendees != null) {
                InternetAddress.parse((String)attendees, (boolean)true);
            }
        }
        catch (AddressException e) {
            ExchangeExceptions.throwInvalidEmailException("OptionalAttendees");
        }
        if (attendees != null && attendees.trim().length() != 0) {
            apt.setOptionalAttendees(attendees);
        }
        apt.setResources(tag.getStringAttribute(event, "Resources", false));
        tmpInt = tag.getIntAttribute(event, "reminder", false);
        if (tmpInt != null) {
            apt.setReminderPeriod((int)tmpInt);
        }
        CalendarTagHelper.setRecurrentInfo(tag, event, apt);
        apt.setRecurrenceId(tag.getStringAttribute(event, "recurrenceid", false));
        apt.setRecurrenceIdRange(tag.getStringAttribute(event, "recurrenceidrange", false));
        apt.setTimeZone(tag.getStringAttribute(event, "TimeZone", false));
        if (!isNew) {
            String id = tag.getUid();
            if (id == null) {
                throw new RequiredAttributesException(tag.getTagPublicName(), "uid");
            }
            apt.setId(id);
        }
        apt.setCategories(tag.getStringAttribute(event, "Categories", false));
        tmpStr = tag.getStringAttribute(event, "Label", false);
        if (tmpStr != null) {
            int labelCode = CalendarTagHelper.getLabelCode(tmpStr);
            if (labelCode < 0) {
                ExchangeExceptions.throwInvalidLabelException("Label");
            }
            apt.setLabel(new Integer(labelCode));
        }
        String attachmentPaths = tag.getStringAttribute(event, "attachments", false);
        String[] attachedFileNames = null;
        Object[] attachedFilecontent = null;
        if (attachmentPaths != null) {
            Object[] tmpArray = tag.readAttachmentFiles(attachmentPaths);
            attachedFileNames = (String[])tmpArray[0];
            attachedFilecontent = (Object[])tmpArray[1];
        }
        try {
            if (isNew) {
                String calendarFolderUid = tag.getFolderId();
                String folderPath = tag.getFolderPath();
                if (calendarFolderUid != null) {
                    apt.setCalendarFolderId(calendarFolderUid.trim());
                } else if (folderPath != null) {
                    apt.setCalendarFolderPath(folderPath);
                    apt.setPathDelimitter(tag.getPathDelimiter());
                }
                if (attachmentPaths != null) {
                    con.createAppointment(apt, attachedFileNames, attachedFilecontent, tag.isNotify());
                } else {
                    con.createAppointment(apt, tag.isNotify());
                }
            } else if (attachmentPaths != null) {
                con.modifyAppointment(tag.getFilterInfo(), apt, attachedFileNames, attachedFilecontent, tag.isNotify());
            } else {
                con.modifyAppointments(tag.getFilterInfo(), new String[]{apt.getId()}, apt, null, null, tag.isNotify());
            }
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (isNew && (uidVarName = tag.getResult()) != null) {
            tag.getPageContext().setAttribute(uidVarName, (Object)apt.getId());
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    private static void setRecurrentInfo(ExchangeCalendarTag tag, Map event, ExchangeAppointment apt) {
        String recurrDay;
        String recurrWeek;
        Integer intObj;
        Boolean isRecurrent = tag.getBooleanAttribute(event, "IsRecurring", false);
        if (isRecurrent == null || !isRecurrent.booleanValue()) {
            return;
        }
        String recurrenceType = tag.getStringAttribute(event, "RecurrenceType", false);
        if (recurrenceType == null) {
            if (isRecurrent != null && isRecurrent.booleanValue()) {
                recurrenceType = "DAILY";
            } else {
                return;
            }
        }
        RecurrenceInfo rInfo = new RecurrenceInfo();
        int recurrenceFreqType = -1;
        if (recurrenceType.trim().equalsIgnoreCase("DAILY")) {
            recurrenceFreqType = 1;
        } else if (recurrenceType.trim().equalsIgnoreCase("WEEKLY")) {
            recurrenceFreqType = 2;
        } else if (recurrenceType.trim().equalsIgnoreCase("MONTHLY")) {
            recurrenceFreqType = 3;
        } else if (recurrenceType.trim().equalsIgnoreCase("YEARLY")) {
            recurrenceFreqType = 4;
        } else {
            ExchangeExceptions.throwInvalidRecurrenceTypeException("RecurrenceType");
        }
        Date startTime = apt.getStartTime();
        if (recurrenceFreqType == 1) {
            intObj = tag.getIntAttribute(event, "RecurrenceFrequency", false);
            Boolean everyWeekDay = tag.getBooleanAttribute(event, "RecurEveryWeekDay", false);
            if (everyWeekDay != null && everyWeekDay.booleanValue()) {
                rInfo.setRecurrenceEveryWeekDay();
            } else {
                rInfo.setDailyRecurrence(intObj == null ? 1 : intObj);
            }
        } else if (recurrenceFreqType == 2) {
            intObj = tag.getIntAttribute(event, "RecurrenceFrequency", false);
            String weekDays = tag.getStringAttribute(event, "RecurrenceDays", false);
            if (weekDays == null) {
                weekDays = startTime != null ? CalendarTagHelper.getDayOfWeek(startTime) : "MON";
            }
            weekDays = CalendarTagHelper.cfToExchangeWeekDays(weekDays, tag.getAction(), "RecurrenceDays");
            rInfo.setWeeklyRecurrence(intObj == null ? 1 : intObj, weekDays);
        } else if (recurrenceFreqType == 3) {
            intObj = tag.getIntAttribute(event, "RecurrenceFrequency", false);
            recurrWeek = tag.getStringAttribute(event, "RecurrenceWeek", false);
            if (recurrWeek == null) {
                rInfo.setMonthlyRecurrence(intObj == null ? 1 : intObj);
            } else {
                recurrDay = tag.getStringAttribute(event, "RecurrenceDay", false);
                if (recurrDay == null) {
                    recurrDay = apt.getStartTime() != null ? CalendarTagHelper.getDayOfWeek(apt.getStartTime()) : "MON";
                }
                recurrDay = CalendarTagHelper.cfToExchangeWeekDays(recurrDay, tag.getAction(), "RecurrenceDay");
                rInfo.setMonthlyRecurrence(recurrWeek, recurrDay, intObj == null ? 1 : intObj);
            }
        } else if (recurrenceFreqType == 4) {
            recurrWeek = tag.getStringAttribute(event, "RecurrenceWeek", false);
            if (recurrWeek == null) {
                rInfo.setYearlyRecurrence();
            } else {
                recurrDay = tag.getStringAttribute(event, "RecurrenceDay", false);
                String recurrMonth = tag.getStringAttribute(event, "RecurrenceMonth", false);
                int monthNum = 1;
                if (recurrMonth != null) {
                    monthNum = CalendarTagHelper.validateMonth(recurrMonth, tag.getAction(), "RecurrenceMonth");
                } else if (apt.getStartTime() != null) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(apt.getStartTime());
                    monthNum = cal.get(2) + 1;
                }
                if (recurrDay == null) {
                    recurrDay = apt.getStartTime() != null ? CalendarTagHelper.getDayOfWeek(apt.getStartTime()) : "MON";
                }
                recurrDay = CalendarTagHelper.cfToExchangeWeekDays(recurrDay, tag.getAction(), "RecurrenceDay");
                rInfo.setYearlyRecurrence(recurrWeek, recurrDay, monthNum);
            }
        }
        Boolean noEndDate = tag.getBooleanAttribute(event, "RecurrenceNoEndDate", false);
        intObj = tag.getIntAttribute(event, "RecurrenceCount", false);
        Date endDate = tag.getDateAttribute(event, "RecurrenceEndDate", false);
        if (noEndDate != null) {
            if (intObj != null) {
                ExchangeExceptions.throwInvalidRecurrenceFrequency("RecurrenceNoEndDate", "RecurrenceCount", "RecurrenceEndDate");
            }
            if (endDate != null) {
                ExchangeExceptions.throwInvalidRecurrenceFrequency("RecurrenceNoEndDate", "RecurrenceCount", "RecurrenceEndDate");
            }
            rInfo.setNoRecurrenceEndDate();
        } else if (intObj != null) {
            if (endDate != null) {
                ExchangeExceptions.throwInvalidRecurrenceFrequency("RecurrenceNoEndDate", "RecurrenceCount", "RecurrenceEndDate");
            }
            rInfo.setEndRecurrenceAfterCount(intObj);
        } else if (endDate != null) {
            rInfo.setEndRecurrenceByDate(endDate);
        } else {
            rInfo.setNoRecurrenceEndDate();
        }
        apt.setRecurringSeries(true);
        apt.setRecurrenceInfo(rInfo);
    }

    private static int validateMonth(String strMonth, String action, String attribName) {
        if (strMonth.equalsIgnoreCase("JAN")) {
            return 1;
        }
        if (strMonth.equalsIgnoreCase("FEB")) {
            return 2;
        }
        if (strMonth.equalsIgnoreCase("MAR")) {
            return 3;
        }
        if (strMonth.equalsIgnoreCase("APR")) {
            return 4;
        }
        if (strMonth.equalsIgnoreCase("MAY")) {
            return 5;
        }
        if (strMonth.equalsIgnoreCase("JUN")) {
            return 5;
        }
        if (strMonth.equalsIgnoreCase("JUL")) {
            return 7;
        }
        if (strMonth.equalsIgnoreCase("AUG")) {
            return 8;
        }
        if (strMonth.equalsIgnoreCase("SEP")) {
            return 9;
        }
        if (strMonth.equalsIgnoreCase("OCT")) {
            return 10;
        }
        if (strMonth.equalsIgnoreCase("NOV")) {
            return 11;
        }
        if (strMonth.equalsIgnoreCase("DEC")) {
            return 12;
        }
        ExchangeExceptions.throwInvalidExchangeMonthValue(attribName);
        return -1;
    }

    private static String cfToExchangeWeekDays(String weekDays, String action, String attribName) {
        String[] weekDaysArray = Utils.splitString(weekDays);
        if (weekDaysArray == null || weekDaysArray.length == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < weekDaysArray.length; ++i) {
            String aWeekDay = weekDaysArray[i].trim();
            if (!first) {
                buf.append(",");
            } else {
                first = false;
            }
            if (aWeekDay.equalsIgnoreCase("MON")) {
                buf.append("MO");
                continue;
            }
            if (aWeekDay.equalsIgnoreCase("TUE")) {
                buf.append("TU");
                continue;
            }
            if (aWeekDay.equalsIgnoreCase("WED")) {
                buf.append("WE");
                continue;
            }
            if (aWeekDay.equalsIgnoreCase("THU")) {
                buf.append("TH");
                continue;
            }
            if (aWeekDay.equalsIgnoreCase("FRI")) {
                buf.append("FR");
                continue;
            }
            if (aWeekDay.equalsIgnoreCase("SAT")) {
                buf.append("SA");
                continue;
            }
            if (aWeekDay.equalsIgnoreCase("SUN")) {
                buf.append("SU");
                continue;
            }
            ExchangeExceptions.throwInvalidExchangeDayValue(attribName);
        }
        return buf.toString();
    }

    private static String getDayOfWeek(Date aDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(aDate);
        int day = cal.get(7);
        switch (day) {
            case 1: {
                return "SUN";
            }
            case 2: {
                return "MON";
            }
            case 3: {
                return "TUE";
            }
            case 4: {
                return "WED";
            }
            case 5: {
                return "THU";
            }
            case 6: {
                return "FRI";
            }
            case 7: {
                return "SAT";
            }
        }
        return "MON";
    }

    static void deleteCalendarEvents(ExchangeCalendarTag tag) {
        String uids;
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        if ((uids = tag.getUid()) == null) {
            throw new RequiredAttributesException(tag.getTagPublicName(), "uid");
        }
        String[] uidArray = Utils.splitString(uids);
        boolean notify = tag.isNotify();
        String message = null;
        message = tag.getMessage();
        if (!notify && message != null && message.trim().length() > 0) {
            notify = true;
        }
        try {
            con.deleteAppointments(uidArray, notify, message);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    static void respondCalendarEvent(ExchangeCalendarTag tag) {
        String uid;
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        if ((uid = tag.getUid()) == null) {
            throw new RequiredAttributesException(tag.getTagPublicName(), "uid");
        }
        String respType = tag.getResponseType();
        if (respType == null) {
            throw new RequiredAttributesException(tag.getTagPublicName(), "responseType");
        }
        int responseType = 0;
        if (respType.equalsIgnoreCase("accept")) {
            responseType = 3;
        } else if (respType.equalsIgnoreCase("tentative")) {
            responseType = 2;
        } else if (respType.equalsIgnoreCase("decline")) {
            responseType = 4;
        } else {
            ExchangeExceptions.throwInvalidCalendarResponseType("responseType");
        }
        boolean notify = tag.isNotify();
        String message = null;
        message = tag.getMessage();
        if (!notify && message != null && message.trim().length() > 0) {
            notify = true;
        }
        try {
            con.responseToMeetingRequest(uid, responseType, notify, message);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static int getLabelCode(String labelDesc) {
        if (labelDesc.equalsIgnoreCase("None")) {
            return 0;
        }
        if (labelDesc.equalsIgnoreCase("Important")) {
            return 1;
        }
        if (labelDesc.equalsIgnoreCase("Business")) {
            return 2;
        }
        if (labelDesc.equalsIgnoreCase("Personal")) {
            return 3;
        }
        if (labelDesc.equalsIgnoreCase("Vacation")) {
            return 4;
        }
        if (labelDesc.equalsIgnoreCase("Must Attend")) {
            return 5;
        }
        if (labelDesc.equalsIgnoreCase("Travel Required")) {
            return 6;
        }
        if (labelDesc.equalsIgnoreCase("Needs Preparation")) {
            return 7;
        }
        if (labelDesc.equalsIgnoreCase("Birthday")) {
            return 8;
        }
        if (labelDesc.equalsIgnoreCase("Anniversary")) {
            return 9;
        }
        if (labelDesc.equalsIgnoreCase("Phone Call")) {
            return 10;
        }
        try {
            return Integer.parseInt(labelDesc);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static String getLabelDesc(int labelCode) {
        switch (labelCode) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Important";
            }
            case 2: {
                return "Business";
            }
            case 3: {
                return "Personal";
            }
            case 4: {
                return "Vacation";
            }
            case 5: {
                return "Must Attend";
            }
            case 6: {
                return "Travel Required";
            }
            case 7: {
                return "Needs Preparation";
            }
            case 8: {
                return "Birthday";
            }
            case 9: {
                return "Anniversary";
            }
            case 10: {
                return "Phone Call";
            }
        }
        return String.valueOf(labelCode);
    }

    public static void getRoomList(ExchangeCalendarTag tag) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        ArrayList calResults = null;
        try {
            calResults = con.getRoomList();
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        RoomQuery queryResult = new RoomQuery();
        queryResult.populate(calResults);
        tag.getPageContext().setAttribute(tag.getName(), (Object)queryResult);
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void getRooms(ExchangeCalendarTag tag) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        ArrayList calResults = null;
        try {
            String roomListAddress = tag.getEmailAddress();
            EmailAddress address = new EmailAddress();
            address.setAddress(roomListAddress);
            calResults = con.getRooms(address);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        RoomQuery queryResult = new RoomQuery();
        queryResult.populate(calResults);
        tag.getPageContext().setAttribute(tag.getName(), (Object)queryResult);
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void getUserAvailability(ExchangeCalendarTag tag) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        CFUserAvailability userAvailability = null;
        try {
            String attendeesStr = tag.getAttendees();
            String[] splits = Utils.splitString(attendeesStr);
            ArrayList<String> attendees = new ArrayList<String>();
            for (String string : splits) {
                attendees.add(string.trim());
            }
            Date startDate = tag.getStartDate();
            Date endDate = tag.getEndDate();
            if (startDate != null && endDate != null && endDate.compareTo(startDate) < 0) {
                ExchangeExceptions.throwInvalidStartEndTimeException();
            }
            AvailabilityData type = tag.getDataRequestType();
            userAvailability = con.getUserAvailability(attendees, startDate, endDate, type);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        UserAvailabilityQuery queryResult = new UserAvailabilityQuery();
        queryResult.populate(userAvailability);
        tag.getPageContext().setAttribute(tag.getName(), (Object)queryResult);
        if (getTempConnection) {
            con.closeConnection();
        }
    }
}

