/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.ExchangeAttachment;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.net.exchange.AttachmentQueryMetaData;
import coldfusion.tagext.net.exchange.ExchangeExceptions;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class AttachmentQuery
extends QueryTable {
    public void populate(ArrayList resultArray, String dirPath, boolean generateUniqueFileNames) {
        this.meta = new AttachmentQueryMetaData();
        this.col_count = this.meta.getColumnCount();
        this.col_names = this.meta.getColumnLabels();
        if (resultArray == null || resultArray.size() == 0) {
            this.row_count = 0;
            return;
        }
        this.ensureCapacity(resultArray.size());
        for (ExchangeAttachment atch : resultArray) {
            Object[] colData = new Object[this.col_count];
            colData[0] = atch.getFileName();
            colData[1] = atch.getMimeType();
            colData[2] = atch.getFileSize();
            colData[3] = atch.isMessage();
            colData[4] = "";
            this.addRow(colData);
            if (dirPath != null && atch.isMessage() != null && !atch.isMessage().booleanValue()) {
                File attachmentFile = null;
                try {
                    String attchFileName = atch.getFileName();
                    if (attchFileName.contains("\\")) {
                        attchFileName = attchFileName.replace("\\", "");
                    }
                    if (attchFileName.contains("/")) {
                        attchFileName = attchFileName.replace("/", "");
                    }
                    attachmentFile = Utils.getFullName((String)dirPath, (String)attchFileName, (boolean)generateUniqueFileNames);
                    colData[4] = attachmentFile.getAbsolutePath();
                    this.saveAttachment(attachmentFile, atch.getFileContent());
                }
                catch (IOException e) {
                    ExchangeExceptions.throwExchangeAttachmentIOException(attachmentFile == null ? atch.getFileName() : attachmentFile.getAbsolutePath());
                }
            }
            colData[5] = atch.getCID();
            if (colData[5] != null) continue;
            colData[5] = "";
        }
    }

    private void saveAttachment(File attachFile, byte[] content) throws IOException {
        if (content == null) {
            return;
        }
        if (!attachFile.exists()) {
            attachFile.createNewFile();
        }
        OutputStream outStream = VFSFileFactory.getOutputStream((File)attachFile);
        outStream.write(content);
        outStream.close();
    }
}

